/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.pdf.TOCHandler;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;

public class PDFEmitter
implements IContentEmitter {
    protected static Logger logger = Logger.getLogger(PDFEmitter.class.getName());
    protected PDFRender render = new PDFRender();

    public String getOutputFormat() {
        return this.render.getOutputFormat();
    }

    public void initialize(IEmitterServices service) {
        this.render.initialize(service);
    }

    public void startPage(IPageContent page) {
        PageArea pageArea = (PageArea)page.getExtension(1);
        if (pageArea != null) {
            pageArea.accept((IAreaVisitor)this.render);
        }
    }

    public void start(IReportContent report) {
        this.render.start(report);
    }

    public void end(IReportContent report) {
        this.render.end(report);
    }

    public void startAutoText(IAutoTextContent autoText) {
        ITextArea totalPage = (ITextArea)autoText.getExtension(1);
        this.render.setTotalPage(totalPage);
    }

    public void endCell(ICellContent cell) {
    }

    public void endContainer(IContainerContent container) {
    }

    public void endContent(IContent content) {
    }

    public void endList(IListContent list) {
    }

    public void endListBand(IListBandContent listBand) {
    }

    public void endPage(IPageContent page) {
    }

    public void endRow(IRowContent row) {
    }

    public void endTable(ITableContent table) {
    }

    public void endTableBody(ITableBandContent band) {
    }

    public void endTableFooter(ITableBandContent band) {
    }

    public void endTableHeader(ITableBandContent band) {
    }

    public void startCell(ICellContent cell) {
    }

    public void startContainer(IContainerContent container) {
    }

    public void startContent(IContent content) {
    }

    public void startData(IDataContent data) {
    }

    public void startForeign(IForeignContent foreign) {
    }

    public void startImage(IImageContent image) {
    }

    public void startLabel(ILabelContent label) {
    }

    public void startList(IListContent list) {
    }

    public void startListBand(IListBandContent listBand) {
    }

    public void startRow(IRowContent row) {
    }

    public void startTable(ITableContent table) {
    }

    public void startTableBody(ITableBandContent band) {
    }

    public void startTableFooter(ITableBandContent band) {
    }

    public void startTableHeader(ITableBandContent band) {
    }

    public void startText(ITextContent text) {
    }

    public void endGroup(IGroupContent group) {
    }

    public void endListGroup(IListGroupContent group) {
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
    }

    public void startGroup(IGroupContent group) {
    }

    public void startListGroup(IListGroupContent group) {
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
    }

    protected class PDFRender
    implements IAreaVisitor {
        public static final String REPORT_FILE = "Report.pdf";
        public static final String IMAGE_FOLDER = "image";
        private OutputStream output = null;
        public static final float LAYOUT_TO_PDF_RATIO = 1000.0f;
        private Document doc = null;
        private PdfWriter writer = null;
        private PdfTemplate tpl = null;
        private int tplWidth = 0;
        private int tplHeight = 0;
        private PdfContentByte cb;
        private PdfContentByte cbUnder = null;
        private float pageHeight;
        private float pageWidth = 0.0f;
        protected IReportContent report;
        protected IReportRunnable reportRunnable;
        protected ReportDesignHandle reportDesign;
        protected PDFRenderContext context;
        protected IEmitterServices services;
        private Stack containerStack = new Stack();
        static final /* synthetic */ boolean $assertionsDisabled;

        protected PDFRender() {
        }

        public String getOutputFormat() {
            return "pdf";
        }

        public void initialize(IEmitterServices services) {
            Object con;
            Object renderContext;
            this.services = services;
            this.reportRunnable = services.getReportRunnable();
            if (this.reportRunnable != null) {
                this.reportDesign = (ReportDesignHandle)this.reportRunnable.getDesignHandle();
            }
            if ((renderContext = services.getRenderContext()) != null && renderContext instanceof Map && (con = ((Map)renderContext).get("PDF_RENDER_CONTEXT")) instanceof PDFRenderContext) {
                this.context = (PDFRenderContext)con;
            }
            Object fd = services.getOption("outputFile");
            File file = null;
            try {
                if (fd != null) {
                    file = new File(fd.toString());
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    this.output = new FileOutputStream(file);
                }
            }
            catch (FileNotFoundException fnfe) {
                logger.log(Level.WARNING, fnfe.getMessage(), fnfe);
            }
            if (this.output == null) {
                Object value = services.getOption("outputStream");
                if (value != null && value instanceof OutputStream) {
                    this.output = (OutputStream)value;
                } else {
                    try {
                        file = new File(REPORT_FILE);
                        this.output = new FileOutputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }

        public void start(IReportContent rc) {
            this.report = rc;
            this.doc = new Document();
            try {
                this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(this.output));
                ReportDesignHandle designHandle = this.report.getDesign().getReportDesign();
                String title = designHandle.getStringProperty("title");
                if (null != title) {
                    this.doc.addTitle(title);
                }
            }
            catch (DocumentException de) {
                logger.log(Level.SEVERE, de.getMessage(), de);
            }
        }

        public void end(IReportContent rc) {
            TOCHandler tocHandler = new TOCHandler(rc.getTOC());
            TOCNode tocRoot = tocHandler.getTOCRoot();
            if (tocRoot.getChildren().isEmpty()) {
                this.writer.setViewerPreferences(16);
            } else {
                this.writer.setViewerPreferences(32);
                PdfOutline root = this.cb.getRootOutline();
                tocHandler.createTOC(tocRoot, root);
            }
            if (this.doc.isOpen()) {
                this.doc.close();
            }
        }

        public void setTotalPage(ITextArea totalPage) {
            this.drawTextAt(totalPage, 0, 0, (PdfContentByte)this.tpl, this.tpl.getHeight());
        }

        public void visitText(ITextArea textArea) {
            ContainerPosition curPos = !this.containerStack.isEmpty() ? (ContainerPosition)this.containerStack.peek() : new ContainerPosition(0, 0);
            int x = curPos.x + textArea.getX();
            int y = curPos.y + textArea.getY();
            this.drawTextAt(textArea, x, y, this.cb, this.pageHeight);
            this.makeBookmark((IArea)textArea, curPos);
            this.handleHyperlinkAction((IArea)textArea, curPos);
        }

        public void visitImage(IImageArea imageArea) {
            this.drawImage(imageArea);
        }

        public void visitAutoText(ITemplateArea templateArea) {
            if (!$assertionsDisabled && this.cb == null) {
                throw new AssertionError();
            }
            if (null == this.tpl) {
                this.tplWidth = templateArea.getWidth();
                this.tplHeight = templateArea.getHeight();
                this.tpl = this.cb.createTemplate(this.pdfMeasure(this.tplWidth), this.pdfMeasure(this.tplHeight));
            }
            this.cb.saveState();
            ContainerPosition curPos = !this.containerStack.isEmpty() ? (ContainerPosition)this.containerStack.peek() : new ContainerPosition(0, 0);
            float x = this.layoutAreaX2PDF(curPos.x + templateArea.getX());
            float y = this.layoutAreaY2PDF(curPos.y + templateArea.getY(), this.tplHeight);
            this.cb.addTemplate(this.tpl, x, y);
            this.cb.restoreState();
        }

        public void startContainer(IContainerArea container) {
            if (container instanceof PageArea) {
                this.newPage(container);
                this.containerStack.push(new ContainerPosition(0, 0));
            } else {
                this.drawContainer(container);
                if (!this.containerStack.isEmpty()) {
                    ContainerPosition pos = (ContainerPosition)this.containerStack.peek();
                    ContainerPosition current = new ContainerPosition(pos.x + container.getX(), pos.y + container.getY());
                    this.containerStack.push(current);
                } else {
                    this.containerStack.push(new ContainerPosition(container.getX(), container.getY()));
                }
            }
        }

        public void endContainer(IContainerArea container) {
            if (!this.containerStack.isEmpty()) {
                this.containerStack.pop();
            }
        }

        protected void newPage(IContainerArea page) {
            this.pageHeight = this.pdfMeasure(page.getHeight());
            this.pageWidth = this.pdfMeasure(page.getWidth());
            Rectangle pageSize = new Rectangle(this.pageWidth, this.pageHeight);
            try {
                this.doc.setPageSize(pageSize);
                if (!this.doc.isOpen()) {
                    this.doc.open();
                    this.cb = this.writer.getDirectContent();
                    this.cbUnder = this.writer.getDirectContentUnder();
                }
                this.doc.newPage();
                this.doc.add((Element)Chunk.NEWLINE);
            }
            catch (DocumentException de) {
                logger.log(Level.SEVERE, de.getMessage(), de);
            }
            Color bc = PropertyUtil.getColor((CSSValue)page.getStyle().getProperty(20));
            this.drawBackgroundColor(bc, 0.0f, this.pageHeight, this.pageWidth, this.pageHeight);
            this.drawBackgroundImage(page.getStyle(), 0.0f, this.pageHeight, this.pageWidth, this.pageHeight);
        }

        private void drawBackgroundImage(IStyle containerStyle, float startX, float startY, float width, float height) {
            boolean yMode;
            float positionY;
            boolean xMode;
            float positionX;
            String bi = PropertyUtil.getBackgroundImage((CSSValue)containerStyle.getProperty(9));
            FloatValue positionValX = (FloatValue)containerStyle.getProperty(45);
            FloatValue positionValY = (FloatValue)containerStyle.getProperty(35);
            if (bi == null || positionValX == null || positionValY == null) {
                return;
            }
            if (positionValX.getPrimitiveType() == 2) {
                positionX = PropertyUtil.getPercentageValue((CSSValue)positionValX);
                xMode = true;
            } else {
                positionX = this.pdfMeasure(PropertyUtil.getDimensionValue((CSSValue)positionValX));
                xMode = false;
            }
            if (positionValY.getPrimitiveType() == 2) {
                positionY = PropertyUtil.getPercentageValue((CSSValue)positionValY);
                yMode = true;
            } else {
                positionY = this.pdfMeasure(PropertyUtil.getDimensionValue((CSSValue)positionValY));
                yMode = false;
            }
            this.drawBackgroundImage(bi, startX, startY, width, height, positionX, positionY, containerStyle.getBackgroundRepeat(), xMode, yMode);
        }

        protected void drawContainer(IContainerArea container) {
            IStyle style = container.getStyle();
            if (null == style) {
                return;
            }
            ContainerPosition curPos = !this.containerStack.isEmpty() ? (ContainerPosition)this.containerStack.peek() : new ContainerPosition(0, 0);
            int layoutX = curPos.x + container.getX();
            int layoutY = curPos.y + container.getY();
            float startX = this.layoutPointX2PDF(layoutX);
            float startY = this.layoutPointY2PDF(layoutY);
            float width = this.pdfMeasure(container.getWidth());
            float height = this.pdfMeasure(container.getHeight());
            Color bc = PropertyUtil.getColor((CSSValue)style.getProperty(20));
            this.drawBackgroundColor(bc, startX, startY, width, height);
            this.drawBackgroundImage(style, startX, startY, width, height);
            int borderTopWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(15));
            int borderLeftWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(17));
            int borderBottomWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(19));
            int borderRightWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(18));
            Color borderTopColor = PropertyUtil.getColor((CSSValue)style.getProperty(21));
            Color borderRightColor = PropertyUtil.getColor((CSSValue)style.getProperty(23));
            Color borderBottomColor = PropertyUtil.getColor((CSSValue)style.getProperty(24));
            Color borderLeftColor = PropertyUtil.getColor((CSSValue)style.getProperty(22));
            BorderInfo[] borders = new BorderInfo[]{new BorderInfo(layoutX, layoutY + borderTopWidth / 2, layoutX + container.getWidth(), layoutY + borderTopWidth / 2, borderTopWidth, borderTopColor, container.getStyle().getBorderTopStyle(), 0), new BorderInfo(layoutX + container.getWidth() - borderRightWidth / 2, layoutY, layoutX + container.getWidth() - borderRightWidth / 2, layoutY + container.getHeight(), borderRightWidth, borderRightColor, container.getStyle().getBorderRightStyle(), 1), new BorderInfo(layoutX, layoutY + container.getHeight() - borderBottomWidth / 2, layoutX + container.getWidth(), layoutY + container.getHeight() - borderBottomWidth / 2, borderBottomWidth, borderBottomColor, container.getStyle().getBorderBottomStyle(), 2), new BorderInfo(layoutX + borderLeftWidth / 2, layoutY, layoutX + borderLeftWidth / 2, layoutY + container.getHeight(), borderLeftWidth, borderLeftColor, container.getStyle().getBorderLeftStyle(), 3)};
            this.drawBorder(borders);
            this.makeBookmark((IArea)container, curPos);
            this.handleHyperlinkAction((IArea)container, curPos);
        }

        protected void drawTextAt(ITextArea text, int textX, int textY, PdfContentByte contentByte, float contentByteHeight) {
            IStyle style = text.getStyle();
            if (!$assertionsDisabled && style == null) {
                throw new AssertionError();
            }
            float fontSize = text.getFontInfo().getFontSize();
            float characterSpacing = this.pdfMeasure(PropertyUtil.getDimensionValue((CSSValue)style.getProperty(25)));
            float wordSpacing = this.pdfMeasure(PropertyUtil.getDimensionValue((CSSValue)style.getProperty(44)));
            contentByte.saveState();
            contentByte.beginText();
            contentByte.setFontAndSize(text.getFontInfo().getBaseFont(), fontSize);
            contentByte.setCharacterSpacing(characterSpacing);
            contentByte.setWordSpacing(wordSpacing);
            this.placeText(contentByte, text.getFontInfo(), this.layoutAreaX2PDF(textX), this.layoutAreaY2PDFEx(textY, text.getFontInfo().getBaseline(), contentByteHeight));
            Color color = PropertyUtil.getColor((CSSValue)style.getProperty(14));
            if (null != color) {
                contentByte.setColorFill(color);
            }
            contentByte.showText(text.getText());
            contentByte.endText();
            contentByte.restoreState();
            if ("line-through".equalsIgnoreCase(style.getTextLineThrough())) {
                this.drawLine(this.layoutPointX2PDF(textX), this.layoutPointY2PDF(textY + text.getFontInfo().getLineThroughPosition()), this.layoutPointX2PDF(textX + text.getWidth()), this.layoutPointY2PDF(textY + text.getFontInfo().getLineThroughPosition()), text.getFontInfo().getLineWidth(), PropertyUtil.getColor((CSSValue)style.getProperty(14)), "solid", contentByte);
            }
            if ("overline".equalsIgnoreCase(style.getTextOverline())) {
                this.drawLine(this.layoutPointX2PDF(textX), this.layoutPointY2PDF(textY + text.getFontInfo().getOverlinePosition()), this.layoutPointX2PDF(textX + text.getWidth()), this.layoutPointY2PDF(textY + text.getFontInfo().getOverlinePosition()), text.getFontInfo().getLineWidth(), PropertyUtil.getColor((CSSValue)style.getProperty(14)), "solid", contentByte);
            }
            if ("underline".equalsIgnoreCase(style.getTextUnderline())) {
                this.drawLine(this.layoutPointX2PDF(textX), this.layoutPointY2PDF(textY + text.getFontInfo().getUnderlinePosition()), this.layoutPointX2PDF(textX + text.getWidth()), this.layoutPointY2PDF(textY + text.getFontInfo().getUnderlinePosition()), text.getFontInfo().getLineWidth(), PropertyUtil.getColor((CSSValue)style.getProperty(14)), "solid", contentByte);
            }
        }

        protected void drawImage(IImageArea image) {
            Image img = null;
            this.cb.saveState();
            ContainerPosition curPos = !this.containerStack.isEmpty() ? (ContainerPosition)this.containerStack.peek() : new ContainerPosition(0, 0);
            int imageX = curPos.x + image.getX();
            int imageY = curPos.y + image.getY();
            try {
                switch (((IImageContent)image.getContent()).getImageSource()) {
                    case 0: 
                    case 3: {
                        if (null == ((IImageContent)image.getContent()).getURI()) {
                            return;
                        }
                        img = Image.getInstance((String)((IImageContent)image.getContent()).getURI());
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (null == ((IImageContent)image.getContent()).getData()) {
                            return;
                        }
                        img = Image.getInstance((byte[])((IImageContent)image.getContent()).getData());
                    }
                }
                this.cb.addImage(img, this.pdfMeasure(image.getWidth()), 0.0f, 0.0f, this.pdfMeasure(image.getHeight()), this.layoutAreaX2PDF(imageX), this.layoutAreaY2PDF(imageY, image.getHeight()));
            }
            catch (BadElementException bee) {
                logger.log(Level.WARNING, bee.getMessage(), bee);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, ioe.getMessage(), ioe);
            }
            catch (DocumentException de) {
                logger.log(Level.WARNING, de.getMessage(), de);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, t.getMessage(), t);
            }
            this.cb.restoreState();
            this.makeBookmark((IArea)image, curPos);
            this.handleHyperlinkAction((IArea)image, curPos);
        }

        private void drawBorder(BorderInfo[] borders) {
            BorderInfo bi;
            ArrayList<BorderInfo> dbl = null;
            ArrayList<BorderInfo> solid = null;
            ArrayList<BorderInfo> dashed = null;
            ArrayList<BorderInfo> dotted = null;
            for (int i = 0; i < borders.length; ++i) {
                if ("double".equalsIgnoreCase(borders[i].borderStyle)) {
                    if (null == dbl) {
                        dbl = new ArrayList<BorderInfo>();
                    }
                    dbl.add(borders[i]);
                    continue;
                }
                if ("dashed".equalsIgnoreCase(borders[i].borderStyle)) {
                    if (null == dashed) {
                        dashed = new ArrayList<BorderInfo>();
                    }
                    dashed.add(borders[i]);
                    continue;
                }
                if ("dotted".equalsIgnoreCase(borders[i].borderStyle)) {
                    if (null == dotted) {
                        dotted = new ArrayList<BorderInfo>();
                    }
                    dotted.add(borders[i]);
                    continue;
                }
                if (null == solid) {
                    solid = new ArrayList<BorderInfo>();
                }
                solid.add(borders[i]);
            }
            if (null != dotted) {
                Iterator it = dotted.iterator();
                while (it.hasNext()) {
                    bi = (BorderInfo)it.next();
                    this.drawLine(this.layoutPointX2PDF(bi.startX), this.layoutPointY2PDF(bi.startY), this.layoutPointX2PDF(bi.endX), this.layoutPointY2PDF(bi.endY), this.pdfMeasure(bi.borderWidth), bi.borderColor, "dotted", this.cb);
                }
            }
            if (null != dashed) {
                Iterator it = dashed.iterator();
                while (it.hasNext()) {
                    bi = (BorderInfo)it.next();
                    this.drawLine(this.layoutPointX2PDF(bi.startX), this.layoutPointY2PDF(bi.startY), this.layoutPointX2PDF(bi.endX), this.layoutPointY2PDF(bi.endY), this.pdfMeasure(bi.borderWidth), bi.borderColor, "dashed", this.cb);
                }
            }
            if (null != solid) {
                Iterator it = solid.iterator();
                while (it.hasNext()) {
                    bi = (BorderInfo)it.next();
                    this.drawLine(this.layoutPointX2PDF(bi.startX), this.layoutPointY2PDF(bi.startY), this.layoutPointX2PDF(bi.endX), this.layoutPointY2PDF(bi.endY), this.pdfMeasure(bi.borderWidth), bi.borderColor, "solid", this.cb);
                }
            }
            if (null != dbl) {
                Iterator it = dbl.iterator();
                while (it.hasNext()) {
                    bi = (BorderInfo)it.next();
                    int outerBorderWidth = bi.borderWidth / 3;
                    int innerBorderWidth = bi.borderWidth / 3;
                    switch (bi.borderType) {
                        case 0: {
                            this.drawLine(this.layoutPointX2PDF(bi.startX), this.layoutPointY2PDF(bi.startY - bi.borderWidth / 2 + outerBorderWidth / 2), this.layoutPointX2PDF(bi.endX), this.layoutPointY2PDF(bi.endY - bi.borderWidth / 2 + outerBorderWidth / 2), this.pdfMeasure(outerBorderWidth), bi.borderColor, "solid", this.cb);
                            this.drawLine(this.layoutPointX2PDF(bi.startX + 2 * borders[3].borderWidth / 3), this.layoutPointY2PDF(bi.startY + bi.borderWidth / 2 - innerBorderWidth / 2), this.layoutPointX2PDF(bi.endX - 2 * borders[1].borderWidth / 3), this.layoutPointY2PDF(bi.endY + bi.borderWidth / 2 - innerBorderWidth / 2), this.pdfMeasure(innerBorderWidth), bi.borderColor, "solid", this.cb);
                            break;
                        }
                        case 1: {
                            this.drawLine(this.layoutPointX2PDF(bi.startX + bi.borderWidth / 2 - outerBorderWidth / 2), this.layoutPointY2PDF(bi.startY), this.layoutPointX2PDF(bi.endX + bi.borderWidth / 2 - outerBorderWidth / 2), this.layoutPointY2PDF(bi.endY), this.pdfMeasure(outerBorderWidth), bi.borderColor, "solid", this.cb);
                            this.drawLine(this.layoutPointX2PDF(bi.startX - bi.borderWidth / 2 + innerBorderWidth / 2), this.layoutPointY2PDF(bi.startY + 2 * borders[0].borderWidth / 3), this.layoutPointX2PDF(bi.endX - bi.borderWidth / 2 + innerBorderWidth / 2), this.layoutPointY2PDF(bi.endY - 2 * borders[2].borderWidth / 3), this.pdfMeasure(innerBorderWidth), bi.borderColor, "solid", this.cb);
                            break;
                        }
                        case 2: {
                            this.drawLine(this.layoutPointX2PDF(bi.startX), this.layoutPointY2PDF(bi.startY + bi.borderWidth / 2 - outerBorderWidth / 2), this.layoutPointX2PDF(bi.endX), this.layoutPointY2PDF(bi.endY + bi.borderWidth / 2 - outerBorderWidth / 2), this.pdfMeasure(outerBorderWidth), bi.borderColor, "solid", this.cb);
                            this.drawLine(this.layoutPointX2PDF(bi.startX + 2 * borders[3].borderWidth / 3), this.layoutPointY2PDF(bi.startY - bi.borderWidth / 2 + innerBorderWidth / 2), this.layoutPointX2PDF(bi.endX - 2 * borders[1].borderWidth / 3), this.layoutPointY2PDF(bi.endY - bi.borderWidth / 2 + innerBorderWidth / 2), this.pdfMeasure(innerBorderWidth), bi.borderColor, "solid", this.cb);
                            break;
                        }
                        case 3: {
                            this.drawLine(this.layoutPointX2PDF(bi.startX - bi.borderWidth / 2 + outerBorderWidth / 2), this.layoutPointY2PDF(bi.startY), this.layoutPointX2PDF(bi.endX - bi.borderWidth / 2 + outerBorderWidth / 2), this.layoutPointY2PDF(bi.endY), this.pdfMeasure(outerBorderWidth), bi.borderColor, "solid", this.cb);
                            this.drawLine(this.layoutPointX2PDF(bi.startX + bi.borderWidth / 2 - innerBorderWidth / 2), this.layoutPointY2PDF(bi.startY + 2 * borders[0].borderWidth / 3), this.layoutPointX2PDF(bi.endX + bi.borderWidth / 2 - innerBorderWidth / 2), this.layoutPointY2PDF(bi.endY - 2 * borders[2].borderWidth / 3), this.pdfMeasure(innerBorderWidth), bi.borderColor, "solid", this.cb);
                        }
                    }
                }
            }
        }

        private void drawLine(float startX, float startY, float endX, float endY, float width, Color color, String lineStyle, PdfContentByte contentByte) {
            if (null == color || 0.0f == width || "none".equalsIgnoreCase(lineStyle)) {
                return;
            }
            contentByte.saveState();
            if ("solid".equalsIgnoreCase(lineStyle)) {
                this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
            }
            if ("dashed".equalsIgnoreCase(lineStyle)) {
                contentByte.setLineDash(3.0f * width, 2.0f * width, 0.0f);
                this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
            } else if ("dotted".equalsIgnoreCase(lineStyle)) {
                contentByte.setLineDash(width, width, 0.0f);
                this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
            } else {
                if ("double".equalsIgnoreCase(lineStyle)) {
                    return;
                }
                this.drawRawLine(startX, startY, endX, endY, width, color, contentByte);
            }
            contentByte.restoreState();
        }

        private void drawRawLine(float startX, float startY, float endX, float endY, float width, Color color, PdfContentByte contentByte) {
            contentByte.moveTo(startX, startY);
            contentByte.setLineWidth(width);
            contentByte.lineTo(endX, endY);
            contentByte.setColorStroke(color);
            contentByte.stroke();
        }

        private void drawBackgroundColor(Color color, float x, float y, float width, float height) {
            if (null == color) {
                return;
            }
            this.cbUnder.saveState();
            this.cbUnder.setColorFill(color);
            this.cbUnder.rectangle(x, y - height, width, height);
            this.cbUnder.fill();
            this.cbUnder.restoreState();
        }

        private tplValueTriple computeTplVerticalValTriple(float absPos, float containerBaseAbsPos, float containerSize, float ImageSize) {
            float tplOrigin = 0.0f;
            float tplSize = 0.0f;
            float translation = 0.0f;
            if (absPos <= 0.0f) {
                if (ImageSize + absPos > 0.0f && ImageSize + absPos <= containerSize) {
                    tplOrigin = containerBaseAbsPos - ImageSize - absPos;
                    tplSize = ImageSize + absPos;
                } else if (ImageSize + absPos > containerSize) {
                    tplOrigin = containerBaseAbsPos - containerSize;
                    tplSize = containerSize;
                }
                translation = 0.0f;
            } else if (!(absPos >= containerSize)) {
                if (ImageSize + absPos <= containerSize) {
                    tplOrigin = containerBaseAbsPos - ImageSize - absPos;
                    tplSize = ImageSize;
                    translation = 0.0f;
                } else {
                    tplOrigin = containerBaseAbsPos - containerSize;
                    tplSize = containerSize - absPos;
                    translation = containerSize - absPos - ImageSize;
                }
            }
            return new tplValueTriple(tplOrigin, tplSize, translation);
        }

        private tplValueTriple computeTplHorizontalValPair(float absPos, float containerBaseAbsPos, float containerSize, float ImageSize) {
            float tplOrigin = 0.0f;
            float tplSize = 0.0f;
            float translation = 0.0f;
            if (absPos <= 0.0f) {
                if (ImageSize + absPos > 0.0f && ImageSize + absPos <= containerSize) {
                    tplOrigin = containerBaseAbsPos;
                    tplSize = ImageSize + absPos;
                } else if (ImageSize + absPos > containerSize) {
                    tplOrigin = containerBaseAbsPos;
                    tplSize = containerSize;
                }
                translation = absPos;
            } else if (!(absPos >= containerSize)) {
                if (ImageSize + absPos <= containerSize) {
                    tplOrigin = containerBaseAbsPos + absPos;
                    tplSize = ImageSize;
                } else {
                    tplOrigin = containerBaseAbsPos + absPos;
                    tplSize = containerSize - absPos;
                }
                translation = 0.0f;
            }
            return new tplValueTriple(tplOrigin, tplSize, translation);
        }

        private void drawBackgroundImage(String imageURI, float x, float y, float width, float height, float positionX, float positionY, String repeat, boolean xMode, boolean yMode) {
            URL url;
            if (null == imageURI) {
                return;
            }
            String id = imageURI;
            if (this.reportDesign != null && (url = this.reportDesign.findResource(imageURI, 1)) != null) {
                id = url.toExternalForm();
            }
            if (id == null || "".equals(id)) {
                return;
            }
            if (null == repeat) {
                repeat = "repeat";
            }
            this.cbUnder.saveState();
            Image img = null;
            try {
                img = Image.getInstance((String)id);
                float absPosX = xMode ? (width - img.scaledWidth()) * positionX : positionX;
                float absPosY = yMode ? (height - img.scaledHeight()) * positionY : positionY;
                if ("no-repeat".equalsIgnoreCase(repeat)) {
                    tplValueTriple triple = this.computeTplHorizontalValPair(absPosX, x, width, img.scaledWidth());
                    float tplOriginX = triple.getTplOrigin();
                    float tplWidth = triple.getTplSize();
                    float translationX = triple.getTranslation();
                    triple = this.computeTplVerticalValTriple(absPosY, y, height, img.scaledHeight());
                    float tplOrininY = triple.getTplOrigin();
                    float tplHeight = triple.getTplSize();
                    float translationY = triple.getTranslation();
                    PdfTemplate templateWhole = this.cbUnder.createTemplate(tplWidth, tplHeight);
                    templateWhole.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), translationX, translationY);
                    this.cbUnder.addTemplate(templateWhole, tplOriginX, tplOrininY);
                } else if ("repeat-x".equalsIgnoreCase(repeat)) {
                    float remainX = width;
                    PdfTemplate template = null;
                    if (width > img.scaledWidth()) {
                        if (height - absPosY > img.scaledHeight()) {
                            template = this.cbUnder.createTemplate(img.scaledWidth(), img.scaledHeight());
                            template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                        } else {
                            template = this.cbUnder.createTemplate(img.scaledWidth(), height);
                            template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + height);
                        }
                    }
                    while (remainX > 0.0f) {
                        if (remainX < img.scaledWidth()) {
                            PdfTemplate templateX;
                            if (height - absPosY > img.scaledHeight()) {
                                templateX = this.cbUnder.createTemplate(remainX, img.scaledHeight());
                                templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                                this.cbUnder.addTemplate(templateX, x + width - remainX, y - absPosY - img.scaledHeight());
                            } else {
                                templateX = this.cbUnder.createTemplate(remainX, height);
                                templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + height - absPosY);
                                this.cbUnder.addTemplate(templateX, x + width - remainX, y - absPosY - height);
                            }
                            remainX = 0.0f;
                            continue;
                        }
                        if (height - absPosY > img.scaledHeight()) {
                            this.cbUnder.addTemplate(template, x + width - remainX, y - absPosY - img.scaledHeight());
                        } else {
                            this.cbUnder.addTemplate(template, x + width - remainX, y - absPosY - height);
                        }
                        remainX -= img.scaledWidth();
                    }
                } else if ("repeat-y".equalsIgnoreCase(repeat)) {
                    float remainY = height;
                    PdfTemplate template = null;
                    if (height > img.scaledHeight()) {
                        template = this.cbUnder.createTemplate(width - absPosX > img.scaledWidth() ? img.scaledWidth() : width - absPosX, img.scaledHeight());
                        template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                    }
                    while (remainY > 0.0f) {
                        if (remainY < img.scaledHeight()) {
                            PdfTemplate templateY = this.cbUnder.createTemplate(width - absPosX > img.scaledWidth() ? img.scaledWidth() : width - absPosX, remainY);
                            templateY.addImage(img, width > img.scaledWidth() ? img.scaledWidth() : width - absPosX, 0.0f, 0.0f, img.scaledHeight(), 0.0f, -(img.scaledHeight() - remainY));
                            this.cbUnder.addTemplate(templateY, x + absPosX, y - height);
                            remainY = 0.0f;
                            continue;
                        }
                        this.cbUnder.addTemplate(template, x + absPosX, y - height + remainY - img.scaledHeight());
                        remainY -= img.scaledHeight();
                    }
                } else if ("repeat".equalsIgnoreCase(repeat)) {
                    float remainX = width;
                    float remainY = height;
                    PdfTemplate template = null;
                    if (width > img.scaledWidth() && height > img.scaledHeight()) {
                        template = this.cbUnder.createTemplate(img.scaledWidth(), img.scaledHeight());
                        template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                    }
                    while (remainY > 0.0f) {
                        remainX = width;
                        if (remainY < img.scaledHeight()) {
                            while (remainX > 0.0f) {
                                if (remainX < img.scaledWidth()) {
                                    PdfTemplate templateXY = this.cbUnder.createTemplate(remainX, remainY);
                                    templateXY.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + remainY);
                                    this.cbUnder.addTemplate(templateXY, x + width - remainX, y - height);
                                    remainX = 0.0f;
                                    continue;
                                }
                                PdfTemplate templateY = this.cbUnder.createTemplate(img.scaledWidth(), remainY);
                                templateY.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + remainY);
                                this.cbUnder.addTemplate(templateY, x + width - remainX, y - height);
                                remainX -= img.scaledWidth();
                            }
                            remainY = 0.0f;
                            continue;
                        }
                        while (remainX > 0.0f) {
                            if (remainX < img.scaledWidth()) {
                                PdfTemplate templateX = this.cbUnder.createTemplate(remainX, img.scaledHeight());
                                templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                                this.cbUnder.addTemplate(templateX, x + width - remainX, y - height + remainY - img.scaledHeight());
                                remainX = 0.0f;
                                continue;
                            }
                            this.cbUnder.addTemplate(template, x + width - remainX, y - height + remainY - img.scaledHeight());
                            remainX -= img.scaledWidth();
                        }
                        remainY -= img.scaledHeight();
                    }
                }
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, ioe.getMessage(), ioe);
            }
            catch (BadElementException bee) {
                logger.log(Level.WARNING, bee.getMessage(), bee);
            }
            catch (DocumentException de) {
                logger.log(Level.WARNING, de.getMessage(), de);
            }
            catch (RuntimeException re) {
                logger.log(Level.WARNING, re.getMessage(), re);
            }
            this.cbUnder.restoreState();
        }

        private void placeText(PdfContentByte cb, FontInfo fi, float x, float y) {
            if (!fi.getSimulation()) {
                cb.setTextMatrix(x, y);
                return;
            }
            switch (fi.getFontStyle()) {
                case 2: {
                    this.simulateItalic(cb, x, y);
                    break;
                }
                case 1: {
                    this.simulateBold(cb, x, y);
                    break;
                }
                case 3: {
                    this.simulateBold(cb, x, y);
                    this.simulateItalic(cb, x, y);
                }
            }
        }

        private void simulateBold(PdfContentByte cb, float x, float y) {
            cb.setTextRenderingMode(2);
            cb.setLineWidth(0.9f);
            cb.setTextMatrix(x, y);
        }

        private void simulateItalic(PdfContentByte cb, float x, float y) {
            float alpha = (float)Math.tan(0.0);
            float beta = (float)Math.tan(0.2617993877991494);
            cb.setTextMatrix(1.0f, alpha, beta, 1.0f, x, y);
        }

        private float pdfMeasure(int layoutMeasure) {
            return (float)layoutMeasure / 1000.0f;
        }

        private float layoutPointX2PDF(int layoutX) {
            return this.pdfMeasure(layoutX);
        }

        private float layoutPointY2PDF(int layoutY) {
            return this.pageHeight - this.pdfMeasure(layoutY);
        }

        private float layoutAreaX2PDF(int layoutX) {
            return this.pdfMeasure(layoutX);
        }

        private float layoutAreaY2PDF(int layoutY, int areaHeight) {
            return this.pageHeight - this.pdfMeasure(layoutY) - this.pdfMeasure(areaHeight);
        }

        private float layoutAreaY2PDFEx(int layoutY, int areaHeight, float containerHeight) {
            return containerHeight - this.pdfMeasure(layoutY) - this.pdfMeasure(areaHeight);
        }

        private void makeBookmark(IArea area, ContainerPosition curPos) {
            IContent content = area.getContent();
            if (null != content) {
                String tocmark;
                int areaY = curPos.y + area.getY();
                String bookmark = content.getBookmark();
                if (null != bookmark) {
                    this.cb.localDestination(bookmark, new PdfDestination(0, -1.0f, this.layoutPointY2PDF(areaY), 0.0f));
                }
                if (null != (tocmark = content.getTOC())) {
                    this.cb.localDestination(tocmark, new PdfDestination(0, -1.0f, this.layoutPointY2PDF(areaY), 0.0f));
                }
            }
        }

        private void handleHyperlinkAction(IArea area, ContainerPosition curPos) {
            IContent content = area.getContent();
            if (null != content) {
                int areaX = curPos.x + area.getX();
                int areaY = curPos.y + area.getY();
                IHyperlinkAction hlAction = content.getHyperlinkAction();
                if (null != hlAction) {
                    try {
                        switch (hlAction.getType()) {
                            case 2: {
                                this.writer.addAnnotation(new PdfAnnotation(this.writer, this.layoutPointX2PDF(areaX), this.layoutPointY2PDF(areaY + area.getHeight()), this.layoutPointX2PDF(areaX + area.getWidth()), this.layoutPointY2PDF(areaY), this.createPdfAction(hlAction.getHyperlink(), hlAction.getBookmark(), hlAction.getTargetWindow(), 2)));
                                break;
                            }
                            case 1: {
                                this.writer.addAnnotation(new PdfAnnotation(this.writer, this.layoutPointX2PDF(areaX), this.layoutPointY2PDF(areaY + area.getHeight()), this.layoutPointX2PDF(areaX + area.getWidth()), this.layoutPointY2PDF(areaY), this.createPdfAction(hlAction.getHyperlink(), null, hlAction.getTargetWindow(), 1)));
                                break;
                            }
                            case 3: {
                                Action act = new Action(hlAction);
                                IHTMLActionHandler actionHandler = null;
                                Object ac = this.services.getOption("actionHandler");
                                if (ac != null && ac instanceof IHTMLActionHandler) {
                                    actionHandler = (IHTMLActionHandler)ac;
                                }
                                String link = actionHandler.getURL((IAction)act, (Object)this.context);
                                this.writer.addAnnotation(new PdfAnnotation(this.writer, this.layoutPointX2PDF(areaX), this.layoutPointY2PDF(areaY + area.getHeight()), this.layoutPointX2PDF(areaX + area.getWidth()), this.layoutPointY2PDF(areaY), this.createPdfAction(link.toString(), null, hlAction.getTargetWindow(), 3)));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }

        private PdfAction createPdfAction(String hyperlink, String bookmark, String target, int type) {
            if ("_blank".equalsIgnoreCase(target)) {
                return new PdfAction(hyperlink);
            }
            if (type == 2) {
                return PdfAction.gotoLocalPage((String)bookmark, (boolean)false);
            }
            if (type == 1) {
                return PdfAction.gotoRemotePage((String)hyperlink, (String)bookmark, (boolean)false, (boolean)false);
            }
            return new PdfAction(hyperlink);
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$emitter$pdf$PDFEmitter == null ? (class$org$eclipse$birt$report$engine$emitter$pdf$PDFEmitter = PDFEmitter.class$("org.eclipse.birt.report.engine.emitter.pdf.PDFEmitter")) : class$org$eclipse$birt$report$engine$emitter$pdf$PDFEmitter).desiredAssertionStatus();
        }

        private final class tplValueTriple {
            private final float tplOrigin;
            private final float tplSize;
            private final float translation;

            public tplValueTriple(float val1, float val2, float val3) {
                this.tplOrigin = val1;
                this.tplSize = val2;
                this.translation = val3;
            }

            float getTplOrigin() {
                return this.tplOrigin;
            }

            float getTplSize() {
                return this.tplSize;
            }

            float getTranslation() {
                return this.translation;
            }
        }

        private class BorderInfo {
            public static final int TOP_BORDER = 0;
            public static final int RIGHT_BORDER = 1;
            public static final int BOTTOM_BORDER = 2;
            public static final int LEFT_BORDER = 3;
            public int startX;
            public int startY;
            public int endX;
            public int endY;
            public int borderWidth;
            public Color borderColor;
            public String borderStyle;
            public int borderType;

            public BorderInfo(int startX, int startY, int endX, int endY, int borderWidth, Color borderColor, String borderStyle, int borderType) {
                this.startX = startX;
                this.startY = startY;
                this.endX = endX;
                this.endY = endY;
                this.borderWidth = borderWidth;
                this.borderColor = borderColor;
                this.borderStyle = borderStyle;
                this.borderType = borderType;
            }
        }

        private class ContainerPosition {
            private int x;
            private int y;

            public ContainerPosition(int x, int y) {
                this.x = x;
                this.y = y;
            }
        }
    }
}

