/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.OperatorUtil;

public class FilterConditionHandle
extends StructureHandle {
    public FilterConditionHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle, index);
    }

    public String getExpr() {
        return this.getStringProperty("expr");
    }

    public void setExpr(String filterExpr) {
        this.setPropertySilently("expr", filterExpr);
    }

    public String getOperator() {
        return this.getStringProperty("operator");
    }

    public void setOperator(String operator) throws SemanticException {
        ActivityStack stack = this.getModule().getActivityStack();
        stack.startTrans();
        try {
            this.setProperty("operator", operator);
            int level = OperatorUtil.computeFilterOperatorLevel(operator);
            switch (level) {
                case 1: {
                    this.setValue2(null);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    this.setValue2(null);
                    this.setValue1(null);
                    break;
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public String getValue1() {
        return this.getStringProperty("value1");
    }

    public void setValue1(String value1Expr) {
        this.setPropertySilently("value1", value1Expr);
    }

    public String getValue2() {
        return this.getStringProperty("value2");
    }

    public void setValue2(String value2Expr) {
        this.setPropertySilently("value2", value2Expr);
    }

    public String getColumn() {
        return null;
    }

    public void setColumn(String column) {
    }

    public String getFilterExpr() {
        return this.getExpr();
    }

    public void setFilterExpr(String filterExpr) {
        this.setExpr(filterExpr);
    }

    public String getValue1Expr() {
        return this.getValue1();
    }

    public void setValue1Expr(String value1Expr) {
        this.setValue1(value1Expr);
    }

    public String getValue2Expr() {
        return this.getValue2();
    }

    public void setValue2Expr(String value2Expr) {
        this.setValue2(value2Expr);
    }

    public String getFilterTarget() {
        return (String)this.getProperty("filterTarget");
    }

    public void setFilterTarget(String filterTarget) throws SemanticException {
        this.setProperty("filterTarget", filterTarget);
    }
}

