/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnBandInsertPasteAction;
import org.eclipse.birt.report.model.api.ColumnBandPasteAction;
import org.eclipse.birt.report.model.api.ColumnBandShiftAction;
import org.eclipse.birt.report.model.api.GridColumnBandAdapter;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.CellHelper;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.interfaces.IGridItemModel;

public class GridHandle
extends ReportItemHandle
implements IGridItemModel {
    public GridHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public SlotHandle getColumns() {
        return this.getSlot(0);
    }

    public SlotHandle getRows() {
        return this.getSlot(1);
    }

    public int getColumnCount() {
        return ((GridItem)this.getElement()).getColumnCount(this.module);
    }

    public CellHandle getCell(int row, int column) {
        Cell cell = CellHelper.findCell(this.getModule(), (GridItem)this.getElement(), row, column);
        if (cell == null) {
            return null;
        }
        return cell.handle(this.getModule());
    }

    public SlotHandle getCellContent(int row, int column) {
        CellHandle cell = this.getCell(row, column);
        if (cell == null) {
            return null;
        }
        return cell.getContent();
    }

    public boolean canCopyColumn(int columnIndex) {
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new GridColumnBandAdapter(this));
        try {
            pasteAction.copyColumnBand(columnIndex);
        }
        catch (SemanticException e) {
            return false;
        }
        return true;
    }

    public ColumnBandData copyColumn(int columnIndex) throws SemanticException {
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new GridColumnBandAdapter(this));
        return pasteAction.copyColumnBand(columnIndex);
    }

    public void pasteColumn(ColumnBandData data, int columnNumber, boolean inForce) throws SemanticException {
        if (data == null) {
            throw new IllegalArgumentException("empty column to paste.");
        }
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new GridColumnBandAdapter(this));
        pasteAction.pasteColumnBand(columnNumber, inForce, data);
    }

    public boolean canPasteColumn(ColumnBandData data, int columnIndex, boolean inForce) {
        if (data == null) {
            throw new IllegalArgumentException("empty column to check.");
        }
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new GridColumnBandAdapter(this));
        return pasteAction.canPaste(columnIndex, inForce, data);
    }

    public void insertAndPasteColumn(ColumnBandData data, int columnNumber) throws SemanticException {
        if (data == null) {
            throw new IllegalArgumentException("empty column to paste.");
        }
        ColumnBandInsertPasteAction insertAction = new ColumnBandInsertPasteAction(new GridColumnBandAdapter(this));
        insertAction.insertAndPasteColumnBand(columnNumber, data);
    }

    public boolean canInsertAndPasteColumn(ColumnBandData data, int columnIndex) {
        if (data == null) {
            throw new IllegalArgumentException("empty column to check.");
        }
        ColumnBandInsertPasteAction insertAction = new ColumnBandInsertPasteAction(new GridColumnBandAdapter(this));
        return insertAction.canInsertAndPaste(columnIndex, data);
    }

    public void shiftColumn(int sourceColumn, int destColumn) throws SemanticException {
        ColumnBandShiftAction shiftAction = new ColumnBandShiftAction(new GridColumnBandAdapter(this));
        shiftAction.shiftColumnBand(sourceColumn, destColumn);
    }

    public boolean canShiftColumn(int sourceColumn, int destColumn) {
        ColumnBandShiftAction shiftAction = new ColumnBandShiftAction(new GridColumnBandAdapter(this));
        try {
            shiftAction.getShiftData(sourceColumn);
        }
        catch (SemanticException e) {
            return false;
        }
        return shiftAction.checkTargetColumn(sourceColumn, destColumn);
    }
}

