/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IImageItemModel;
import org.eclipse.birt.report.model.metadata.StructRefValue;

public class ImageHandle
extends ReportItemHandle
implements IImageItemModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImageHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public double getScale() {
        return this.getFloatProperty("scale");
    }

    public String getSize() {
        return this.getStringProperty("size");
    }

    public String getAltText() {
        return this.getStringProperty("altText");
    }

    public String getAltTextKey() {
        return this.getStringProperty("altTextID");
    }

    public String getSource() {
        return this.getStringProperty("source");
    }

    public void setSource(String source) throws SemanticException {
        this.setProperty("source", source);
    }

    public String getURI() {
        if ("url".equalsIgnoreCase(this.getSource()) || "file".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("uri");
        }
        return null;
    }

    public String getTypeExpression() {
        if ("expr".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("typeExpr");
        }
        return null;
    }

    public String getValueExpression() {
        if ("expr".equalsIgnoreCase(this.getSource())) {
            return this.getStringProperty("valueExpr");
        }
        return null;
    }

    public String getImageName() {
        if (!"embed".equalsIgnoreCase(this.getStringProperty("source"))) {
            return null;
        }
        return this.getStringProperty("imageName");
    }

    public EmbeddedImageHandle getEmbeddedImage() {
        if (!"embed".equals(this.getStringProperty("source"))) {
            return null;
        }
        StructRefValue imageRef = (StructRefValue)this.getElement().getProperty(this.getModule(), "imageName");
        if (imageRef == null) {
            return null;
        }
        if (imageRef.isResolved()) {
            EmbeddedImage image = (EmbeddedImage)imageRef.getTargetStructure();
            DesignElement owner = this.getElement();
            while (owner != null) {
                if (owner.getLocalProperty(this.module, "imageName") == imageRef) {
                    Module targetModule = null;
                    targetModule = owner != this.getElement() ? owner.getRoot() : (imageRef.getLibraryNamespace() != null ? this.getModule().getLibraryWithNamespace(imageRef.getLibraryNamespace()) : this.getModule());
                    if (!$assertionsDisabled && targetModule == null) {
                        throw new AssertionError();
                    }
                    List images = targetModule.getListProperty(targetModule, "images");
                    if (images == null || images.isEmpty()) continue;
                    int posn = images.indexOf(image);
                    PropertyHandle propHandle = targetModule.getHandle(targetModule).getPropertyHandle("images");
                    if (!$assertionsDisabled && posn == -1) {
                        throw new AssertionError();
                    }
                    EmbeddedImageHandle imageHandle = new EmbeddedImageHandle(propHandle, posn);
                    return imageHandle;
                }
                owner = owner.isVirtualElement() ? owner.getVirtualParent() : owner.getExtendsElement();
            }
        }
        return null;
    }

    public void setImageName(String name) throws SemanticException {
        try {
            this.module.getActivityStack().startTrans();
            this.setProperty("source", "embed");
            this.setProperty("imageName", name);
        }
        catch (SemanticException e) {
            this.module.getActivityStack().rollback();
            throw e;
        }
        this.module.getActivityStack().commit();
    }

    public void setURI(String uri) throws SemanticException {
        String source = "url";
        this.setURIProperty(uri, source);
    }

    public void setFile(String file) throws SemanticException {
        String source = "file";
        this.setURIProperty(file, source);
    }

    private void setURIProperty(String prop, String source) throws SemanticException {
        try {
            this.module.getActivityStack().startTrans();
            this.setProperty("source", source);
            this.setProperty("uri", prop);
        }
        catch (SemanticException e) {
            this.module.getActivityStack().rollback();
            throw e;
        }
        this.module.getActivityStack().commit();
    }

    public void setScale(double scale) throws SemanticException {
        this.setFloatProperty("scale", scale);
    }

    public void setSize(String size) throws SemanticException {
        this.setStringProperty("size", size);
    }

    public void setTypeExpression(String value) throws SemanticException {
        try {
            this.module.getActivityStack().startTrans();
            this.setProperty("source", "expr");
            this.setProperty("typeExpr", value);
        }
        catch (SemanticException e) {
            this.module.getActivityStack().rollback();
            throw e;
        }
        this.module.getActivityStack().commit();
    }

    public void setValueExpression(String value) throws SemanticException {
        try {
            this.module.getActivityStack().startTrans();
            this.setProperty("source", "expr");
            this.setProperty("valueExpr", value);
        }
        catch (SemanticException e) {
            this.module.getActivityStack().rollback();
            throw e;
        }
        this.module.getActivityStack().commit();
    }

    public ActionHandle getActionHandle() {
        PropertyHandle propHandle = this.getPropertyHandle("action");
        Action action = (Action)propHandle.getValue();
        if (action == null) {
            return null;
        }
        return (ActionHandle)action.getHandle(propHandle);
    }

    public ActionHandle setAction(Action action) throws SemanticException {
        this.setProperty("action", action);
        if (action == null) {
            return null;
        }
        return (ActionHandle)action.getHandle(this.getPropertyHandle("action"));
    }

    public String getHelpText() {
        return this.getStringProperty("helpText");
    }

    public void setHelpText(String helpText) throws SemanticException {
        this.setStringProperty("helpText", helpText);
    }

    public String getHelpTextKey() {
        return this.getStringProperty("helpTextID");
    }

    public void setHelpTextKey(String helpTextKey) throws SemanticException {
        this.setStringProperty("helpTextID", helpTextKey);
    }

    static {
        $assertionsDisabled = !ImageHandle.class.desiredAssertionStatus();
    }
}

