/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.ILibraryModel;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class LibraryHandle
extends ModuleHandle
implements ILibraryModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public LibraryHandle(Library library) {
        super(library);
    }

    public ModuleHandle getHostHandle() {
        return (ModuleHandle)((Library)this.getElement()).getHost().getHandle(this.getModule());
    }

    public DesignElement getElement() {
        return this.module;
    }

    public String getNamespace() {
        return ((Library)this.module).getNamespace();
    }

    public SlotHandle getThemes() {
        return this.getSlot(0);
    }

    public SlotHandle getStyles() {
        ThemeHandle theme = this.getTheme();
        if (theme == null) {
            return null;
        }
        return theme.getStyles();
    }

    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles) {
        String themeName = ((Module)this.getElement()).getThemeName();
        if (themeName == null) {
            themeName = ModelMessages.getMessage("Theme.defaultThemeName");
        }
        this.importCssStyles(stylesheet, selectedStyles, themeName);
    }

    private ThemeHandle setupTheme(String themeName) {
        Theme theme;
        block9: {
            Library libElement = (Library)this.getElement().getRoot();
            theme = libElement.findNativeTheme(themeName);
            if (theme == null) {
                ThemeHandle newTheme;
                block8: {
                    newTheme = this.getModuleHandle().getElementFactory().newTheme(themeName);
                    try {
                        this.getThemes().add(newTheme);
                    }
                    catch (ContentException e) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    catch (NameException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                theme = (Theme)newTheme.getElement();
            }
            try {
                if (libElement.getThemeName() == null) {
                    this.setThemeName(themeName);
                }
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        return (ThemeHandle)theme.getHandle(this.module);
    }

    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles, String themeName) {
        if (StringUtil.isBlank(themeName)) {
            return;
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans();
        ThemeHandle themeHandle = this.setupTheme(themeName);
        for (int i = 0; i < selectedStyles.size(); ++i) {
            SharedStyleHandle style = (SharedStyleHandle)selectedStyles.get(i);
            if (stylesheet.findStyle(style.getName()) == null) continue;
            try {
                style.getElement().setName(themeHandle.makeUniqueStyleName(style.getName()));
                themeHandle.getStyles().add(style);
                continue;
            }
            catch (ContentException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
            catch (NameException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
        }
        stack.commit();
    }

    static {
        $assertionsDisabled = !LibraryHandle.class.desiredAssertionStatus();
    }
}

