/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.parser.ActionStructureState;
import org.eclipse.birt.report.model.parser.DesignReader;
import org.eclipse.birt.report.model.parser.GenericModuleReader;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.parser.ModuleParserErrorHandler;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.eclipse.birt.report.model.writer.IndentableXMLWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleUtil {
    public static final int LIBRARY = 0;
    public static final int REPORT_DESIGN = 1;
    public static final int INVALID_MODULE = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ActionHandle deserializeAction(InputStream streamData) throws DesignFileException {
        ImageItem image = new ImageItem();
        ActionParserHandler handler = new ActionParserHandler(image);
        if (streamData == null) {
            Action action = StructureFactory.createAction();
            image.setProperty("action", (Object)action);
            return ((ImageHandle)image.getHandle(handler.getModule())).getActionHandle();
        }
        if (!streamData.markSupported()) {
            streamData = new BufferedInputStream(streamData);
        }
        if (!$assertionsDisabled && !streamData.markSupported()) {
            throw new AssertionError();
        }
        ModuleUtil.parse(handler, streamData);
        ImageHandle imageHandle = (ImageHandle)image.getHandle(handler.getModule());
        return imageHandle.getActionHandle();
    }

    private static void parse(XMLParserHandler handler, InputStream streamData) throws DesignFileException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(streamData);
            inputSource.setEncoding("UTF-8");
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            List errors = handler.getErrorHandler().getErrors();
            if (e.getException() instanceof DesignFileException) {
                throw (DesignFileException)((Object)e.getException());
            }
            throw new DesignFileException(null, errors, e);
        }
        catch (ParserConfigurationException e) {
            throw new DesignFileException(null, handler.getErrorHandler().getErrors(), e);
        }
        catch (IOException e) {
            throw new DesignFileException(null, handler.getErrorHandler().getErrors(), e);
        }
    }

    public static ActionHandle deserializeAction(String strData) throws DesignFileException {
        ByteArrayInputStream is;
        block3: {
            is = null;
            String streamToOpen = StringUtil.trimString(strData);
            if (streamToOpen != null) {
                try {
                    is = new ByteArrayInputStream(streamToOpen.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return ModuleUtil.deserializeAction(is);
    }

    public static String serializeAction(ActionHandle action) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ActionWriter writer = new ActionWriter();
        writer.write(os, (Action)action.getStructure());
        try {
            return os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return os.toString();
        }
    }

    public static boolean isValidDesign(SessionHandle sessionHandle, String fileName, InputStream is) {
        ReportDesign design = null;
        try {
            design = DesignReader.getInstance().read(sessionHandle.getSession(), fileName, is);
            return design != null;
        }
        catch (DesignFileException e) {
            return false;
        }
    }

    public static boolean isValidLibrary(SessionHandle sessionHandle, String fileName, InputStream is) {
        Library lib = null;
        try {
            lib = LibraryReader.getInstance().read(sessionHandle.getSession(), fileName, is);
            return lib != null;
        }
        catch (DesignFileException e) {
            return false;
        }
    }

    public static int checkModule(SessionHandle sessionHandle, String fileName, InputStream is) {
        Module rtnModule = null;
        try {
            rtnModule = GenericModuleReader.getInstance().read(sessionHandle.getSession(), fileName, is);
        }
        catch (DesignFileException e) {
            return 2;
        }
        return rtnModule instanceof Library ? 0 : 1;
    }

    public static void updateBoundDataColumns(ModuleHandle module) throws SemanticException {
    }

    private static List checkVersion(InputStream streamData) throws DesignFileException {
        VersionParserHandler handler = new VersionParserHandler();
        InputStream inputStreamToParse = streamData;
        if (!inputStreamToParse.markSupported()) {
            inputStreamToParse = new BufferedInputStream(streamData);
        }
        ModuleUtil.parse(handler, inputStreamToParse);
        return ModelUtil.checkVersion(handler.version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List checkVersion(String fileName) {
        ArrayList<VersionInfo> rtnList;
        block14: {
            rtnList = new ArrayList<VersionInfo>();
            BufferedInputStream inputStream = null;
            inputStream = new BufferedInputStream(new FileInputStream(fileName));
            rtnList.addAll(ModuleUtil.checkVersion(inputStream));
            Object var5_3 = null;
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                break block14;
            }
            catch (IOException e) {}
            break block14;
            {
                catch (FileNotFoundException e1) {
                    rtnList.add(new VersionInfo(null, 0));
                    Object var5_4 = null;
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        break block14;
                    }
                    catch (IOException e) {}
                    break block14;
                }
                catch (DesignFileException e1) {
                    rtnList.add(new VersionInfo(null, 0));
                    Object var5_5 = null;
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        break block14;
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return rtnList;
    }

    public static String getExternalizedValue(DesignElementHandle element, String key, String value, ULocale locale) {
        Module root;
        if (element == null) {
            return value;
        }
        DesignElement tmpElement = element.getElement();
        while (tmpElement != null && (root = tmpElement.getRoot()) != null) {
            String externalizedText = root.getMessage(key, locale);
            if (externalizedText != null) {
                return externalizedText;
            }
            if (!tmpElement.isVirtualElement()) {
                tmpElement = tmpElement.getExtendsElement();
                continue;
            }
            tmpElement = tmpElement.getVirtualParent();
        }
        return value;
    }

    static {
        $assertionsDisabled = !ModuleUtil.class.desiredAssertionStatus();
    }

    private static class VersionParserHandler
    extends XMLParserHandler {
        String version = null;

        public VersionParserHandler() {
            super(new ModuleParserErrorHandler());
        }

        public AbstractParseState createStartState() {
            return new StartState();
        }

        class VersionState
        extends XMLParserHandler.InnerParseState {
            VersionState() {
                super(VersionParserHandler.this);
            }

            public void parseAttrs(Attributes attrs) throws XMLParserException {
                String version;
                VersionParserHandler.this.version = version = attrs.getValue("version");
            }

            public void end() throws SAXException {
            }
        }

        class StartState
        extends XMLParserHandler.InnerParseState {
            StartState() {
                super(VersionParserHandler.this);
            }

            public AbstractParseState startElement(String tagName) {
                if ("report".equalsIgnoreCase(tagName) || "library".equalsIgnoreCase(tagName)) {
                    return new VersionState();
                }
                return super.startElement(tagName);
            }
        }
    }

    private static class ActionWriter
    extends ModuleWriter {
        private ActionWriter() {
        }

        public void write(OutputStream os, Action action) throws IOException {
            this.writer = new SectionXMLWriter(os, "UTF-8");
            this.writeAction(action, "action");
        }

        protected Module getModule() {
            return null;
        }
    }

    private static class SectionXMLWriter
    extends IndentableXMLWriter {
        public SectionXMLWriter(OutputStream os, String signature) throws IOException {
            this.out = new PrintStream(os, false, "UTF-8");
        }
    }

    private static class ActionParserHandler
    extends ModuleParserHandler {
        DesignElement element = null;

        public ActionParserHandler(DesignElement element) {
            super(null, null);
            this.element = element;
            this.module = new ReportDesign(null);
            this.setVersion("3.2.2");
        }

        public AbstractParseState createStartState() {
            return new StartState();
        }

        class StartState
        extends XMLParserHandler.InnerParseState {
            StartState() {
                super(ActionParserHandler.this);
            }

            public AbstractParseState startElement(String tagName) {
                if ("structure".equalsIgnoreCase(tagName)) {
                    return new ActionStructureState(ActionParserHandler.this, ActionParserHandler.this.element);
                }
                return super.startElement(tagName);
            }
        }
    }
}

