/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.elements.structures.JoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.SearchKey;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.DataBoundColumnUtil;

public class StructureFactory {
    public static CachedMetaData createCachedMetaData() {
        return new CachedMetaData();
    }

    public static ComputedColumn createComputedColumn() {
        return new ComputedColumn();
    }

    public static Action createAction() {
        return new Action();
    }

    public static ConfigVariable createConfigVar() {
        return new ConfigVariable();
    }

    public static CustomColor createCustomColor() {
        return new CustomColor();
    }

    public static DataSetParameter createDataSetParameter() {
        return new DataSetParameter();
    }

    public static EmbeddedImage createEmbeddedImage() {
        return new EmbeddedImage();
    }

    public static FilterCondition createFilterCond() {
        return new FilterCondition();
    }

    public static HideRule createHideRule() {
        return new HideRule();
    }

    public static IncludeScript createIncludeScript() {
        return new IncludeScript();
    }

    public static IncludedLibrary createIncludeLibrary() {
        return new IncludedLibrary();
    }

    public static ParamBinding createParamBinding() {
        return new ParamBinding();
    }

    public static PropertyMask createPropertyMask() {
        return new PropertyMask();
    }

    public static ResultSetColumn createResultSetColumn() {
        return new ResultSetColumn();
    }

    public static SearchKey createSearchKey() {
        return new SearchKey();
    }

    public static SelectionChoice createSelectionChoice() {
        return new SelectionChoice();
    }

    public static SortKey createSortKey() {
        return new SortKey();
    }

    public static ColumnHint createColumnHint() {
        return new ColumnHint();
    }

    public static HighlightRule createHighlightRule() {
        return new HighlightRule();
    }

    public static MapRule createMapRule() {
        return new MapRule();
    }

    public static ExtendedProperty createExtendedProperty() {
        return new ExtendedProperty();
    }

    public static JoinCondition createJoinCondition() {
        return new JoinCondition();
    }

    public static OdaDesignerState createOdaDesignerState() {
        return new OdaDesignerState();
    }

    public static EmbeddedImage createEmbeddedImage(EmbeddedImageHandle baseImage) {
        if (baseImage == null) {
            return null;
        }
        EmbeddedImage image = new EmbeddedImage();
        Module module = baseImage.getModule();
        String namespace = module instanceof Library ? ((Library)module).getNamespace() : null;
        StructRefValue libReference = new StructRefValue(namespace, baseImage.getName());
        image.setProperty("libReference", (Object)libReference);
        return image;
    }

    public static EmbeddedImage newEmbeddedImageFrom(EmbeddedImageHandle baseImage, String name, ModuleHandle targetModule) throws LibraryException {
        if (baseImage == null || targetModule == null) {
            return null;
        }
        EmbeddedImage image = new EmbeddedImage();
        Module baseModule = baseImage.getModule();
        if (baseModule instanceof ReportDesign) {
            return null;
        }
        Library lib = targetModule.getModule().getLibraryByLocation(baseModule.getLocation());
        if (lib == null) {
            throw new LibraryException(baseModule, new String[]{((Library)baseModule).getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        String namespace = lib.getNamespace();
        StructRefValue libReference = new StructRefValue(namespace, baseImage.getName());
        image.setProperty("libReference", (Object)libReference);
        image.setName(name);
        return image;
    }

    public static EmbeddedImage newEmbeddedImageFrom(EmbeddedImageHandle baseImage, ModuleHandle targetModule) throws LibraryException {
        if (baseImage == null) {
            return null;
        }
        EmbeddedImage newImage = StructureFactory.newEmbeddedImageFrom(baseImage, baseImage.getName(), targetModule);
        targetModule.rename(newImage);
        return newImage;
    }

    public static ComputedColumn newComputedColumn(DesignElementHandle element, String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("The new column name must not be empty");
        }
        if (!(element instanceof ReportItemHandle || element instanceof ScalarParameterHandle || element instanceof GroupHandle)) {
            return null;
        }
        String tmpName = DataBoundColumnUtil.makeUniqueName(element, newName, null);
        ComputedColumn column = new ComputedColumn();
        column.setName(tmpName);
        return column;
    }
}

