/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class TableHeaderContextContainmentValidator
extends AbstractElementValidator {
    private static final TableHeaderContextContainmentValidator instance = new TableHeaderContextContainmentValidator();

    public static TableHeaderContextContainmentValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof ListingElement)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, element, -1);
    }

    private List doValidate(Module module, DesignElement toValidate, int slotId) {
        ArrayList<ContentException> list = new ArrayList<ContentException>();
        DesignElement curContainer = toValidate;
        int curSlotID = slotId;
        if (slotId == -1) {
            curContainer = toValidate.getContainer();
            curSlotID = toValidate.getContainerSlot();
        }
        while (curContainer != null) {
            IElementDefn containerDefn = curContainer.getDefn();
            if ("Table".equalsIgnoreCase(containerDefn.getName()) && curSlotID == 0) {
                list.add(new ContentException(curContainer, curSlotID, toValidate, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT"));
            }
            curSlotID = curContainer.getContainerSlot();
            curContainer = curContainer.getContainer();
        }
        return list;
    }

    public List validateForAdding(Module module, DesignElement element, int slotId, DesignElement toAdd) {
        if (!(toAdd instanceof ListingElement) && !ModelUtil.containElement(toAdd, "Listing")) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, element, slotId);
    }

    public List validateForAdding(Module module, DesignElement element, IElementDefn toAdd) {
        ElementDefn listingDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("Listing");
        if (!listingDefn.isKindOf(toAdd)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, element, -1);
    }
}

