/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.parser.LibraryParserHandler;
import org.eclipse.birt.report.model.parser.ModuleReader;

public final class LibraryReader
extends ModuleReader {
    private static LibraryReader instance = new LibraryReader();

    private LibraryReader() {
    }

    public static LibraryReader getInstance() {
        return instance;
    }

    public Library read(DesignSession session, Module host, String fileName, String namespace, InputStream inputStream) throws DesignFileException {
        URL systemId = URIUtil.getDirectory(fileName);
        LibraryParserHandler handler = new LibraryParserHandler(session, host, systemId, fileName);
        ((Library)handler.getModule()).setNamespace(namespace);
        return (Library)this.readModule(handler, inputStream);
    }

    public Library read(DesignSession session, String fileName, InputStream inputStream) throws DesignFileException {
        URL systemId = URIUtil.getDirectory(fileName);
        LibraryParserHandler handler = new LibraryParserHandler(session, null, systemId, fileName);
        return (Library)this.readModule(handler, inputStream);
    }

    public Library read(DesignSession session, URL systemId, InputStream inputStream) throws DesignFileException {
        LibraryParserHandler handler = new LibraryParserHandler(session, null, systemId, null);
        return (Library)this.readModule(handler, inputStream);
    }

    public Library read(DesignSession session, String fileName) throws DesignFileException {
        URL systemId = URIUtil.getDirectory(fileName);
        LibraryParserHandler handler = new LibraryParserHandler(session, null, systemId, fileName);
        return (Library)this.readModule(handler);
    }
}

