/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportElementState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SimpleDataSetState
extends ReportElementState {
    protected SimpleDataSet element;

    public SimpleDataSetState(ModuleParserHandler theHandler) {
        super(theHandler, theHandler.getModule(), 3);
    }

    public SimpleDataSetState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public DesignElement getElement() {
        return this.element;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.initElement(attrs, true);
    }

    public void end() throws SAXException {
        this.doCompatibleDataSetProperty(this.element);
        DesignElement element = this.getElement();
        TemplateParameterDefinition refTemplateParam = element.getTemplateParameterElement(this.handler.getModule());
        if (refTemplateParam != null) {
            DesignElement defaultElement = refTemplateParam.getDefaultElement();
            if (!(defaultElement instanceof SimpleDataSet)) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{element.getIdentifier(), refTemplateParam.getIdentifier()}, "Error.DesignParserException.INCONSISTENT_TEMPLATE_ELEMENT_TYPE")));
            } else {
                this.doCompatibleDataSetProperty(defaultElement);
            }
        }
        super.end();
    }

    private void doCompatibleDataSetProperty(DesignElement dataSet) {
        if (StringUtil.compareVersion(this.handler.getVersion(), "3.2.2") < 0) {
            List dataSetColumns = (List)dataSet.getProperty(null, "resultSet");
            Object dataSetHints = dataSet.getProperty(null, "resultSetHints");
            if (dataSetHints == null && dataSetColumns != null) {
                dataSet.setProperty("resultSetHints", ModelUtil.copyValue(dataSet.getPropertyDefn("resultSetHints"), dataSetColumns));
            }
        }
    }
}

