/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.api.command.NameSpaceEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.util.IFilterCondition;

public class EventFilter {
    private static EventFilter filter;
    private List conditions = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    private EventFilter() {
        this.conditions.add(new ElementDeletedFilterCondition());
        this.conditions.add(new ElementAddedFilterCondition());
        this.conditions.add(new SameEventFilterCondition());
    }

    public static EventFilter getInstance() {
        if (filter != null) {
            return filter;
        }
        filter = new EventFilter();
        return filter;
    }

    public List filter(List events) {
        if (!$assertionsDisabled && events == null) {
            throw new AssertionError();
        }
        ArrayList filteredEvents = new ArrayList(events);
        int size = filteredEvents.size();
        if (size == 0 || size == 1) {
            return events;
        }
        Iterator iter = this.conditions.iterator();
        while (iter.hasNext()) {
            IFilterCondition filter = (IFilterCondition)iter.next();
            for (int i = 0; i < size; ++i) {
                NotificationRecordTask wrapper1 = (NotificationRecordTask)filteredEvents.get(i);
                for (int j = 0; j < size; ++j) {
                    NotificationRecordTask wrapper2;
                    if (j == i || (wrapper2 = (NotificationRecordTask)filteredEvents.get(j)).isFiltered() || !filter.filter(wrapper1.getEvent(), wrapper2.getEvent())) continue;
                    wrapper2.setFiltered(true);
                }
            }
        }
        return new ArrayList(filteredEvents);
    }

    public void addContition(IFilterCondition cond) {
        this.conditions.add(cond);
    }

    static {
        $assertionsDisabled = !EventFilter.class.desiredAssertionStatus();
        filter = null;
    }

    static class SameEventFilterCondition
    implements IFilterCondition {
        SameEventFilterCondition() {
        }

        public boolean filter(NotificationEvent ev1, NotificationEvent ev2) {
            DesignElement target2;
            if (ev1.getClass() != ev2.getClass()) {
                return false;
            }
            DesignElement target1 = ev1.getTarget();
            if (target1 != (target2 = ev2.getTarget())) {
                return false;
            }
            if (ev1 instanceof ContentEvent) {
                ContentEvent event1 = (ContentEvent)ev1;
                ContentEvent event2 = (ContentEvent)ev2;
                return event1.getAction() == event2.getAction() && event1.getContent() == event2.getContent() && event1.getSlot() == event2.getSlot();
            }
            if (ev1 instanceof PropertyEvent) {
                PropertyEvent event1 = (PropertyEvent)ev1;
                PropertyEvent event2 = (PropertyEvent)ev2;
                return event1.getPropertyName() == event2.getPropertyName();
            }
            if (ev1 instanceof NameSpaceEvent) {
                NameSpaceEvent event1 = (NameSpaceEvent)ev1;
                NameSpaceEvent event2 = (NameSpaceEvent)ev2;
                return event1.getAction() == event2.getAction() && event1.getElement() == event2.getElement() && event1.getNameSpaceID() == event2.getNameSpaceID();
            }
            if (ev1 instanceof ElementDeletedEvent) {
                ElementDeletedEvent event1 = (ElementDeletedEvent)ev1;
                ElementDeletedEvent event2 = (ElementDeletedEvent)ev2;
                return event1.getContainer() == event2.getContainer();
            }
            return false;
        }
    }

    static class ElementAddedFilterCondition
    implements IFilterCondition {
        ElementAddedFilterCondition() {
        }

        public boolean filter(NotificationEvent ev1, NotificationEvent ev2) {
            DesignElement target;
            ContentEvent event2;
            DesignElement container;
            if (!(ev1 instanceof ContentEvent) || ((ContentEvent)ev1).getAction() != 1) {
                return false;
            }
            ContentEvent event1 = (ContentEvent)ev1;
            DesignElement added = (DesignElement)event1.getContent();
            return ev2 instanceof ContentEvent ? (container = (event2 = (ContentEvent)ev2).getTarget()) == added : ev2 instanceof PropertyEvent && (target = (event2 = (PropertyEvent)ev2).getTarget()) == added;
        }
    }

    static class ElementDeletedFilterCondition
    implements IFilterCondition {
        ElementDeletedFilterCondition() {
        }

        public boolean filter(NotificationEvent ev1, NotificationEvent ev2) {
            DesignElement target;
            ContentEvent event;
            DesignElement container;
            if (!(ev1 instanceof ElementDeletedEvent)) {
                return false;
            }
            ElementDeletedEvent event1 = (ElementDeletedEvent)ev1;
            DesignElement deleted = event1.getTarget();
            return ev2 instanceof ContentEvent && ((ContentEvent)ev2).getAction() == 2 ? (container = (event = (ContentEvent)ev2).getTarget()) == deleted : (ev2 instanceof ElementDeletedEvent ? (event = (ElementDeletedEvent)ev2).getContainer() == deleted : ev2 instanceof PropertyEvent && (target = (event = (PropertyEvent)ev2).getTarget()) == deleted);
        }
    }
}

