/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

class ViewerHTMLActionHandler
implements IHTMLActionHandler {
    protected Logger log = Logger.getLogger(ViewerHTMLActionHandler.class.getName());
    protected IReportDocument document = null;
    protected Locale locale = null;
    protected long page = -1L;
    protected boolean isEmbeddable = false;
    protected boolean isRtl = false;
    protected boolean isMasterPageContent = true;

    public ViewerHTMLActionHandler() {
    }

    public ViewerHTMLActionHandler(IReportDocument iReportDocument, long l, Locale locale, boolean bl, boolean bl2, boolean bl3) {
        this.document = iReportDocument;
        this.page = l;
        this.locale = locale;
        this.isEmbeddable = bl;
        this.isRtl = bl2;
        this.isMasterPageContent = bl3;
    }

    public ViewerHTMLActionHandler(Locale locale, boolean bl, boolean bl2) {
        this.locale = locale;
        this.isRtl = bl;
        this.isMasterPageContent = bl2;
    }

    public String getURL(IAction iAction, Object object) {
        if (iAction == null) {
            return null;
        }
        switch (iAction.getType()) {
            case 2: {
                return this.buildBookmarkAction(iAction, object);
            }
            case 1: {
                return iAction.getActionString();
            }
            case 3: {
                return this.buildDrillAction(iAction, object);
            }
        }
        return null;
    }

    protected String buildBookmarkAction(IAction iAction, Object object) {
        if (iAction == null || object == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.document != null) {
            long l = this.document.getPageNumber(iAction.getBookmark());
            bl = l == this.page && !this.isEmbeddable;
        }
        String string = iAction.getBookmark();
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string2 = null;
        if (object instanceof HTMLRenderContext) {
            string2 = ((HTMLRenderContext)object).getBaseURL();
        }
        if (object instanceof PDFRenderContext) {
            string2 = ((PDFRenderContext)object).getBaseURL();
        }
        stringBuffer.append(string2);
        stringBuffer.append("?");
        if (this.document != null) {
            stringBuffer.append("__document");
            stringBuffer.append("=");
            String string3 = this.document.getName();
            try {
                string3 = URLEncoder.encode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string3);
        } else if (iAction.getReportName() != null && iAction.getReportName().length() > 0) {
            stringBuffer.append("__report");
            stringBuffer.append("=");
            String string4 = iAction.getReportName();
            try {
                string4 = URLEncoder.encode(string4, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stringBuffer.append(string4);
        } else {
            return "#" + iAction.getActionString();
        }
        if (this.locale != null) {
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
        }
        if (this.isRtl) {
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
        }
        stringBuffer.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
        if (bl) {
            stringBuffer.append("#");
            stringBuffer.append(string);
        } else {
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__bookmark", string));
        }
        return stringBuffer.toString();
    }

    protected String buildDrillAction(IAction iAction, Object object) {
        if (iAction == null || object == null) {
            return null;
        }
        String string = null;
        if (object instanceof HTMLRenderContext) {
            string = ((HTMLRenderContext)object).getBaseURL();
        }
        if (object instanceof PDFRenderContext) {
            string = ((PDFRenderContext)object).getBaseURL();
        }
        if (string == null) {
            string = "run";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = iAction.getReportName();
        if (string2 != null && !string2.equals("")) {
            String string3 = iAction.getFormat();
            if ("pdf".equalsIgnoreCase(string3)) {
                stringBuffer.append(string.replaceFirst("frameset", "run"));
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2.toLowerCase().endsWith(".rptdocument") ? "?__document=" : "?__report=");
            try {
                stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__format", string3));
            }
            if (iAction.getParameterBindings() != null) {
                Iterator iterator = iAction.getParameterBindings().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    try {
                        String string4 = (String)entry.getKey();
                        Object v = entry.getValue();
                        if (v == null) continue;
                        String string5 = ParameterValidationUtil.getDisplayValue(v);
                        stringBuffer.append(ParameterAccessor.getQueryParameterString(URLEncoder.encode(string4, "UTF-8"), URLEncoder.encode(string5, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__overwrite", String.valueOf(true)));
            if (this.locale != null) {
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
            }
            if (this.isRtl) {
                stringBuffer.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
            }
            stringBuffer.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
            if (iAction.getBookmark() != null) {
                try {
                    if (string.lastIndexOf("/run") > 0) {
                        stringBuffer.append("#");
                    } else {
                        stringBuffer.append("&__bookmark=");
                    }
                    stringBuffer.append(URLEncoder.encode(iAction.getBookmark(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return stringBuffer.toString();
    }
}

