/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtCacheParameterActionHandler
extends AbstractBaseActionHandler {
    static final /* synthetic */ boolean $assertionsDisabled;

    public BirtCacheParameterActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse) {
        super(iContext, operation, getUpdatedObjectsResponse);
    }

    protected void __execute() throws RemoteException {
        ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)this.context.getBean();
        if (!$assertionsDisabled && viewerAttributeBean == null) {
            throw new AssertionError();
        }
        try {
            String string = viewerAttributeBean.getReportDesignName();
            String string2 = ParameterAccessor.getConfigFileName(string);
            if (string2 == null) {
                this.handleUpdate();
                return;
            }
            SessionHandle sessionHandle = DesignEngine.newSession((ULocale)ULocale.US);
            File file = new File(string2);
            if (file != null && file.exists() && file.isFile()) {
                file.delete();
            }
            ReportDesignHandle reportDesignHandle = sessionHandle.createDesign();
            Oprand[] oprandArray = this.operation.getOprand();
            if (oprandArray != null) {
                for (int i = 0; i < oprandArray.length; ++i) {
                    ConfigVariable configVariable = new ConfigVariable();
                    String string3 = oprandArray[i].getName();
                    String string4 = oprandArray[i].getValue();
                    ScalarParameterHandle scalarParameterHandle = (ScalarParameterHandle)viewerAttributeBean.findParameter(string3);
                    if (string4 == null || scalarParameterHandle == null) continue;
                    try {
                        if (!"string".equalsIgnoreCase(scalarParameterHandle.getDataType())) {
                            Object object = ParameterValidationUtil.validate((String)scalarParameterHandle.getDataType(), (String)scalarParameterHandle.getPattern(), (String)string4, (Locale)viewerAttributeBean.getLocale());
                            string4 = ParameterValidationUtil.getDisplayValue((String)scalarParameterHandle.getDataType(), (String)scalarParameterHandle.getPattern(), (Object)object, (ULocale)ULocale.US);
                        }
                    }
                    catch (Exception exception) {
                        string4 = oprandArray[i].getValue();
                    }
                    configVariable.setName(string3 + "_" + scalarParameterHandle.getID());
                    configVariable.setValue(string4);
                    reportDesignHandle.addConfigVariable(configVariable);
                }
            }
            reportDesignHandle.saveAs(string2);
            reportDesignHandle.close();
            this.handleUpdate();
        }
        catch (Exception exception) {
            AxisFault axisFault = new AxisFault(exception.getLocalizedMessage());
            axisFault.setFaultCode(new QName("BirtCacheParameterActionHandler.__execute( )"));
            axisFault.setFaultReason(exception.getLocalizedMessage());
            throw axisFault;
        }
    }

    protected void handleUpdate() {
        Data data = new Data();
        data.setConfirmation("Parameter value saved.");
        UpdateData updateData = new UpdateData();
        updateData.setTarget("birtParameterDialog");
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        this.response.setUpdate(new Update[]{update});
    }

    protected IViewerReportService getReportService() {
        return null;
    }

    static {
        $assertionsDisabled = !BirtCacheParameterActionHandler.class.desiredAssertionStatus();
    }
}

