/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtRunAndRenderActionHandler
extends AbstractBaseActionHandler {
    public BirtRunAndRenderActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse) {
        super(iContext, operation, getUpdatedObjectsResponse);
    }

    protected void __execute() throws RemoteException {
        ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)this.context.getBean();
        String string = ParameterAccessor.getFormat(this.context.getRequest());
        Locale locale = viewerAttributeBean.getLocale();
        boolean bl = viewerAttributeBean.isMasterPageContent();
        HashMap hashMap = viewerAttributeBean.getParameters();
        IViewerReportDesignHandle iViewerReportDesignHandle = viewerAttributeBean.getReportDesignHandle(this.context.getRequest());
        boolean bl2 = ParameterAccessor.getSVGFlag(this.context.getRequest());
        String string2 = viewerAttributeBean.getReportDocumentName();
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", this.context.getRequest());
        inputOptions.setOption("locale", locale);
        inputOptions.setOption("rtl", new Boolean(viewerAttributeBean.isRtl()));
        inputOptions.setOption("isMasterPageContent", new Boolean(bl));
        inputOptions.setOption("svgFlag", new Boolean(bl2));
        inputOptions.setOption("format", string);
        inputOptions.setOption("isDesigner", new Boolean(viewerAttributeBean.isDesigner()));
        try {
            ServletOutputStream servletOutputStream = this.context.getResponse().getOutputStream();
            this.getReportService().runAndRenderReport(iViewerReportDesignHandle, string2, inputOptions, hashMap, (OutputStream)servletOutputStream, new ArrayList());
        }
        catch (IOException iOException) {
            this.throwAxisFault(iOException);
        }
        catch (ReportServiceException reportServiceException) {
            this.throwAxisFault(reportServiceException);
        }
    }

    private void throwAxisFault(Exception exception) throws RemoteException {
        AxisFault axisFault = new AxisFault();
        axisFault.setFaultCode(new QName("BirtRunAndRenderActionHandler.execute( )"));
        axisFault.setFaultString(exception.getLocalizedMessage());
        throw axisFault;
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

