/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ParameterAccessor {
    public static final String SERVLET_PATH_PARAMETER = "/parameter";
    public static final String SERVLET_PATH_PREVIEW = "/preview";
    public static final String SERVLET_PATH_FRAMESET = "/frameset";
    public static final String SERVLET_PATH_RUN = "/run";
    public static final String SERVLET_PATH_DOWNLOAD = "/download";
    public static final String PARAM_REPORT = "__report";
    public static final String PARAM_REPORT_DOCUMENT = "__document";
    public static final String PARAM_FORMAT = "__format";
    public static final String PARAM_FORMAT_HTML = "html";
    public static final String PARAM_FORMAT_PDF = "pdf";
    public static final String PARAM_LOCALE = "__locale";
    public static final String PARAM_SVG = "__svg";
    public static final String PARAM_PAGE = "__page";
    public static final String PARAM_ISNULL = "__isnull";
    public static final String PARAM_MASTERPAGE = "__masterpage";
    public static final String PARAM_DESIGNER = "__designer";
    public static final String PARAM_OVERWRITE = "__overwrite";
    public static final String PARAM_IMAGEID = "__imageID";
    public static final String PARAM_BOOKMARK = "__bookmark";
    public static final String PARAM_RTL = "__rtl";
    public static final String PARAM_MAXROWS = "__maxrows";
    public static final String PARAM_INSTANCEID = "__instanceid";
    public static final String HEADER_REQUEST_TYPE = "request-type";
    public static final String HEADER_REQUEST_TYPE_SOAP = "soap";
    public static final String PARAM_IID = "iid";
    public static final String PARAM_RESULTSETNAME = "ResultSetName";
    public static final String PARAM_SELECTEDCOLUMNNUMBER = "SelectedColumnNumber";
    public static final String PARAM_SELECTEDCOLUMN = "SelectedColumn";
    public static final String INIT_PARAM_LOCALE = "BIRT_VIEWER_LOCALE";
    public static final String INIT_PARAM_REPORT_DIR = "BIRT_VIEWER_WORKING_FOLDER";
    public static final String INIT_PARAM_IMAGE_DIR = "BIRT_VIEWER_IMAGE_DIR";
    public static final String INIT_PARAM_LOG_DIR = "BIRT_VIEWER_LOG_DIR";
    public static final String INIT_PARAM_LOG_LEVEL = "BIRT_VIEWER_LOG_LEVEL";
    public static final String INIT_PARAM_SCRIPTLIB_DIR = "BIRT_VIEWER_SCRIPTLIB_DIR";
    public static final String INIT_PARAM_WORKING_FOLDER_ACCESS_ONLY = "WORKING_FOLDER_ACCESS_ONLY";
    public static final String INIT_PARAM_BIRT_RESOURCE_PATH = "BIRT_RESOURCE_PATH";
    public static final String INIT_PARAM_VIEWER_MAXROWS = "BIRT_VIEWER_MAX_ROWS";
    public static final String UTF_8_ENCODE = "UTF-8";
    public static final String ISO_8859_1_ENCODE = "ISO-8859-1";
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String QUERY_CHAR = "?";
    public static final String EQUALS_OPERATOR = "=";
    public static final String SUFFIX_REPORT_DOCUMENT = ".rptdocument";
    protected static final String DOCUMENTS_DIR = "documents";
    public static String workingFolder;
    public static int maxRows;
    protected static Locale webAppLocale;
    protected static boolean isWorkingFolderAccessOnly;
    protected static boolean isInitContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getBookmark(HttpServletRequest httpServletRequest) {
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_PAGE);
        return n < 1 ? ParameterAccessor.getReportParameter(httpServletRequest, PARAM_BOOKMARK, null) : null;
    }

    public static String getEncodedQueryString(HttpServletRequest httpServletRequest, String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        Enumeration enumeration = httpServletRequest.getParameterNames();
        Set set = ParameterAccessor.getParameterValues(httpServletRequest, PARAM_ISNULL);
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (object == null || ((String)object).equalsIgnoreCase(PARAM_ISNULL)) continue;
            string3 = ParameterAccessor.getParameter(httpServletRequest, (String)object, false);
            if (set != null && set.remove(ParameterAccessor.toUTFString((String)object)) && !((String)object).equalsIgnoreCase(string)) {
                object = ParameterAccessor.urlEncode((String)object, ISO_8859_1_ENCODE);
                string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + PARAM_ISNULL + EQUALS_OPERATOR + (String)object;
                bl = false;
                continue;
            }
            if (((String)object).equalsIgnoreCase(string)) {
                string3 = string2;
            }
            object = ParameterAccessor.urlEncode((String)object, ISO_8859_1_ENCODE);
            string3 = ParameterAccessor.urlEncode(string3, UTF_8_ENCODE);
            string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + (String)object + EQUALS_OPERATOR + string3;
            bl = false;
        }
        if (set != null && set.size() > 0) {
            object = set.iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                if (string3 == null || string3.equalsIgnoreCase(string)) continue;
                string3 = ParameterAccessor.urlEncode(string3, UTF_8_ENCODE);
                string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + PARAM_ISNULL + EQUALS_OPERATOR + string3;
                bl = false;
            }
        }
        if (string != null && string.length() > 0 && ParameterAccessor.getParameter(httpServletRequest, string) == null) {
            object = string2;
            object = ParameterAccessor.urlEncode((String)object, UTF_8_ENCODE);
            string4 = string4 + (bl ? "" : PARAMETER_SEPARATOR) + string + EQUALS_OPERATOR + (String)object;
            bl = false;
        }
        return string4;
    }

    public static String getQueryParameterString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PARAMETER_SEPARATOR);
        stringBuffer.append(string);
        stringBuffer.append(EQUALS_OPERATOR);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String getFormat(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_FORMAT);
        if (string != null && string.length() > 0) {
            return string;
        }
        return PARAM_FORMAT_HTML;
    }

    public static int getMaxRows(HttpServletRequest httpServletRequest) {
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_MAXROWS);
        if (n <= 0) {
            n = maxRows;
        }
        return n;
    }

    public static String getIId(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getReportParameter(httpServletRequest, PARAM_IID, null);
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest) {
        Locale locale = null;
        locale = ParameterAccessor.getLocaleFromString(ParameterAccessor.getParameter(httpServletRequest, PARAM_LOCALE));
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        if (locale == null) {
            locale = webAppLocale;
        }
        return locale;
    }

    public static boolean isRtl(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_RTL))) {
            bl = true;
        }
        return bl;
    }

    public static Locale getLocaleFromString(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        int n = string.indexOf(95);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return new Locale(string2, string3);
        }
        return new Locale(string);
    }

    public static String getLocaleString(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getParameter(httpServletRequest, PARAM_LOCALE);
    }

    public static int getPage(HttpServletRequest httpServletRequest) {
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_PAGE);
        return n <= 0 ? 1 : n;
    }

    public static String getInstanceId(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getParameter(httpServletRequest, PARAM_INSTANCEID);
    }

    public static Set getParameterValues(HttpServletRequest httpServletRequest, String string) {
        return ParameterAccessor.getParameterValues(httpServletRequest, string, true);
    }

    public static String getReport(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_REPORT);
        string = ParameterAccessor.preProcess(string);
        string = ParameterAccessor.createAbsolutePath(string);
        return string;
    }

    public static String getReportDocument(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_REPORT_DOCUMENT);
        if ("".equals(string = ParameterAccessor.preProcess(string))) {
            string = ParameterAccessor.generateDocumentFromReport(httpServletRequest);
            string = ParameterAccessor.createDocumentPath(string, httpServletRequest);
        } else {
            string = ParameterAccessor.createAbsolutePath(string);
        }
        return string;
    }

    protected static String createDocumentPath(String string, HttpServletRequest httpServletRequest) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string == null || string.length() == 0) {
            return "";
        }
        String string5 = httpServletRequest.getSession().getId();
        String string6 = "\\";
        if (string.lastIndexOf(string6) == -1) {
            string6 = "/";
        }
        if (string.lastIndexOf(string6) != -1) {
            string4 = string.substring(string.lastIndexOf(string6));
            string2 = string.substring(0, string.lastIndexOf(string6));
            string3 = string2.lastIndexOf(string6) != -1 ? string2.substring(string2.lastIndexOf(string6)) : string2;
        } else {
            string4 = string;
        }
        String string7 = workingFolder + string6 + DOCUMENTS_DIR + string6 + string5 + string3;
        String string8 = string7 + string4;
        return string8;
    }

    protected static void clearDocuments() {
        String string = workingFolder + File.separator + DOCUMENTS_DIR;
        File file = new File(string);
        boolean bl = file.delete();
        if (!bl) {
            ParameterAccessor.deleteDir(file);
        }
    }

    protected static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = ParameterAccessor.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String getReportParameter(HttpServletRequest httpServletRequest, String string, String string2) {
        Set set;
        if (!($assertionsDisabled || httpServletRequest != null && string != null)) {
            throw new AssertionError();
        }
        String string3 = ParameterAccessor.getParameter(httpServletRequest, string);
        if (string3 == null || string3.trim().length() <= 0) {
            string3 = "";
        }
        Map map = httpServletRequest.getParameterMap();
        String string4 = ParameterAccessor.toISOString(string);
        if (map == null || !map.containsKey(string4)) {
            string3 = string2;
        }
        if ((set = ParameterAccessor.getParameterValues(httpServletRequest, PARAM_ISNULL)) != null && set.contains(string)) {
            string3 = null;
        }
        return string3;
    }

    public static String getResultSetName(HttpServletRequest httpServletRequest) {
        return ParameterAccessor.getReportParameter(httpServletRequest, PARAM_RESULTSETNAME, null);
    }

    public static Collection getSelectedColumns(HttpServletRequest httpServletRequest) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = ParameterAccessor.getParameterAsInt(httpServletRequest, PARAM_SELECTEDCOLUMNNUMBER);
        for (int i = 0; i < n; ++i) {
            String string = PARAM_SELECTEDCOLUMN + String.valueOf(i);
            String string2 = ParameterAccessor.getParameter(httpServletRequest, string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean getSVGFlag(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_SVG))) {
            bl = true;
        }
        return bl;
    }

    public static Locale getWebAppLocale() {
        return webAppLocale;
    }

    public static String getWorkingFolder() {
        return workingFolder;
    }

    public static final String htmlEncode(String string) {
        String string2 = "";
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block12: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': {
                    stringBuffer.append("&#09;");
                    continue block12;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    continue block12;
                }
                case '\r': {
                    stringBuffer.append("&#13;");
                    continue block12;
                }
                case ' ': {
                    stringBuffer.append("&#32;");
                    continue block12;
                }
                case '\"': {
                    stringBuffer.append("&#34;");
                    continue block12;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block12;
                }
                case '<': {
                    stringBuffer.append("&#60;");
                    continue block12;
                }
                case '>': {
                    stringBuffer.append("&#62;");
                    continue block12;
                }
                case '`': {
                    stringBuffer.append("&#96;");
                    continue block12;
                }
                case '&': {
                    stringBuffer.append("&#38;");
                    continue block12;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    public static synchronized void initParameters(ServletConfig servletConfig) {
        if (!isInitContext) {
            ParameterAccessor.initParameters(servletConfig.getServletContext());
        }
    }

    public static synchronized void initParameters(ServletContext servletContext) {
        if (isInitContext) {
            return;
        }
        workingFolder = servletContext.getInitParameter(INIT_PARAM_REPORT_DIR);
        if (workingFolder == null || workingFolder.trim().length() <= 0) {
            workingFolder = servletContext.getRealPath("/");
        }
        if (workingFolder != null && workingFolder.trim().endsWith(File.separator)) {
            workingFolder = workingFolder.trim().substring(0, workingFolder.trim().length() - 1);
        }
        if ((webAppLocale = ParameterAccessor.getLocaleFromString(servletContext.getInitParameter(INIT_PARAM_LOCALE))) == null) {
            webAppLocale = Locale.getDefault();
        }
        isWorkingFolderAccessOnly = Boolean.valueOf(servletContext.getInitParameter(INIT_PARAM_WORKING_FOLDER_ACCESS_ONLY));
        String string = servletContext.getInitParameter(INIT_PARAM_VIEWER_MAXROWS);
        try {
            maxRows = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            maxRows = -1;
        }
        ParameterAccessor.clearDocuments();
        isInitContext = true;
    }

    public static boolean isDesigner(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_DESIGNER))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isGetImageOperator(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_IMAGEID);
        return string != null && string.length() > 0;
    }

    public static boolean isGetReportlet(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getParameter(httpServletRequest, PARAM_INSTANCEID);
        return string != null && string.length() > 0;
    }

    public static boolean isMasterPageContent(HttpServletRequest httpServletRequest) {
        boolean bl = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_MASTERPAGE))) {
            bl = false;
        }
        return bl;
    }

    public static boolean isOverwrite(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(httpServletRequest, PARAM_OVERWRITE))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRelativePath(String string) {
        return !new File(string).isAbsolute();
    }

    public static boolean isReportParameterExist(HttpServletRequest httpServletRequest, String string) {
        Set set;
        if (!($assertionsDisabled || httpServletRequest != null && string != null)) {
            throw new AssertionError();
        }
        boolean bl = false;
        Map map = httpServletRequest.getParameterMap();
        String string2 = ParameterAccessor.toISOString(string);
        if (map != null && map.containsKey(string2)) {
            bl = true;
        }
        if ((set = ParameterAccessor.getParameterValues(httpServletRequest, PARAM_ISNULL)) != null && set.contains(string)) {
            bl = true;
        }
        return bl;
    }

    protected static String createAbsolutePath(String string) {
        if (isWorkingFolderAccessOnly || ParameterAccessor.isRelativePath(string)) {
            return workingFolder + File.separator + string;
        }
        return string;
    }

    protected static String generateDocumentFromReport(HttpServletRequest httpServletRequest) {
        String string = ParameterAccessor.getReport(httpServletRequest);
        string = string.indexOf(46) >= 0 ? string.substring(0, string.lastIndexOf(46)) + SUFFIX_REPORT_DOCUMENT : string + SUFFIX_REPORT_DOCUMENT;
        return string;
    }

    public static String getParameter(HttpServletRequest httpServletRequest, String string) {
        return ParameterAccessor.getParameter(httpServletRequest, string, true);
    }

    protected static String getParameter(HttpServletRequest httpServletRequest, String string, boolean bl) {
        String string2 = bl ? ParameterAccessor.toISOString(string) : string;
        String string3 = httpServletRequest.getParameter(string2);
        String string4 = httpServletRequest.getCharacterEncoding();
        return ParameterAccessor.toUTFString(string3, string4);
    }

    protected static int getParameterAsInt(HttpServletRequest httpServletRequest, String string) {
        int n = -1;
        String string2 = ParameterAccessor.getParameter(httpServletRequest, string);
        if (string2 != null && string2.length() > 0) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    protected static Set getParameterValues(HttpServletRequest httpServletRequest, String string, boolean bl) {
        HashSet<String> hashSet = null;
        String string2 = bl ? ParameterAccessor.toISOString(string) : string;
        String[] stringArray = httpServletRequest.getParameterValues(string2);
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(ParameterAccessor.toUTFString(stringArray[i]));
            }
        }
        return hashSet;
    }

    protected static String preProcess(String string) {
        return string == null ? "" : string.trim();
    }

    protected static String toISOString(String string) {
        String string2 = string;
        if (string != null) {
            try {
                string2 = new String(string.getBytes(UTF_8_ENCODE), ISO_8859_1_ENCODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string;
            }
        }
        return string2;
    }

    protected static String toUTFString(String string) {
        String string2 = string;
        if (string != null) {
            try {
                string2 = new String(string.getBytes(ISO_8859_1_ENCODE), UTF_8_ENCODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = string;
            }
        }
        return string2;
    }

    protected static String toUTFString(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        if (string != null) {
            if (string4 == null) {
                string4 = ISO_8859_1_ENCODE;
            }
            try {
                string3 = new String(string.getBytes(string4), UTF_8_ENCODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = string;
            }
        }
        return string3;
    }

    protected static String urlEncode(String string, String string2) {
        if (!($assertionsDisabled || ISO_8859_1_ENCODE.equalsIgnoreCase(string2) || UTF_8_ENCODE.equalsIgnoreCase(string2))) {
            throw new AssertionError();
        }
        String string3 = string;
        if (string != null) {
            try {
                string3 = URLEncoder.encode(string, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = string;
            }
        }
        return string3;
    }

    public static String getConfigFileName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.endsWith("rptdesign")) {
            string2 = string.replaceFirst("rptdesign", "rptconfig");
        } else if (string.endsWith("rpttemplate")) {
            string2 = string.replaceFirst("rpttemplate", "rptconfig");
        }
        return string2;
    }

    public static boolean isWorkingFolderAccessOnly() {
        return isWorkingFolderAccessOnly;
    }

    static {
        $assertionsDisabled = !ParameterAccessor.class.desiredAssertionStatus();
        workingFolder = null;
        webAppLocale = null;
        isWorkingFolderAccessOnly = true;
        isInitContext = false;
    }
}

