/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.data.engine.executor.cache.DataFileReader;
import org.eclipse.birt.data.engine.executor.cache.DataFileWriter;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class SortDataProvider {
    private int dataCountOfUnit;
    private File tempDir;
    private File goalFile;
    private DataFileReader[] dfrArray;
    private DataFileWriter dfw;
    private IResultObject[][] cachedResultObjects;
    private int[] indexOfCachedRowData;
    private String tempDirStr;
    private static final String tempFilePrefix = "data";
    public static final int SORT_ITSELF = 0;
    public static final int SORT_MERGE = 1;
    private ResultObjectUtil resultObjectUtil;

    SortDataProvider(int dataCountOfUnit, String tempDirStr, String goalFileStr, ResultObjectUtil resultObjectUtil) {
        this.dataCountOfUnit = dataCountOfUnit;
        this.resultObjectUtil = resultObjectUtil;
        this.tempDir = new File(tempDirStr);
        if (!this.tempDir.exists()) {
            this.tempDir.mkdir();
        }
        this.tempDirStr = tempDirStr;
        this.goalFile = new File(goalFileStr);
    }

    void initForMerge(int dataCountOfTotal) {
        int countOfUnit = dataCountOfTotal / this.dataCountOfUnit;
        if (dataCountOfTotal % this.dataCountOfUnit != 0) {
            ++countOfUnit;
        }
        this.dfrArray = new DataFileReader[countOfUnit];
        this.cachedResultObjects = new IResultObject[countOfUnit][];
        this.indexOfCachedRowData = new int[countOfUnit];
        for (int i = 0; i < countOfUnit; ++i) {
            this.indexOfCachedRowData[i] = -1;
        }
    }

    IResultObject[] readData(int begin, int end) throws IOException {
        int cacheLength;
        if (begin == end) {
            return new IResultObject[0];
        }
        int readerIndex = begin / this.dataCountOfUnit;
        if (this.indexOfCachedRowData[readerIndex] == -1) {
            File file = this.getTempFile(readerIndex);
            if (this.dfrArray[readerIndex] == null) {
                this.dfrArray[readerIndex] = DataFileReader.newInstance(file, this.resultObjectUtil);
            } else {
                this.dfrArray[readerIndex].setReadFile(file);
            }
        }
        int length = end - begin;
        IResultObject[] sortedData = null;
        int offsetOfBegin = begin - this.indexOfCachedRowData[readerIndex];
        int n = cacheLength = this.cachedResultObjects[readerIndex] != null ? this.cachedResultObjects[readerIndex].length : 0;
        if (this.indexOfCachedRowData[readerIndex] == -1 || offsetOfBegin >= cacheLength) {
            this.cachedResultObjects[readerIndex] = this.dfrArray[readerIndex].read(length);
            sortedData = this.cachedResultObjects[readerIndex];
            this.indexOfCachedRowData[readerIndex] = begin;
        } else {
            int offsetOfEnd = end - this.indexOfCachedRowData[readerIndex];
            if (offsetOfEnd > cacheLength) {
                IResultObject[] tempCachedData = new IResultObject[length];
                int fromBeginCachedLength = this.indexOfCachedRowData[readerIndex] + cacheLength - begin;
                for (int i = 0; i < fromBeginCachedLength; ++i) {
                    tempCachedData[i] = this.cachedResultObjects[readerIndex][offsetOfBegin + i];
                }
                int nextReadLength = offsetOfEnd - cacheLength;
                IResultObject[] nextSortData = this.dfrArray[readerIndex].read(nextReadLength);
                for (int i = 0; i < nextReadLength; ++i) {
                    tempCachedData[fromBeginCachedLength + i] = nextSortData[i];
                }
                this.cachedResultObjects[readerIndex] = tempCachedData;
                this.indexOfCachedRowData[readerIndex] = begin;
                offsetOfBegin = begin - this.indexOfCachedRowData[readerIndex];
            }
            sortedData = new IResultObject[length];
            for (int i = 0; i < length; ++i) {
                sortedData[i] = this.cachedResultObjects[readerIndex][offsetOfBegin + i];
            }
        }
        return sortedData;
    }

    void writeData(int hint, int currPos, IResultObject[] resultObjects, int count) throws IOException {
        if (hint == 0) {
            int writerIndex = currPos / this.dataCountOfUnit;
            File outputFile = this.getTempFile(writerIndex);
            if (this.dfw == null) {
                this.dfw = DataFileWriter.newInstance(outputFile, this.resultObjectUtil);
            } else if (currPos % this.dataCountOfUnit == 0) {
                this.dfw.setWriteFile(outputFile);
            }
            this.dfw.write(resultObjects, count);
            this.dfw.close();
        } else {
            if (currPos == 0) {
                this.dfw.setWriteFile(this.goalFile);
            }
            this.dfw.write(resultObjects, count);
        }
    }

    void end() {
        try {
            for (int i = 0; i < this.dfrArray.length; ++i) {
                this.dfrArray[i].close();
                File tempFile = this.getTempFile(i);
                tempFile.delete();
            }
            this.tempDir.delete();
            this.dfw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tempDir = null;
        this.goalFile = null;
        this.dfrArray = null;
        this.dfw = null;
        this.indexOfCachedRowData = null;
        this.cachedResultObjects = null;
    }

    private File getTempFile(int index) {
        return new File(this.tempDirStr, "data_" + index);
    }
}

