/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.SinglePassRowProcessor;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.script.FilterPassController;

public class MultiPassRowProcessorFilterAssistant {
    private ResultSetPopulator populator;
    private SinglePassRowProcessor singlePassRowProcessor;
    private FilterPassController filterPass = new FilterPassController();

    MultiPassRowProcessorFilterAssistant(ResultSetPopulator populator, SinglePassRowProcessor singlePassRowProcessor) {
        this.populator = populator;
        this.singlePassRowProcessor = singlePassRowProcessor;
    }

    void applyFilters(OdiResultSetWrapper odaResultSet, IComputedColumnsState iccState, FilterByRow filterByRow) throws DataException {
        Iterator filterIt = filterByRow.getFilterList().iterator();
        while (filterIt.hasNext()) {
            FilterUtil.prepareFilterExpression(((IFilterDefinition)filterIt.next()).getExpression(), this.filterPass, this.populator.getEventHandler().getExecutorHelper());
        }
        this.populator.getExpressionProcessor().setResultSetMetaData(this.populator.getResultSetMetadata());
        this.populator.getExpressionProcessor().compileFilter(filterByRow.getFilterList(), iccState);
        this.doFiltering(odaResultSet, filterByRow);
    }

    private void doFiltering(OdiResultSetWrapper odaResultSet, FilterByRow filterByRow) throws DataException {
        BaseQuery query = this.populator.getQuery();
        Object[] groupings = query.getGrouping();
        Object[] orderings = query.getOrdering();
        query.setGrouping(new ArrayList());
        query.setOrdering(new ArrayList());
        this.passFilters(filterByRow, groupings, orderings, new OdiResultSetWrapper(this.populator.getResultIterator()));
    }

    private void passFilters(FilterByRow filterByRow, Object[] groupings, Object[] orderings, OdiResultSetWrapper resultSet) throws DataException {
        boolean needMultiPass = false;
        needMultiPass = FilterUtil.hasMutipassFilters(filterByRow.getFilterList());
        if (needMultiPass) {
            this.makeMultiPassToFilter(filterByRow);
        } else {
            this.singlePassRowProcessor.pass(resultSet);
        }
        this.restoreMaxRowsGroupingOrdering(groupings, orderings);
        filterByRow.setWorkingFilterSet(4);
        this.singlePassRowProcessor.pass(new OdiResultSetWrapper(this.populator.getResultIterator()));
    }

    private void makeMultiPassToFilter(FilterByRow filterByRow) throws DataException {
        int max = this.populator.getQuery().getMaxRows();
        this.populator.getQuery().setMaxRows(0);
        ResultSetCache sCache = this.populator.getCache();
        this.makeFirstPassToMultiPassFilter(filterByRow);
        this.populator.setCache(sCache);
        sCache.reset();
        sCache.next();
        this.makeSecondPassToMultiPassFilter(filterByRow, sCache);
        Iterator filterIt = filterByRow.getFilterList().iterator();
        while (filterIt.hasNext()) {
            IFilterDefinition fd = (IFilterDefinition)filterIt.next();
            if (!FilterUtil.isFilterNeedMultiPass(fd)) continue;
            fd.getExpression().setHandle(null);
        }
        this.filterPass.setSecondPassRowCount(0);
        this.populator.getQuery().setMaxRows(max);
    }

    private void makeFirstPassToMultiPassFilter(FilterByRow filterByRow) throws DataException {
        this.filterPass.setForceReset(true);
        this.filterPass.setPassLevel(1);
        this.filterPass.setRowCount(this.populator.getCache().getCount());
        ArrayList temp = new ArrayList();
        temp.addAll(filterByRow.getFilterList());
        filterByRow.getFilterList().clear();
        for (int i = 0; i < temp.size(); ++i) {
            if (!FilterUtil.isFilterNeedMultiPass((IFilterDefinition)temp.get(i))) continue;
            filterByRow.getFilterList().add(temp.get(i));
        }
        this.singlePassRowProcessor.pass(new OdiResultSetWrapper(this.populator.getResultIterator()));
        filterByRow.getFilterList().clear();
        filterByRow.getFilterList().addAll(temp);
    }

    private void makeSecondPassToMultiPassFilter(FilterByRow filterByRow, ResultSetCache sCache) throws DataException {
        this.filterPass.setPassLevel(2);
        this.singlePassRowProcessor.pass(new OdiResultSetWrapper(this.populator.getResultIterator()));
        this.filterPass.setPassLevel(0);
        this.filterPass.setRowCount(-1);
    }

    private void restoreMaxRowsGroupingOrdering(Object[] groupings, Object[] orderings) throws DataException {
        int j;
        BaseQuery query = this.populator.getQuery();
        ArrayList<Object> temp = new ArrayList<Object>();
        if (groupings != null) {
            for (j = 0; j < groupings.length; ++j) {
                temp.add(groupings[j]);
            }
        }
        query.setGrouping(temp);
        temp.clear();
        if (orderings != null) {
            for (j = 0; j < orderings.length; ++j) {
                temp.add(orderings[j]);
            }
        }
        query.setOrdering(temp);
    }
}

