/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupCalculationUtil;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class GroupInformationUtil {
    private List[] groups;
    private int leafGroupIdx = -1;
    private GroupCalculationUtil groupCalculationUtil;
    static final /* synthetic */ boolean $assertionsDisabled;

    GroupInformationUtil(GroupCalculationUtil groupCalculationUtil) {
        this.groupCalculationUtil = groupCalculationUtil;
    }

    public void setLeaveGroupIndex(int index) {
        this.leafGroupIdx = index;
    }

    public int getEndingGroupLevel() throws DataException {
        GroupInfo nextGroup;
        int level;
        this.checkHasCurrentRow();
        if (this.groupCalculationUtil.getResultSetCache().getCurrentIndex() == this.groupCalculationUtil.getResultSetCache().getCount() - 1) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.groupCalculationUtil.getResultSetCache().getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        for (level = this.groups.length - 1; level >= 0 && (nextGroup = GroupUtil.findGroup(level, currentGroupIdx + 1, this.groups)) != null && childGroupIdx == nextGroup.firstChild - 1; --level) {
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = GroupUtil.findGroup((int)level, (int)currentGroupIdx, (List[])this.groups).parent;
        }
        return level + 2;
    }

    private void checkStarted() throws DataException {
        if (this.groupCalculationUtil.getResultSetCache() == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    private void checkHasCurrentRow() throws DataException {
        this.checkStarted();
        if (this.groupCalculationUtil.getResultSetCache().getCurrentResult() == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    public int getStartingGroupLevel() throws DataException {
        int level;
        this.checkHasCurrentRow();
        if (this.groupCalculationUtil.getResultSetCache().getCurrentIndex() == 0) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.groupCalculationUtil.getResultSetCache().getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        for (level = this.groups.length - 1; level >= 0; --level) {
            GroupInfo currentGroup = GroupUtil.findGroup(level, currentGroupIdx, this.groups);
            if (childGroupIdx != currentGroup.firstChild) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = currentGroup.parent;
        }
        return level + 2;
    }

    private int findCurrentGroup(int groupLevel) {
        int currentGroupIdx = this.leafGroupIdx;
        for (int i = this.groups.length - 1; i > groupLevel; --i) {
            currentGroupIdx = GroupUtil.findGroup((int)i, (int)currentGroupIdx, (List[])this.groups).parent;
        }
        return currentGroupIdx;
    }

    public void first(int groupLevel) throws DataException {
        if (groupLevel > this.groups.length || groupLevel < 0) {
            throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
        }
        if (groupLevel == 0) {
            this.leafGroupIdx = 0;
            this.groupCalculationUtil.getResultSetCache().reset();
            this.groupCalculationUtil.getResultSetCache().next();
            return;
        }
        int currentGroupIdx = this.findCurrentGroup(--groupLevel);
        for (int i = groupLevel + 1; i < this.groups.length; ++i) {
            currentGroupIdx = GroupUtil.findGroup((int)(i - 1), (int)currentGroupIdx, (List[])this.groups).firstChild;
        }
        this.leafGroupIdx = currentGroupIdx;
        int currentRowID = GroupUtil.findGroup((int)(this.groups.length - 1), (int)this.leafGroupIdx, (List[])this.groups).firstChild;
        this.groupCalculationUtil.getResultSetCache().moveTo(currentRowID);
    }

    public void last(int groupLevel) throws DataException {
        if (groupLevel > this.groups.length || groupLevel < 0) {
            throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
        }
        int currentGroupIdx = -1;
        if (--groupLevel >= 0) {
            currentGroupIdx = this.findCurrentGroup(groupLevel);
        }
        if (groupLevel < 0 || currentGroupIdx >= this.groups[groupLevel].size() - 1) {
            int currentRowID = this.groupCalculationUtil.getResultSetCache().getCount() - 1;
            this.groupCalculationUtil.getResultSetCache().moveTo(currentRowID);
            if (this.groups.length > 0) {
                this.leafGroupIdx = this.groups[this.groups.length - 1].size() - 1;
            }
            return;
        }
        ++currentGroupIdx;
        for (int i = groupLevel + 1; i < this.groups.length; ++i) {
            currentGroupIdx = GroupUtil.findGroup((int)(i - 1), (int)currentGroupIdx, (List[])this.groups).firstChild;
        }
        int currentRowID = GroupUtil.findGroup((int)(this.groups.length - 1), (int)currentGroupIdx, (List[])this.groups).firstChild - 1;
        this.groupCalculationUtil.getResultSetCache().moveTo(currentRowID);
        this.leafGroupIdx = currentGroupIdx - 1;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        if (groupLevel == 0) {
            return 0;
        }
        this.checkHasCurrentRow();
        if (groupLevel < 0 || groupLevel > this.groups.length) {
            throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
        }
        int currentGroupIdx = this.leafGroupIdx;
        for (int level = this.groups.length - 1; level > groupLevel - 1; --level) {
            GroupInfo currentGroup = GroupUtil.findGroup(level, currentGroupIdx, this.groups);
            currentGroupIdx = currentGroup.parent;
        }
        return currentGroupIdx;
    }

    public void next(boolean hasNext) throws DataException {
        GroupInfo nextLeafGroup;
        if (hasNext && this.groups.length > 0 && (nextLeafGroup = GroupUtil.findGroup(this.groups.length - 1, this.leafGroupIdx + 1, this.groups)) != null && this.groupCalculationUtil.getResultSetCache().getCurrentIndex() >= nextLeafGroup.firstChild) {
            ++this.leafGroupIdx;
        }
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        if (groupLevel == 0) {
            return new int[]{0, this.groupCalculationUtil.getResultSetCache().getCount()};
        }
        int unitCountInOneGroup = this.groups[groupLevel - 1].size();
        if (unitCountInOneGroup == 1) {
            return new int[]{0, this.groupCalculationUtil.getResultSetCache().getCount()};
        }
        int[] unitInfo = new int[unitCountInOneGroup * 2];
        for (int i = 0; i < unitCountInOneGroup; ++i) {
            int startIndex = i;
            int endIndex = startIndex + 1;
            startIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, startIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
            endIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, endIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
            unitInfo[i * 2] = startIndex;
            unitInfo[i * 2 + 1] = endIndex;
        }
        return unitInfo;
    }

    public void doGrouping() throws DataException {
        if (!$assertionsDisabled && this.groupCalculationUtil.getResultSetCache() == null) {
            throw new AssertionError();
        }
        this.groups = new ArrayList[this.groupCalculationUtil.getGroupDefn().length];
        if (this.groups.length == 0) {
            return;
        }
        for (int i = 0; i < this.groupCalculationUtil.getGroupDefn().length; ++i) {
            this.groups[i] = new ArrayList();
        }
        IResultObject prevRow = null;
        for (int rowID = 0; rowID < this.groupCalculationUtil.getResultSetCache().getCount(); ++rowID) {
            IResultObject currRow = this.groupCalculationUtil.getResultSetCache().fetch();
            int breakLevel = rowID == 0 ? 0 : this.getBreakLevel(currRow, prevRow, rowID);
            for (int level = breakLevel; level < this.groups.length; ++level) {
                GroupInfo group = new GroupInfo();
                if (level != 0) {
                    group.parent = this.groups[level - 1].size() - 1;
                }
                group.firstChild = level == this.groups.length - 1 ? rowID : this.groups[level + 1].size();
                this.groups[level].add(group);
            }
            prevRow = currRow;
        }
        this.groupCalculationUtil.getResultSetCache().reset();
        this.setLeaveGroupIndex(0);
    }

    private int getBreakLevel(IResultObject currRow, IResultObject prevRow, int currRowPos) throws DataException {
        int breakLevel;
        if (!$assertionsDisabled && currRow == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && prevRow == null) {
            throw new AssertionError();
        }
        for (breakLevel = 0; breakLevel < this.groupCalculationUtil.getGroupDefn().length; ++breakLevel) {
            GroupBy groupBy;
            int colIndex = this.groupCalculationUtil.getGroupDefn()[breakLevel].getColumnIndex();
            Object currObjectValue = null;
            Object prevObjectValue = null;
            if (colIndex >= 0) {
                currObjectValue = currRow.getFieldValue(colIndex);
                prevObjectValue = prevRow.getFieldValue(colIndex);
            }
            if (!(groupBy = this.groupCalculationUtil.getGroupDefn()[breakLevel]).needsGroupStartValue()) {
                if (groupBy.isInSameGroup(currObjectValue, prevObjectValue)) continue;
                break;
            }
            List list = this.groups[breakLevel];
            GroupInfo groupInfo = (GroupInfo)list.get(list.size() - 1);
            int child = groupInfo.firstChild;
            for (int level = breakLevel + 1; level < this.groups.length; ++level) {
                list = this.groups[level];
                groupInfo = (GroupInfo)list.get(child);
                child = groupInfo.firstChild;
            }
            Integer groupStartValue = null;
            if (colIndex < 0) {
                groupStartValue = new Integer(child);
            }
            if (!this.groupCalculationUtil.getGroupDefn()[breakLevel].isInSameGroup(currObjectValue, prevObjectValue, groupStartValue, currRowPos)) break;
        }
        return breakLevel;
    }

    public int[] getCurrentGroupInfo(int groupLevel) throws DataException {
        if (groupLevel == 0) {
            return new int[]{0, this.groupCalculationUtil.getResultSetCache().getCount()};
        }
        int groupLevelIndex = this.leafGroupIdx;
        for (int i = this.groups.length - 1; i > groupLevel - 1; --i) {
            List parentGroupInfo = this.groups[i];
            GroupInfo groupInfo = (GroupInfo)parentGroupInfo.get(groupLevelIndex);
            groupLevelIndex = groupInfo.parent;
        }
        int startIndex = groupLevelIndex;
        int endIndex = startIndex + 1;
        startIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, startIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
        endIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, endIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
        return new int[]{startIndex, endIndex};
    }

    void readGroupsFromStream(InputStream inputStream) throws IOException {
        int size = IOUtil.readInt((InputStream)inputStream);
        this.groups = new ArrayList[size];
        for (int i = 0; i < size; ++i) {
            ArrayList<GroupInfo> list = new ArrayList<GroupInfo>();
            int asize = IOUtil.readInt((InputStream)inputStream);
            for (int j = 0; j < asize; ++j) {
                GroupInfo groupInfo = new GroupInfo();
                groupInfo.parent = IOUtil.readInt((InputStream)inputStream);
                groupInfo.firstChild = IOUtil.readInt((InputStream)inputStream);
                list.add(groupInfo);
            }
            this.groups[i] = list;
        }
    }

    void saveGroupsToStream(OutputStream outputStream) throws IOException {
        int size = this.groups.length;
        IOUtil.writeInt((OutputStream)outputStream, (int)size);
        for (int i = 0; i < size; ++i) {
            List list = this.groups[i];
            int asize = list.size();
            IOUtil.writeInt((OutputStream)outputStream, (int)asize);
            for (int j = 0; j < asize; ++j) {
                GroupInfo groupInfo = (GroupInfo)list.get(j);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.parent);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.firstChild);
            }
        }
    }

    ArrayList[] getGroupBoundaryInfos() throws DataException {
        ArrayList[] groupBoundaryInfos = new ArrayList[this.groups.length];
        for (int i = 1; i <= this.groups.length; ++i) {
            groupBoundaryInfos[i - 1] = new ArrayList();
            for (int j = 0; j < this.groups[i - 1].size(); ++j) {
                groupBoundaryInfos[i - 1].add(this.getGroupBoundaryInfo(i, j));
            }
        }
        return groupBoundaryInfos;
    }

    private GroupBoundaryInfo getGroupBoundaryInfo(int groupLevel, int groupIndex) throws DataException {
        int startIdx = GroupUtil.getGroupFirstRowIndex(groupLevel, groupIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
        int endIdx = this.groupCalculationUtil.getResultSetCache().getCount() - 1;
        if (groupIndex < this.groups[groupLevel - 1].size() - 1) {
            endIdx = GroupUtil.getGroupFirstRowIndex(groupLevel, groupIndex + 1, this.groups, this.groupCalculationUtil.getResultSetCache().getCount()) - 1;
        }
        if (!$assertionsDisabled && startIdx < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && endIdx < 0) {
            throw new AssertionError();
        }
        GroupBoundaryInfo result = new GroupBoundaryInfo(startIdx, endIdx);
        return result;
    }

    private List mergeTwoGroupBoundaryInfoGroups(List higherGroup, List lowerGroup) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < higherGroup.size(); ++i) {
            GroupBoundaryInfo gbi1 = (GroupBoundaryInfo)higherGroup.get(i);
            for (int j = 0; j < lowerGroup.size(); ++j) {
                if (!gbi1.isInBoundary((GroupBoundaryInfo)lowerGroup.get(j))) continue;
                result.add(lowerGroup.get(j));
            }
        }
        return result;
    }

    OrderingInfo getOrderingInfo(List[] groups) {
        for (int i = 1; i < groups.length; ++i) {
            groups[i] = this.mergeTwoGroupBoundaryInfoGroups(groups[i - 1], groups[i]);
        }
        OrderingInfo odInfo = new OrderingInfo();
        for (int i = 0; i < groups[groups.length - 1].size(); ++i) {
            odInfo.add(((GroupBoundaryInfo)groups[groups.length - 1].get(i)).getStartIndex(), ((GroupBoundaryInfo)groups[groups.length - 1].get(i)).getEndIndex());
        }
        return odInfo;
    }

    static {
        $assertionsDisabled = !GroupInformationUtil.class.desiredAssertionStatus();
    }
}

