/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;

public final class ComplexExpression
extends BytecodeExpression {
    private ArrayList m_subExpressions;
    private ArrayList m_tokenList;
    private ArrayList m_constantExpressions;
    static final /* synthetic */ boolean $assertionsDisabled;

    ComplexExpression() {
        logger.entering(ComplexExpression.class.getName(), "ComplexExpression");
        this.m_subExpressions = new ArrayList();
        this.m_tokenList = new ArrayList();
        this.m_constantExpressions = new ArrayList();
        logger.exiting(ComplexExpression.class.getName(), "ComplexExpression");
    }

    int getType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ComplexExpression)) {
            return false;
        }
        ComplexExpression expr2 = (ComplexExpression)other;
        Iterator iter = expr2.getSubExpressions().iterator();
        if (this.m_subExpressions.size() != expr2.getSubExpressions().size()) {
            return false;
        }
        for (int i = 0; i < this.m_subExpressions.size() && iter.hasNext(); ++i) {
            if (this.m_subExpressions.get(i).equals(iter.next())) continue;
            return false;
        }
        if (this.m_tokenList.size() != expr2.getTokenList().size()) {
            return false;
        }
        Iterator tokenIterator = expr2.getTokenList().iterator();
        for (int i = 0; i < this.m_tokenList.size() && tokenIterator.hasNext(); ++i) {
            if (this.m_tokenList.get(i).equals(tokenIterator.next())) continue;
            return false;
        }
        Iterator constantIterator = expr2.getConstantExpressions().iterator();
        for (int i = 0; i < this.m_tokenList.size() && constantIterator.hasNext(); ++i) {
            if (this.m_constantExpressions.get(i).equals(constantIterator.next())) continue;
            return false;
        }
        return true;
    }

    void addSubExpressions(Collection subExprs) {
        if (!$assertionsDisabled && subExprs == null) {
            throw new AssertionError();
        }
        this.m_subExpressions.addAll(subExprs);
    }

    void addSubExpression(CompiledExpression subExpr) {
        if (!$assertionsDisabled && subExpr == null) {
            throw new AssertionError();
        }
        this.m_subExpressions.add(subExpr);
    }

    void addContantsExpressions(Collection subExprs) {
        if (!$assertionsDisabled && subExprs == null) {
            throw new AssertionError();
        }
        this.m_constantExpressions.addAll(subExprs);
    }

    void addContantsExpressions(CompiledExpression subExprs) {
        if (!$assertionsDisabled && subExprs == null) {
            throw new AssertionError();
        }
        this.m_constantExpressions.add(subExprs);
    }

    void addTokenList(Integer token) {
        this.m_tokenList.add(token);
    }

    Collection getTokenList() {
        return this.m_tokenList;
    }

    Collection getConstantExpressions() {
        return this.m_constantExpressions;
    }

    Collection getSubExpressions() {
        return this.m_subExpressions;
    }

    static {
        $assertionsDisabled = !ComplexExpression.class.desiredAssertionStatus();
    }
}

