/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.Iterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.mozilla.javascript.Context;

public class ExpressionCompilerUtil {
    private static final String ROWNUM = "__rownum";
    private static ExpressionCompiler expressionCompiler = new ExpressionCompiler();

    public static CompiledExpression compile(String expr, Context cx) {
        return expressionCompiler.compile(expr, null, cx);
    }

    public static boolean hasColumnRow(String name, ExprManager exprManager) {
        if (name == null) {
            return false;
        }
        if (name.equals(ROWNUM)) {
            return true;
        }
        IScriptExpression expr = (IScriptExpression)exprManager.getExpr(name);
        if (expr == null) {
            return false;
        }
        String expression = expr.getText();
        return ExpressionCompilerUtil.compile(expression, exprManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compile(String expression, ExprManager exprManager) {
        Context context = Context.enter();
        AggregateRegistry aggrReg = new AggregateRegistry(){

            public int register(AggregateExpression aggregationExpr) {
                return -1;
            }
        };
        try {
            CompiledExpression expr = expressionCompiler.compile(expression, aggrReg, context);
            boolean bl = ExpressionCompilerUtil.flattenExpression(expr, exprManager);
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    private static boolean flattenExpression(CompiledExpression expr, ExprManager exprManager) {
        int type = expr.getType();
        switch (type) {
            case 3: {
                Iterator col = ((ComplexExpression)expr).getSubExpressions().iterator();
                while (col.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)col.next(), exprManager)) continue;
                    return false;
                }
                break;
            }
            case 1: {
                String columnName = ((ColumnReferenceExpression)expr).getColumnName();
                if (ROWNUM.equals(columnName)) {
                    return true;
                }
                if (exprManager.getExpr(columnName) != null) {
                    String expression = ((IScriptExpression)exprManager.getExpr(columnName)).getText();
                    return ExpressionCompilerUtil.compile(expression, exprManager);
                }
                return false;
            }
            case 2: {
                Iterator args = ((AggregateExpression)expr).getArguments().iterator();
                while (args.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)args.next(), exprManager)) continue;
                    return false;
                }
            }
            case 4: 
            case 5: {
                return true;
            }
        }
        return true;
    }
}

