/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.AbstractExpressionParser;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregateObject;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.AggregationTablePopulator;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.Scriptable;

class ExpressionParseHelper
extends AbstractExpressionParser {
    private BaseQuery query;
    private int totalPassLevel = 0;
    private int passLevel = 0;
    private IResultClass resultSetMetaData;
    private ArrayList aggrObjList = null;
    private List availableCmpList;
    private List caculatedAggregateList;
    private int exprType;
    private int currentGroupLevel;
    private AggregateTable table;
    private boolean hasAggregate = false;
    private boolean hasNesetedAggregate = false;
    private boolean useRsMetaData = true;
    private Scriptable scope;
    private ResultSetPopulator rsPopulator;
    private final String ROW_INDICATOR = "row";
    private final String TOTAL_OVERALL = "Total.OVERALL";
    private List currentGroupLevelList = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    ExpressionParseHelper(IResultClass metaData, Scriptable scope) {
        this.resultSetMetaData = metaData;
        this.aggrObjList = new ArrayList();
        this.currentGroupLevel = 0;
        this.scope = scope;
    }

    CompiledExpression compileDirectColRefExpr(Node parent, Node refNode, boolean customerChecked) throws DataException {
        ColumnReferenceExpression expr = super.compileColRefExpr(refNode, customerChecked);
        if (customerChecked && expr != null && expr.getColumnName() != null && expr.getColumnName().trim().length() > 0) {
            this.checkAvailableCmpColumn(expr.getColumnName());
        }
        return expr;
    }

    AggregateExpression compileAggregateExpr(Context context, Node parent, Node callNode) throws DataException {
        if (!$assertionsDisabled && callNode.getType() != 37) {
            throw new AssertionError();
        }
        IAggregation aggregation = super.getAggregationFunction(callNode);
        if (aggregation == null) {
            return null;
        }
        this.passLevel = 0;
        AggregateExpression aggregateExpression = new AggregateExpression(aggregation);
        AggregateObject aggregateObj = new AggregateObject(aggregateExpression);
        this.hasAggregate = true;
        this.extractArguments(context, aggregateExpression, callNode);
        Iterator iter = aggregateExpression.getArguments().iterator();
        while (iter.hasNext()) {
            CompiledExpression argumentExpr = (CompiledExpression)iter.next();
            if (argumentExpr instanceof AggregateExpression) {
                if (this.canBeCalculated(new AggregateObject((AggregateExpression)argumentExpr))) {
                    --this.passLevel;
                }
                this.hasNesetedAggregate = true;
                continue;
            }
            if (!(argumentExpr instanceof ComplexExpression)) continue;
            this.flatternAggregateExpression((ComplexExpression)argumentExpr);
        }
        this.currentGroupLevel = this.getCurrentGroupLevel(aggregateObj, context);
        if (this.exprType == 2 || this.exprType == 3 || this.exprType == 4) {
            aggregateObj.setPassLevel(1);
        } else {
            aggregateObj.setPassLevel(++this.passLevel);
        }
        int id = this.registerAggregate(aggregateObj);
        if (id >= 0) {
            this.replaceAggregateNode(id, parent, callNode);
        }
        this.setTotalPassLevel(this.passLevel);
        return aggregateExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentGroupLevel(AggregateObject aggregateObj, Context context) throws DataException {
        Object groupLevelObj;
        AggregateExpression expr = aggregateObj.getAggregateExpr();
        IAggregation aggr = expr.getAggregation();
        List argList = expr.getArguments();
        int nFixedArgs = aggr.getParameterDefn().length;
        int groupLevel = this.currentGroupLevel;
        int nArgs = argList.size();
        CompiledExpression groupExpr = null;
        if (nArgs > nFixedArgs + 2 || nArgs < nFixedArgs) {
            DataException e = new DataException("data.engine.WrongNumAggrArgs", expr.getAggregation().getName());
            throw e;
        }
        if (nArgs == nFixedArgs + 2) {
            groupExpr = (CompiledExpression)argList.get(nArgs - 1);
        }
        if (groupExpr != null && !(groupExpr instanceof ConstantExpression)) {
            DataException e = new DataException("data.engine.InvalidAggrGroupExpression", aggr.getName());
            throw e;
        }
        Context cx = Context.enter();
        try {
            if (groupExpr != null) {
                groupLevelObj = groupExpr.evaluate(cx, this.scope);
            } else {
                String currentGroupName = null;
                currentGroupName = this.currentGroupLevelList.size() == 0 ? this.getScriptExpression().getGroupName() : this.currentGroupLevelList.get(this.currentGroupLevelList.size() - 1).toString();
                groupLevelObj = currentGroupName.equals("Total.OVERALL") ? new Integer(0) : currentGroupName;
            }
        }
        finally {
            Context.exit();
        }
        if (groupLevelObj != null) {
            if (groupLevelObj instanceof String) {
                int level = AggregationConstantsUtil.getGroupLevel((String)groupLevelObj, this.currentGroupLevel, this.query.getGrouping() == null ? 0 : this.query.getGrouping().length, false);
                groupLevel = level != -1 ? level : this.getGroupIndex((String)groupLevelObj);
            } else if (groupLevelObj instanceof Number) {
                int offset = ((Number)groupLevelObj).intValue();
                groupLevel = offset < 0 ? this.currentGroupLevel + offset : offset;
            }
        }
        switch (this.exprType) {
            case 3: {
                if (groupLevel == this.currentGroupLevel) break;
                DataException e = new DataException("data.engine.InvalidGroupLevel", aggr.getName());
                throw e;
            }
            case 4: {
                if (groupLevel >= 0 && groupLevel <= this.currentGroupLevel) break;
                DataException e = new DataException("data.engine.InvalidGroupLevel", aggr.getName());
                throw e;
            }
            default: {
                if (groupLevel >= 0) break;
                DataException e = new DataException("data.engine.InvalidGroupLevel", aggr.getName());
                throw e;
            }
        }
        return groupLevel;
    }

    private int getGroupIndex(String groupText) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.query == null) {
            throw new AssertionError();
        }
        IQuery.GroupSpec[] groups = this.query.getGrouping();
        for (int i = 0; i < groups.length; ++i) {
            IQuery.GroupSpec group = groups[i];
            if (!groupText.equals(group.getName()) && !groupText.equals(group.getKeyColumn())) continue;
            return i + 1;
        }
        return -1;
    }

    private void checkAvailableCmpColumn(String rowColumnName) throws DataException {
        if (!(!this.useRsMetaData || this.resultSetMetaData != null && !this.resultSetMetaData.isCustomField(rowColumnName) || this.availableCmpList != null && this.availableCmpList.contains(rowColumnName))) {
            ++this.passLevel;
        }
    }

    int getExpressionPassLevel() {
        return this.totalPassLevel;
    }

    private void extractArguments(Context context, AggregateExpression aggregateExpression, Node callNode) throws DataException {
        Node arg = callNode.getFirstChild().getNext();
        while (arg != null) {
            int registry;
            Node nextArg = arg.getNext();
            CompiledExpression expr = this.processChild(context, true, callNode, arg, null);
            if (!(expr instanceof BytecodeExpression)) {
                aggregateExpression.addArgument(expr);
                arg = nextArg;
                continue;
            }
            ScriptOrFnNode tree = new ScriptOrFnNode(132);
            Node exprNode = new Node(130);
            exprNode.addChildToFront(arg);
            tree.addChildrenToFront(exprNode);
            if (expr instanceof AggregateExpression && (registry = this.getRegisterId(new AggregateObject((AggregateExpression)expr))) >= 0) {
                this.replaceAggregateNode(registry, exprNode, arg);
            }
            this.compileForBytecodeExpr(context, tree, expr);
            aggregateExpression.addArgument(expr);
            arg = nextArg;
        }
    }

    public CompiledExpression processChild(Context context, boolean customerChecked, Node parent, Node child, Node grandfather) throws DataException {
        String columnBindingName;
        if (!(child.getType() != 33 && child.getType() != 35 || this.getDataSetMode() || child.getFirstChild().getType() != 38 || child.getLastChild().getType() != 40 || !child.getFirstChild().getString().equals(this.ROW_INDICATOR) || (columnBindingName = child.getLastChild().getString()) == null || columnBindingName.equals("_outer") || columnBindingName.equals("__rownum") || columnBindingName.equals("0"))) {
            ScriptExpression expression = (ScriptExpression)this.rsPopulator.getEventHandler().getBaseExpr(columnBindingName);
            if (expression == null) {
                throw new DataException("data.engine.BadDataExpression");
            }
            this.currentGroupLevelList.add(expression.getGroupName());
            ScriptOrFnNode tree = this.parse(expression.getText(), context);
            CompiledExpression expr = null;
            if (grandfather != null) {
                grandfather.replaceChild(parent, tree.getFirstChild());
                expr = this.processChild(context, false, grandfather.getFirstChild(), tree.getFirstChild().getFirstChild(), grandfather);
            } else {
                parent.replaceChild(child, tree.getFirstChild().getFirstChild());
                expr = this.processChild(context, false, parent, tree.getFirstChild().getFirstChild(), grandfather);
            }
            this.currentGroupLevelList.remove(this.currentGroupLevelList.size() - 1);
            if (expr != null && expr instanceof ColumnReferenceExpression) {
                ((ColumnReferenceExpression)expr).setDataType(expression.getDataType());
                return expr;
            }
        }
        return super.processChild(context, customerChecked, parent, child, grandfather);
    }

    private int getRegisterId(AggregateObject obj1) {
        if (this.aggrObjList == null) {
            return -1;
        }
        for (int i = 0; i < this.aggrObjList.size(); ++i) {
            AggregateObject obj2 = (AggregateObject)this.aggrObjList.get(i);
            if (!obj1.equals(obj2)) continue;
            return obj2.getRegisterId();
        }
        return -1;
    }

    private boolean canBeCalculated(AggregateObject aggregateObj) {
        if (this.caculatedAggregateList == null) {
            return false;
        }
        for (int i = 0; i < this.caculatedAggregateList.size(); ++i) {
            AggregateObject obj = (AggregateObject)this.caculatedAggregateList.get(i);
            if (!obj.equals(aggregateObj)) continue;
            return true;
        }
        return false;
    }

    List getAggregateList(int level) {
        if (this.aggrObjList == null) {
            return null;
        }
        ArrayList<AggregateObject> levelList = new ArrayList<AggregateObject>();
        for (int i = 0; i < this.aggrObjList.size(); ++i) {
            AggregateObject aggrObj = (AggregateObject)this.aggrObjList.get(i);
            if (aggrObj.getPassLevel() > level || aggrObj.isAvailable()) continue;
            levelList.add(aggrObj);
        }
        return levelList;
    }

    private void flatternAggregateExpression(ComplexExpression complexExpr) throws DataException {
        Collection subExprs = complexExpr.getSubExpressions();
        Iterator iter = subExprs.iterator();
        while (iter.hasNext()) {
            CompiledExpression childExpr = (CompiledExpression)iter.next();
            if (childExpr instanceof AggregateExpression) {
                if (this.canBeCalculated(new AggregateObject((AggregateExpression)childExpr))) {
                    --this.passLevel;
                    return;
                }
                this.hasNesetedAggregate = true;
                continue;
            }
            if (!(childExpr instanceof ComplexExpression)) continue;
            Collection childSubExprs = ((ComplexExpression)childExpr).getSubExpressions();
            Iterator childIter = childSubExprs.iterator();
            while (childIter.hasNext()) {
                CompiledExpression childChildExpr = (CompiledExpression)childIter.next();
                if (!(childChildExpr instanceof AggregateExpression) || !this.canBeCalculated(new AggregateObject((AggregateExpression)childExpr))) continue;
                --this.passLevel;
                return;
            }
        }
    }

    private int registerAggregate(AggregateObject aggregateObj) throws DataException {
        int index = -1;
        if (this.table == null) {
            this.table = AggregationTablePopulator.createAggregateTable(this.query);
        }
        if (aggregateObj.getPassLevel() <= 1) {
            index = AggregationTablePopulator.populateAggregationTable(this.table, aggregateObj, this.currentGroupLevel, false, false);
            if (this.aggrObjList == null) {
                this.aggrObjList = new ArrayList();
            }
            aggregateObj.setRegisterId(index);
            this.aggrObjList.add(aggregateObj);
        }
        return index;
    }

    AggregateTable getAggregateTable() {
        return this.table;
    }

    void setQuery(BaseQuery query) {
        this.query = query;
    }

    void resetPassLevel() {
        this.totalPassLevel = 0;
        this.passLevel = 0;
    }

    boolean hasNestedAggregate() {
        return this.hasNesetedAggregate;
    }

    private void setTotalPassLevel(int passLevel) {
        this.totalPassLevel = this.totalPassLevel < passLevel ? passLevel : 0;
    }

    void addAvailableCmpColumn(String name) {
        if (this.availableCmpList == null) {
            this.availableCmpList = new ArrayList();
        }
        this.availableCmpList.add(name);
    }

    void addAvailableAggregateObj(AggregateObject obj) {
        if (this.caculatedAggregateList == null) {
            this.caculatedAggregateList = new ArrayList();
        }
        this.caculatedAggregateList.add(obj);
    }

    void setExpressionType(int exprType, int currentGroupLevel) {
        this.exprType = exprType;
        this.currentGroupLevel = currentGroupLevel;
    }

    void clear() {
        this.aggrObjList = null;
        this.availableCmpList = null;
        this.caculatedAggregateList = null;
        this.table = null;
        this.hasNesetedAggregate = false;
        this.hasAggregate = false;
        this.exprType = 0;
        this.resetPassLevel();
        AggregationTablePopulator.close();
    }

    public void setMetaData(IResultClass metaData) {
        this.resultSetMetaData = metaData;
    }

    public void setResultSetPopulator(ResultSetPopulator rsPopulator) {
        this.rsPopulator = rsPopulator;
    }

    public void useResultSetMetaData(boolean useRsMetaData) {
        this.useRsMetaData = useRsMetaData;
    }

    public void setAggregateStatus(boolean hasAggregate) {
        this.hasAggregate = hasAggregate;
    }

    public boolean getAggregateStatus() {
        return this.hasAggregate;
    }

    public int getCurrentGroupLevel() {
        return this.currentGroupLevel;
    }

    public int getCurrentExpressionType() {
        return this.exprType;
    }

    static {
        $assertionsDisabled = !ExpressionParseHelper.class.desiredAssertionStatus();
    }
}

