/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.AbstractExpressionParser;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

public class FilterExpressionParser
extends AbstractExpressionParser {
    private Context context = Context.enter();
    private ResultSetPopulator rsPopulator;
    static final /* synthetic */ boolean $assertionsDisabled;

    FilterExpressionParser() {
    }

    public FilterExpressionParser(IResultClass resultSetMetaData, IComputedColumnsState computedColumnState) {
    }

    public CompiledExpression compileFilterExpression(String expression) throws DataException {
        try {
            ScriptOrFnNode tree = this.parse(expression, this.context);
            CompiledExpression expr = this.processScriptTree(tree, this.context);
            return expr;
        }
        catch (Exception e) {
            DataException dataException = new DataException("data.engine.InvalidJSExpr", e);
            throw dataException;
        }
    }

    private CompiledExpression processScriptTree(ScriptOrFnNode tree, Context context) throws DataException {
        CompiledExpression expr = null;
        if (tree.getFirstChild() == tree.getLastChild()) {
            Node exprNode = tree.getFirstChild();
            Node child = exprNode.getFirstChild();
            if (!$assertionsDisabled && child == null) {
                throw new AssertionError();
            }
            expr = this.processChild(context, exprNode, child, (Node)tree);
        } else {
            expr = this.compileComplexExpr(context, (Node)tree, false);
        }
        if (expr instanceof BytecodeExpression) {
            this.compileForBytecodeExpr(context, tree, expr);
        }
        return expr;
    }

    public CompiledExpression processChild(Context context, Node parent, Node child, Node grandfather) throws DataException {
        String columnBindingName;
        if ((child.getType() == 33 || child.getType() == 35) && !this.getDataSetMode() && child.getFirstChild().getType() == 38 && child.getLastChild().getType() == 40 && child.getFirstChild().getString().equals("row") && (columnBindingName = child.getLastChild().getString()) != null) {
            ScriptExpression expression = (ScriptExpression)this.rsPopulator.getEventHandler().getBaseExpr(columnBindingName);
            ScriptOrFnNode tree = this.parse(expression.getText(), context);
            if (grandfather != null) {
                grandfather.replaceChild(parent, tree.getFirstChild());
                return this.processChild(context, false, grandfather.getFirstChild(), tree.getFirstChild().getFirstChild(), grandfather);
            }
            parent.replaceChild(child, tree.getFirstChild().getFirstChild());
            return this.processChild(context, false, parent, tree.getFirstChild().getFirstChild(), grandfather);
        }
        CompiledExpression compiledExpr = null;
        switch (child.getType()) {
            case 33: {
                ConstantExpression ce = AggregationConstantsUtil.getConstantExpression(child);
                if (ce != null) {
                    compiledExpr = ce;
                    break;
                }
            }
            case 35: {
                compiledExpr = this.compileDirectColRefExpr(parent, child, false);
                break;
            }
            case 37: {
                compiledExpr = this.compileAggregateExpr(context, parent, child);
                break;
            }
            default: {
                compiledExpr = super.processChild(context, false, parent, child, grandfather);
            }
        }
        if (compiledExpr == null) {
            compiledExpr = this.compileComplexExpr(context, child, false);
        }
        return compiledExpr;
    }

    CompiledExpression compileDirectColRefExpr(Node parentNode, Node refNode, boolean checked) throws DataException {
        ColumnReferenceExpression expression = super.compileColRefExpr(refNode, false);
        if (expression == null) {
            return null;
        }
        this.isLegal(expression);
        return expression;
    }

    private void isLegal(ColumnReferenceExpression expression) throws DataException {
        String name;
        int idx;
        if (expression.isIndexed() ? (idx = expression.getColumnindex()) == 0 : "_rowPosition".equals(name = expression.getColumnName())) {
            throw new DataException("data.engine.BadFilterExpr");
        }
    }

    AggregateExpression compileAggregateExpr(Context context, Node parent, Node callNode) throws DataException {
        if (!$assertionsDisabled && callNode.getType() != 37) {
            throw new AssertionError();
        }
        IAggregation aggregation = this.getAggregationFunction(callNode);
        if (aggregation == null) {
            return null;
        }
        throw new DataException("data.engine.NoAggrFunc");
    }

    public void setResultSetPopulator(ResultSetPopulator rsPopulator) {
        this.rsPopulator = rsPopulator;
    }

    static {
        $assertionsDisabled = !FilterExpressionParser.class.desiredAssertionStatus();
    }
}

