/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.mozilla.javascript.Scriptable;

public class OdaDataSourceRuntime
extends DataSourceRuntime {
    private String extensionID;
    private Map publicProperties = new HashMap();

    OdaDataSourceRuntime(IOdaDataSourceDesign dataSource, Scriptable sharedScope) {
        super(dataSource, sharedScope);
        this.publicProperties.putAll(dataSource.getPublicProperties());
        this.extensionID = dataSource.getExtensionID();
        logger.log(Level.FINER, "OdaDataSourceRuntime starts up");
    }

    public IOdaDataSourceDesign getSubdesign() {
        return (IOdaDataSourceDesign)this.getDesign();
    }

    public String getExtensionID() {
        return this.extensionID;
    }

    public Map getPublicProperties() {
        return this.publicProperties;
    }

    public Map getPrivateProperties() {
        return this.getSubdesign().getPrivateProperties();
    }

    public Map getAllExtensionProperties() {
        return this.publicProperties;
    }

    public String getExtensionProperty(String name) {
        return (String)this.publicProperties.get(name);
    }

    public void setExtensionProperty(String name, String value) {
        this.publicProperties.put(name, value);
    }
}

