/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.PreparedIVQuery;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class QueryResults
implements IQueryResults,
IQueryService {
    private DataEngineContext context;
    private Scriptable queryScope;
    private int nestedLevel;
    private String rootQueryResultID;
    private String selfQueryResultID;
    private IServiceForQueryResults queryService;
    private ResultIterator iterator;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    QueryResults(IServiceForQueryResults queryService, Scriptable queryScope, int nestedLevel) {
        if (!$assertionsDisabled && queryService == null) {
            throw new AssertionError();
        }
        this.context = queryService.getContext();
        this.queryService = queryService;
        this.queryScope = queryScope;
        this.nestedLevel = nestedLevel;
        logger.logp(Level.FINER, QueryResults.class.getName(), "QueryResults", "QueryResults starts up");
    }

    public String getID() {
        if (this.selfQueryResultID == null) {
            this.selfQueryResultID = QueryResultIDUtil.nextID();
        }
        return QueryResultIDUtil.buildID(this.rootQueryResultID, this.selfQueryResultID);
    }

    public IPreparedQuery getPreparedQuery() {
        return this.queryService.getPreparedQuery();
    }

    public IResultMetaData getResultMetaData() throws DataException {
        IResultMetaData iResultMetaData;
        if (this.queryService == null) {
            throw new DataException("data.engine.ResultClosed");
        }
        try {
            iResultMetaData = this.queryService.getResultMetaData();
            Object var3_3 = null;
            logger.logp(Level.FINE, QueryResults.class.getName(), "getResultMetaData", "return the result metadata");
        }
        catch (DataException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                logger.logp(Level.FINE, QueryResults.class.getName(), "getResultMetaData", "return the result metadata");
                throw throwable;
            }
        }
        return iResultMetaData;
    }

    public IResultIterator getResultIterator() throws DataException {
        logger.logp(Level.FINE, QueryResults.class.getName(), "getResultIterator", "start");
        if (this.queryService == null) {
            throw new DataException("data.engine.ResultClosed");
        }
        if (this.iterator == null) {
            this.initAutoBinding();
            if (!(this.queryService.getPreparedQuery() instanceof PreparedIVQuery)) {
                this.queryService.validateQueryColumBinding();
            }
            this.iterator = new ResultIterator(new ResultService(this.context, this), this.queryService.executeQuery(), this.queryScope);
        }
        logger.logp(Level.FINE, QueryResults.class.getName(), "getResultIterator", "finished");
        return this.iterator;
    }

    private void initAutoBinding() throws DataException {
        if (!this.queryService.needAutoBinding()) {
            return;
        }
        Context cx = Context.enter();
        IResultMetaData metaData = this.queryService.getResultMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            int colIndex = i + 1;
            try {
                String colName = metaData.getColumnAlias(colIndex);
                if (colName == null) {
                    colName = metaData.getColumnName(colIndex);
                }
                ScriptExpression baseExpr = new ScriptExpression("dataSetRow[\"" + JavascriptEvalUtil.transformToJsConstants((String)colName) + "\"]", metaData.getColumnType(colIndex));
                CompiledExpression compiledExpr = ExpressionCompilerUtil.compile(baseExpr.getText(), cx);
                baseExpr.setHandle(compiledExpr);
                this.queryService.addAutoBindingExpr(colName, baseExpr);
                continue;
            }
            catch (BirtException e) {
                // empty catch block
            }
        }
        Context.exit();
    }

    public void close() throws BirtException {
        if (this.queryService == null) {
            logger.logp(Level.FINE, QueryResults.class.getName(), "close", "QueryResults is closed");
            return;
        }
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        this.queryService.close();
        this.queryService = null;
        logger.logp(Level.FINE, QueryResults.class.getName(), "close", "QueryResults is closed");
    }

    void setID(String rootQueryResultID, String selfQueryResultID) {
        this.rootQueryResultID = rootQueryResultID;
        this.selfQueryResultID = selfQueryResultID;
    }

    void setID(String selfQueryResultID) {
        this.setID(null, selfQueryResultID);
    }

    int getGroupLevel() {
        return this.queryService.getGroupLevel();
    }

    public boolean isClosed() {
        return this.queryService == null;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public Scriptable getQueryScope() {
        return this.queryScope;
    }

    public IExecutorHelper getExecutorHelper() throws DataException {
        return ((ResultIterator)this.getResultIterator()).odiResult.getExecutorHelper();
    }

    public DataSetRuntime[] getDataSetRuntime(int count) {
        return this.queryService.getDataSetRuntimes(count);
    }

    static {
        $assertionsDisabled = !QueryResults.class.desiredAssertionStatus();
        logger = Logger.getLogger(QueryResults.class.getName());
    }

    private static class ResultService
    implements IServiceForResultSet {
        private DataEngineContext context;
        private QueryResults queryResults;

        public ResultService(DataEngineContext context, QueryResults queryResults) {
            this.context = context;
            this.queryResults = queryResults;
        }

        public DataEngineContext getContext() {
            return this.context;
        }

        public IQueryResults getQueryResults() {
            return this.queryResults;
        }

        public IBaseQueryDefinition getQueryDefn() {
            return this.queryResults.queryService.getQueryDefn();
        }

        public IQueryResults execSubquery(org.eclipse.birt.data.engine.odi.IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
            return this.queryResults.queryService.execSubquery(iterator, subQueryName, subScope);
        }

        public IBaseExpression getBaseExpression(String exprName) {
            return this.queryResults.queryService.getBaseExpression(exprName);
        }

        public IScriptExpression getAutoBindingExpr(String exprName) {
            return this.queryResults.queryService.getAutoBindingExpr(exprName);
        }

        public List getAllBindingExprs() {
            return this.queryResults.queryService.getAllBindingExprs();
        }

        public Map getAllAutoBindingExprs() {
            return this.queryResults.queryService.getAllAutoBindingExprs();
        }
    }
}

