/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.Aggregation;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class AggregateCalculator {
    private List[] aggrValues;
    private Object[][] aggrArgs;
    private AggregateTable aggrTable;
    private int aggrCount;
    private IResultIterator odiResult;
    private boolean hasOdiResultDataRows;
    private AccumulatorManager[] accumulatorManagers;
    private Set invalidAggrSet;
    private Map invalidAggrMsg;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AggregateCalculator(AggregateTable aggrTable, IResultIterator odiResult) {
        logger.entering(AggregateCalculator.class.getName(), "AggregateCalculator");
        if (!$assertionsDisabled && aggrTable == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && odiResult == null) {
            throw new AssertionError();
        }
        this.aggrTable = aggrTable;
        this.odiResult = odiResult;
        this.aggrCount = aggrTable.getCount();
        if (this.aggrCount > 0) {
            this.aggrValues = new List[this.aggrCount];
            this.aggrArgs = new Object[this.aggrCount][];
            for (int i = 0; i < this.aggrCount; ++i) {
                this.aggrValues[i] = new ArrayList();
                AggregateTable.AggrExprInfo aggrInfo = aggrTable.getAggrInfo(i);
                this.aggrArgs[i] = new Object[aggrInfo.aggregation.getParameterDefn().length];
            }
            this.accumulatorManagers = new AccumulatorManager[this.aggrTable.getCount()];
        }
        logger.exiting(AggregateCalculator.class.getName(), "AggregateCalculator");
    }

    public void calculate(Scriptable scope) throws DataException {
        logger.entering(AggregateCalculator.class.getName(), "calculate");
        ArrayList<Integer> validAggregations = new ArrayList<Integer>();
        boolean[] populateAggrValue = new boolean[this.aggrTable.getCount()];
        int count = 1;
        for (int i = 0; i < this.aggrTable.getCount(); ++i) {
            validAggregations.add(new Integer(i));
            populateAggrValue[i] = !(this.aggrTable.getAggrInfo((int)i).aggregation instanceof Aggregation) || ((Aggregation)this.aggrTable.getAggrInfo((int)i).aggregation).getNumberOfPasses() <= 1;
            this.accumulatorManagers[i] = new AccumulatorManager(this.aggrTable.getAggrInfo((int)i).aggregation);
        }
        while (validAggregations.size() > 0) {
            int[] validAggregationArray = new int[validAggregations.size()];
            for (int i = 0; i < validAggregations.size(); ++i) {
                validAggregationArray[i] = (Integer)validAggregations.get(i);
            }
            if (!$assertionsDisabled && this.odiResult.getCurrentResultIndex() != 0) {
                throw new AssertionError();
            }
            if (this.odiResult.getCurrentResult() == null) {
                this.hasOdiResultDataRows = false;
                return;
            }
            this.hasOdiResultDataRows = true;
            this.pass(scope, populateAggrValue, validAggregationArray);
            this.odiResult.first(0);
            this.prepareNextIteration(validAggregations, populateAggrValue, ++count);
        }
        logger.exiting(AggregateCalculator.class.getName(), "calculate");
    }

    private void pass(Scriptable scope, boolean[] populateAggrValue, int[] validAggregationArray) throws DataException {
        do {
            int startingGroupLevel = this.odiResult.getStartingGroupLevel();
            int endingGroupLevel = this.odiResult.getEndingGroupLevel();
            for (int i = 0; i < validAggregationArray.length; ++i) {
                int index = validAggregationArray[i];
                if (this.invalidAggrSet != null && this.invalidAggrSet.contains(new Integer(index))) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                    continue;
                }
                if (this.onRow(index, startingGroupLevel, endingGroupLevel, scope, populateAggrValue[index])) continue;
                this.addInvalidAggrMsg(index, endingGroupLevel);
                if (this.invalidAggrSet == null) {
                    this.invalidAggrSet = new HashSet();
                }
                this.invalidAggrSet.add(new Integer(index));
            }
        } while (this.odiResult.next());
    }

    private void addInvalidAggrMsg(int index, int endingGroupLevel) {
        if (!$assertionsDisabled && this.invalidAggrMsg == null) {
            throw new AssertionError();
        }
        if (this.aggrTable.getAggrInfo((int)index).aggregation.getType() == 1 || endingGroupLevel <= this.aggrTable.getAggrInfo((int)index).groupLevel) {
            this.aggrValues[index].add(this.invalidAggrMsg.get(new Integer(index)));
        }
    }

    private void prepareNextIteration(List validAggregations, boolean[] populateAggrValue, int count) {
        validAggregations.clear();
        for (int i = 0; i < this.aggrTable.getCount(); ++i) {
            int passesNumber;
            this.accumulatorManagers[i].restart();
            IAggregation temp = this.aggrTable.getAggrInfo((int)i).aggregation;
            populateAggrValue[i] = false;
            if (!(temp instanceof Aggregation) || count > (passesNumber = ((Aggregation)temp).getNumberOfPasses())) continue;
            validAggregations.add(new Integer(i));
            if (count != passesNumber) continue;
            populateAggrValue[i] = true;
        }
    }

    Object getAggregateValue(int aggrIndex) throws DataException {
        logger.entering(AggregateCalculator.class.getName(), "getAggregateValue", new Integer(aggrIndex));
        if (!($assertionsDisabled || aggrIndex >= 0 && aggrIndex < this.aggrCount)) {
            throw new AssertionError();
        }
        AggregateTable.AggrExprInfo aggrInfo = this.aggrTable.getAggrInfo(aggrIndex);
        if (!this.hasOdiResultDataRows) {
            if (aggrInfo.aggregation.getName().equalsIgnoreCase("COUNT")) {
                return new Integer(0);
            }
            return null;
        }
        int groupIndex = aggrInfo.aggregation.getType() == 0 ? (aggrInfo.groupLevel == 0 ? 0 : this.odiResult.getCurrentGroupIndex(aggrInfo.groupLevel)) : this.odiResult.getCurrentResultIndex();
        Object value = this.aggrValues[aggrIndex].get(groupIndex);
        logger.exiting(AggregateCalculator.class.getName(), "getAggregateValue", value);
        return value;
    }

    public Scriptable getJSAggrValueObject() {
        return new JSAggrValueObject();
    }

    private boolean onRow(int aggrIndex, int startingGroupLevel, int endingGroupLevel, Scriptable scope, boolean populateValue) throws DataException {
        boolean isRunning;
        AggregateTable.AggrExprInfo aggrInfo = this.aggrTable.getAggrInfo(aggrIndex);
        Accumulator acc = null;
        boolean newGroup = false;
        if (startingGroupLevel <= aggrInfo.groupLevel) {
            newGroup = true;
            acc = this.accumulatorManagers[aggrIndex].next();
            acc.start();
        } else {
            acc = this.accumulatorManagers[aggrIndex].getCurrentAccumulator();
        }
        boolean accepted = true;
        if (aggrInfo.filter != null) {
            try {
                Object filterResult = ExprEvaluateUtil.evaluateCompiledExpression(aggrInfo.filter, this.odiResult, scope);
                accepted = filterResult == null ? true : DataTypeUtil.toBoolean((Object)filterResult);
            }
            catch (BirtException e) {
                logger.logp(Level.FINE, DataEngineImpl.class.getName(), "onRow", "An error is thrown by DataTypeUtil.", e);
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(new Integer(aggrIndex), e);
                return false;
            }
        }
        if (accepted) {
            boolean[] argDefs = aggrInfo.aggregation.getParameterDefn();
            if (!$assertionsDisabled && argDefs.length != this.aggrArgs[aggrIndex].length) {
                throw new AssertionError();
            }
            try {
                for (int i = 0; i < argDefs.length; ++i) {
                    if (!argDefs[i] && !newGroup) continue;
                    CompiledExpression argExpr = aggrInfo.args[i];
                    this.aggrArgs[aggrIndex][i] = ExprEvaluateUtil.evaluateCompiledExpression(argExpr, this.odiResult, scope);
                }
                acc.onRow(this.aggrArgs[aggrIndex]);
            }
            catch (DataException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(new Integer(aggrIndex), e);
                return false;
            }
        }
        boolean bl = isRunning = aggrInfo.aggregation.getType() == 1;
        if (isRunning && populateValue) {
            Object value = acc.getValue();
            this.aggrValues[aggrIndex].add(value);
        }
        if (endingGroupLevel <= aggrInfo.groupLevel) {
            acc.finish();
            if (!isRunning && populateValue) {
                Object value = acc.getValue();
                this.aggrValues[aggrIndex].add(value);
            }
        }
        return true;
    }

    public void populateValue(JSAggrValueObject aggrValue) {
        if (aggrValue == null) {
            return;
        }
        for (int i = 0; i < this.aggrCount; ++i) {
            Object value = aggrValue.get(i, (Scriptable)aggrValue);
            if (value == null) continue;
            this.aggrValues[i].add(value);
        }
    }

    static {
        $assertionsDisabled = !AggregateCalculator.class.desiredAssertionStatus();
        logger = Logger.getLogger(AggregateCalculator.class.getName());
    }

    class AccumulatorManager {
        private IAggregation aggregation;
        int cursor;
        List cachedAcc;

        AccumulatorManager(IAggregation aggregation) {
            this.aggregation = aggregation;
            this.cursor = -1;
            this.cachedAcc = new ArrayList();
        }

        Accumulator getCurrentAccumulator() {
            if (this.cachedAcc.size() == 0) {
                this.cachedAcc.add(this.aggregation.newAccumulator());
            }
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        Accumulator next() {
            ++this.cursor;
            if (this.cachedAcc.size() > this.cursor) {
                return (Accumulator)this.cachedAcc.get(this.cursor);
            }
            this.cachedAcc.add(this.aggregation.newAccumulator());
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        void restart() {
            this.cursor = -1;
        }
    }

    public class JSAggrValueObject
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;

        public Object get(int index, Scriptable start) {
            if (index < 0 || index >= AggregateCalculator.this.aggrCount) {
                return null;
            }
            try {
                return AggregateCalculator.this.getAggregateValue(index);
            }
            catch (DataException e) {
                throw Context.reportRuntimeError((String)e.getLocalizedMessage());
            }
        }

        public String getClassName() {
            return "_RESERVED_AGGR_VALUE";
        }

        public boolean has(int index, Scriptable start) {
            return index > 0 && index < AggregateCalculator.this.aggrCount;
        }
    }
}

