/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class AggregateTable {
    private BaseQuery baseQuery;
    private List aggrExprInfoList = new ArrayList();
    protected static Logger logger;
    private int runStates;
    private static int PREPARED_QUERY;
    private static int BASE_QUERY;
    private int groupCount;
    private List groupDefns;
    private Scriptable scope;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AggregateTable(Scriptable scope, List groupDefns) {
        logger.entering(AggregateTable.class.getName(), "AggregateTable");
        logger.exiting(AggregateTable.class.getName(), "AggregateTable");
        this.groupDefns = groupDefns;
        this.groupCount = groupDefns.size();
        this.scope = scope;
        this.runStates = PREPARED_QUERY;
    }

    private int getGroupIndexFromPreparedQuery(String groupText) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.groupDefns == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.groupDefns.size(); ++i) {
            IGroupDefinition group = (IGroupDefinition)this.groupDefns.get(i);
            if (!groupText.equals(group.getName()) && !groupText.equals(group.getKeyColumn()) && !groupText.equals(group.getKeyExpression())) continue;
            return i + 1;
        }
        return -1;
    }

    public AggregateTable(BaseQuery query) {
        logger.entering(AggregateTable.class.getName(), "AggregateTable");
        this.baseQuery = query;
        logger.exiting(AggregateTable.class.getName(), "AggregateTable");
        this.runStates = BASE_QUERY;
    }

    public AggregateTable() {
    }

    public AggregateRegistry getAggrRegistry(int groupLevel, boolean afterGroup, boolean isDetailedRow, Context cx) {
        return new AggrRegistry(groupLevel, afterGroup, isDetailedRow, cx);
    }

    AggrExprInfo getAggrInfo(int i) {
        return (AggrExprInfo)this.aggrExprInfoList.get(i);
    }

    int getCount() {
        return this.aggrExprInfoList.size();
    }

    private int getGroupIndex(String groupText) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.baseQuery == null) {
            throw new AssertionError();
        }
        IQuery.GroupSpec[] groups = this.baseQuery.getGrouping();
        for (int i = 0; i < groups.length; ++i) {
            IQuery.GroupSpec group = groups[i];
            if (!groupText.equals(group.getName()) && !groupText.equals(group.getKeyColumn())) continue;
            return i + 1;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !AggregateTable.class.desiredAssertionStatus();
        logger = Logger.getLogger(AggregateTable.class.getName());
        PREPARED_QUERY = 1;
        BASE_QUERY = 2;
    }

    class AggrExprInfo {
        IAggregation aggregation;
        int groupLevel = -1;
        boolean afterGroup = false;
        CompiledExpression filter;
        CompiledExpression[] args;

        AggrExprInfo() {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof AggrExprInfo)) {
                return false;
            }
            AggrExprInfo rhs = (AggrExprInfo)other;
            if (this.aggregation != rhs.aggregation || this.groupLevel != rhs.groupLevel || this.args.length != rhs.args.length || this.afterGroup != rhs.afterGroup) {
                return false;
            }
            if (this.filter == null ? rhs.filter != null : !this.filter.equals(rhs.filter)) {
                return false;
            }
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i].equals(rhs.args[i])) continue;
                return false;
            }
            return true;
        }
    }

    class AggrRegistry
    implements AggregateRegistry {
        int groupLevel;
        boolean afterGroup;
        boolean isDetailedRow;
        Context cx;
        static final /* synthetic */ boolean $assertionsDisabled;

        AggrRegistry(int groupLevel, boolean afterGroup, boolean isDetailedRow, Context cx) {
            this.groupLevel = groupLevel;
            this.afterGroup = afterGroup;
            this.isDetailedRow = isDetailedRow;
            this.cx = cx;
        }

        public int register(AggregateExpression expr) throws DataException {
            return this.registerExpression(expr, this.groupLevel, this.afterGroup, this.isDetailedRow, this.cx);
        }

        private int registerExpression(AggregateExpression expr, int groupLevel, boolean afterGroup, boolean isDetailedRow, Context cx) throws DataException {
            int id;
            logger.entering((class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable == null ? (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable = AggregateTable.class$("org.eclipse.birt.data.engine.impl.aggregation.AggregateTable")) : class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable).getName(), "registerExpression");
            AggrExprInfo info = this.newAggrExprInfo(expr, groupLevel, afterGroup, isDetailedRow, cx);
            for (id = 0; id < AggregateTable.this.aggrExprInfoList.size() && !info.equals(AggregateTable.this.aggrExprInfoList.get(id)); ++id) {
            }
            if (id == AggregateTable.this.aggrExprInfoList.size()) {
                AggregateTable.this.aggrExprInfoList.add(info);
            }
            expr.setRegId(id);
            logger.exiting((class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable == null ? (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable = AggregateTable.class$("org.eclipse.birt.data.engine.impl.aggregation.AggregateTable")) : class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable).getName(), "registerExpression");
            return id;
        }

        private AggrExprInfo newAggrExprInfo(AggregateExpression expr, int currentGroupLevel, boolean afterGroup, boolean isDetailedRow, Context cx) throws DataException {
            int nArgs;
            int nFixedArgs;
            List exprArgs;
            AggrExprInfo aggr;
            block14: {
                block15: {
                    aggr = new AggrExprInfo();
                    if (!$assertionsDisabled && expr == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && currentGroupLevel < 0) {
                        throw new AssertionError();
                    }
                    aggr.aggregation = expr.getAggregation();
                    aggr.afterGroup = afterGroup;
                    exprArgs = expr.getArguments();
                    nFixedArgs = aggr.aggregation.getParameterDefn().length;
                    nArgs = exprArgs.size();
                    if (nArgs < nFixedArgs || nArgs > nFixedArgs + 2) {
                        DataException e = new DataException("data.engine.WrongNumAggrArgs", aggr.aggregation.getName());
                        logger.logp(Level.FINE, (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable == null ? (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable = AggregateTable.class$("org.eclipse.birt.data.engine.impl.aggregation.AggregateTable")) : class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable).getName(), "newAggrExprInfo", "Wrong number of arguments to aggregate function", (Throwable)((Object)e));
                        throw e;
                    }
                    aggr.groupLevel = currentGroupLevel;
                    if (nArgs != nFixedArgs + 2) break block14;
                    CompiledExpression groupExpr = (CompiledExpression)exprArgs.get(nArgs - 1);
                    if (!(groupExpr instanceof ConstantExpression)) {
                        DataException e = new DataException("data.engine.InvalidAggrGroupExpression", aggr.aggregation.getName());
                        logger.logp(Level.FINE, (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable == null ? (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable = AggregateTable.class$("org.eclipse.birt.data.engine.impl.aggregation.AggregateTable")) : class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable).getName(), "newAggrExprInfo", "Invalid grouping expression for aggregate function", (Throwable)((Object)e));
                        throw e;
                    }
                    Object groupLevelObj = groupExpr.evaluate(cx, (Scriptable)(AggregateTable.this.runStates == BASE_QUERY ? cx.initStandardObjects() : AggregateTable.this.scope));
                    if (groupLevelObj != null) {
                        if (groupLevelObj instanceof String) {
                            int innerMostGroup = 0;
                            innerMostGroup = AggregateTable.this.runStates == PREPARED_QUERY ? AggregateTable.this.groupCount : (AggregateTable.this.baseQuery.getGrouping() != null ? AggregateTable.this.baseQuery.getGrouping().length : 0);
                            int groupLevel = AggregationConstantsUtil.getGroupLevel((String)groupLevelObj, currentGroupLevel, innerMostGroup, isDetailedRow);
                            aggr.groupLevel = groupLevel != -1 ? groupLevel : (AggregateTable.this.runStates == BASE_QUERY ? AggregateTable.this.getGroupIndex(groupLevelObj.toString()) : AggregateTable.this.getGroupIndexFromPreparedQuery((String)groupLevelObj));
                        } else if (groupLevelObj instanceof Number) {
                            int offset = ((Number)groupLevelObj).intValue();
                            aggr.groupLevel = offset < 0 ? currentGroupLevel + offset : offset;
                        }
                    }
                    if (aggr.groupLevel < 0) break block15;
                    if (aggr.groupLevel <= (AggregateTable.this.runStates == BASE_QUERY ? (AggregateTable.this.baseQuery.getGrouping() == null ? 0 : AggregateTable.this.baseQuery.getGrouping().length) : AggregateTable.this.groupCount)) break block14;
                }
                DataException e = new DataException("data.engine.InvalidGroupLevel", aggr.aggregation.getName());
                logger.logp(Level.FINE, (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable == null ? (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable = AggregateTable.class$("org.eclipse.birt.data.engine.impl.aggregation.AggregateTable")) : class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable).getName(), "newAggrExprInfo", "Invalid grouping level for aggregate function", (Throwable)((Object)e));
                throw e;
            }
            if (nArgs > nFixedArgs) {
                aggr.filter = (CompiledExpression)exprArgs.get(nFixedArgs);
                if (aggr.filter instanceof ConstantExpression && ((ConstantExpression)aggr.filter).getValue() == null) {
                    aggr.filter = null;
                }
            }
            aggr.args = new CompiledExpression[nFixedArgs];
            if (nFixedArgs > 0) {
                exprArgs.subList(0, nFixedArgs).toArray(aggr.args);
            }
            return aggr;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable == null ? (class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable = AggregateTable.class$("org.eclipse.birt.data.engine.impl.aggregation.AggregateTable")) : class$org$eclipse$birt$data$engine$impl$aggregation$AggregateTable).desiredAssertionStatus();
        }
    }
}

