/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDSave;
import org.eclipse.birt.data.engine.impl.document.RDSave2;

public final class RDUtil {
    public static IRDSave newSave(DataEngineContext context, IBaseQueryDefinition queryDefn, int rowCount, QueryResultInfo queryResultInfo) throws DataException {
        QueryResultInfo newQueryResultInfo = RDUtil.getRealQueryResultInfo(queryResultInfo);
        if (newQueryResultInfo.getRootQueryResultID() == null) {
            return new RDSave(context, queryDefn, rowCount, newQueryResultInfo);
        }
        return new RDSave2(context, queryDefn, rowCount, newQueryResultInfo);
    }

    private static QueryResultInfo getRealQueryResultInfo(QueryResultInfo queryResultInfo) {
        String rootQueryResultID = null;
        String selfQueryResultID = null;
        selfQueryResultID = QueryResultIDUtil.get2PartID(queryResultInfo.getSelfQueryResultID());
        if (selfQueryResultID == null) {
            selfQueryResultID = queryResultInfo.getSelfQueryResultID();
        } else {
            rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultInfo.getSelfQueryResultID());
        }
        return new QueryResultInfo(rootQueryResultID, null, selfQueryResultID, queryResultInfo.getSubQueryName(), queryResultInfo.getIndex());
    }

    public static RDLoad newLoad(DataEngineContext context, QueryResultInfo queryResultInfo) throws DataException {
        return new RDLoad(context, queryResultInfo);
    }
}

