/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;
import org.mozilla.javascript.Scriptable;

class ResultIterator
implements IResultIterator {
    private DataEngineContext context;
    private String queryResultID;
    private String subQueryName;
    private int subQueryIndex;
    private IQueryResults queryResults;
    private int currParentIndex;
    private IExprResultSet exprResultSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResultIterator(DataEngineContext context, IQueryResults queryResults, String queryResultID) throws DataException {
        this(context, queryResults, queryResultID, null, -1);
    }

    ResultIterator(DataEngineContext context, IQueryResults queryResults, String queryResultID, String subQueryName, int currParentIndex) throws DataException {
        if (!($assertionsDisabled || queryResultID != null && context != null && queryResults != null)) {
            throw new AssertionError();
        }
        this.context = context;
        this.queryResults = queryResults;
        this.queryResultID = queryResultID;
        this.subQueryName = subQueryName;
        this.currParentIndex = currParentIndex;
        this.prepare();
    }

    private void prepare() throws DataException {
        String rootID = QueryResultIDUtil.get1PartID(this.queryResultID);
        String selfID = QueryResultIDUtil.get2PartID(this.queryResultID);
        if (selfID == null) {
            selfID = this.queryResultID;
        }
        RDLoad valueLoader = RDUtil.newLoad(this.context, new QueryResultInfo(rootID, null, selfID, this.subQueryName, this.currParentIndex));
        if (this.subQueryName != null) {
            this.subQueryIndex = valueLoader.getSubQueryIndex(this.currParentIndex);
        }
        this.exprResultSet = valueLoader.loadExprResultSet();
    }

    public IQueryResults getQueryResults() {
        return this.queryResults;
    }

    public Scriptable getScope() {
        return null;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return this.queryResults.getResultMetaData();
    }

    public boolean next() throws DataException {
        return this.exprResultSet.next();
    }

    public Object getValue(String name) throws BirtException {
        return this.exprResultSet.getValue(name);
    }

    public Boolean getBoolean(String name) throws BirtException {
        return DataTypeUtil.toBoolean((Object)this.getValue(name));
    }

    public Integer getInteger(String name) throws BirtException {
        return DataTypeUtil.toInteger((Object)this.getValue(name));
    }

    public Double getDouble(String name) throws BirtException {
        return DataTypeUtil.toDouble((Object)this.getValue(name));
    }

    public String getString(String name) throws BirtException {
        return DataTypeUtil.toString((Object)this.getValue(name));
    }

    public BigDecimal getBigDecimal(String name) throws BirtException {
        return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
    }

    public Date getDate(String name) throws BirtException {
        return DataTypeUtil.toDate((Object)this.getValue(name));
    }

    public Blob getBlob(String name) throws BirtException {
        return DataTypeUtil.toBlob((Object)this.getValue(name));
    }

    public byte[] getBytes(String name) throws BirtException {
        return DataTypeUtil.toBytes((Object)this.getValue(name));
    }

    public int getRowId() throws BirtException {
        return this.exprResultSet.getCurrentId();
    }

    public int getRowIndex() throws BirtException {
        return this.exprResultSet.getCurrentIndex();
    }

    public void moveTo(int rowIndex) throws BirtException {
        this.exprResultSet.moveTo(rowIndex);
    }

    public int getStartingGroupLevel() throws BirtException {
        return this.exprResultSet.getStartingGroupLevel();
    }

    public int getEndingGroupLevel() throws BirtException {
        return this.exprResultSet.getEndingGroupLevel();
    }

    public void skipToEnd(int groupLevel) throws BirtException {
        this.exprResultSet.skipToEnd(groupLevel);
    }

    public IResultIterator getSecondaryIterator(String subQueryName, Scriptable scope) throws DataException {
        String parentQueryResultsID = null;
        parentQueryResultsID = this.subQueryName == null ? this.queryResultID : this.queryResultID + "/" + this.subQueryName + "/" + this.subQueryIndex;
        QueryResults queryResults = null;
        try {
            queryResults = new QueryResults(this.context, parentQueryResultsID, this.getResultMetaData(), subQueryName, this.exprResultSet.getCurrentIndex());
        }
        catch (Exception e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Subquery");
        }
        try {
            ResultIterator ri = (ResultIterator)queryResults.getResultIterator();
            ri.setSubQueryName(subQueryName);
            return ri;
        }
        catch (BirtException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Subquery");
        }
    }

    void setSubQueryName(String subQueryName) {
        this.subQueryName = subQueryName;
    }

    public void close() throws BirtException {
        this.exprResultSet.close();
    }

    public boolean findGroup(Object[] groupKeyValues) throws BirtException {
        throw new DataException("data.engine.document.notSupportInPresentation");
    }

    static {
        $assertionsDisabled = !ResultIterator.class.desiredAssertionStatus();
    }
}

