/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.viewing.RowIndexUtil;

class ExprDataReader2
implements IExprDataReader {
    private RAInputStream rowExprsIs;
    private RAInputStream rowLenIs;
    private BufferedInputStream rowBuffExprsDis;
    private BufferedInputStream rowBuffLenDis;
    private BufferedInputStream rowInfoBuffDis;
    private DataInputStream rowExprsDis;
    protected int rowCount;
    private int lastRowIndex;
    private int currRowIndex;
    private int currRowLenReadIndex;
    private RowIndexUtil rowInfoUtil;
    private int nextDestIndex;
    private Map exprValueMap;
    private Map rowIDMap;

    ExprDataReader2(RAInputStream rowExprsIs, RAInputStream rowLenIs) {
        this.rowExprsIs = rowExprsIs;
        this.rowLenIs = rowLenIs;
        this.currRowIndex = -1;
        this.lastRowIndex = -1;
        this.currRowLenReadIndex = -1;
        this.rowIDMap = new HashMap();
    }

    ExprDataReader2(RAInputStream rowExprsIs, RAInputStream rowLenIs, RAInputStream rowInfoIs) throws DataException {
        this(rowExprsIs, rowLenIs);
        this.rowInfoBuffDis = new BufferedInputStream((InputStream)rowInfoIs);
        this.rowInfoUtil = new RowIndexUtil(this.rowInfoBuffDis);
        try {
            this.rowCount = (int)(rowInfoIs.length() / 4L);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    public int getCount() {
        return this.rowCount;
    }

    public int getRowId() {
        int destIndex = (Integer)this.rowIDMap.get(new Integer(this.currRowIndex));
        return destIndex;
    }

    public int getRowIndex() {
        if (this.currRowIndex >= this.rowCount) {
            return this.rowCount;
        }
        return this.currRowIndex;
    }

    public boolean next() {
        boolean hasNext;
        ++this.currRowIndex;
        boolean bl = hasNext = this.currRowIndex < this.rowCount;
        if (hasNext) {
            this.nextDestIndex = this.getNextDestIndex(this.currRowIndex);
            this.rowIDMap.put(new Integer(this.currRowIndex), new Integer(this.nextDestIndex));
        }
        return hasNext;
    }

    protected int getNextDestIndex(int currIndex) {
        return this.rowInfoUtil.read();
    }

    public Map getRowValue() throws DataException {
        if (this.lastRowIndex == this.currRowIndex) {
            return this.exprValueMap;
        }
        this.lastRowIndex = this.currRowIndex;
        try {
            this.skipTo(this.nextDestIndex);
            this.exprValueMap = this.getValueMap();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        return this.exprValueMap;
    }

    private void skipTo(int absoluteIndex) throws IOException, DataException {
        if (this.currRowLenReadIndex == absoluteIndex) {
            return;
        }
        this.currRowLenReadIndex = absoluteIndex + 1;
        this.rowLenIs.seek((long)(absoluteIndex * 4));
        this.rowBuffLenDis = new BufferedInputStream((InputStream)this.rowLenIs);
        this.rowExprsIs.seek((long)(IOUtil.readInt((InputStream)this.rowBuffLenDis) + 4));
        this.rowBuffExprsDis = new BufferedInputStream((InputStream)this.rowExprsIs);
        this.rowExprsDis = new DataInputStream(this.rowBuffExprsDis);
    }

    private Map getValueMap() throws IOException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int exprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
        for (int i = 0; i < exprCount; ++i) {
            String exprID = IOUtil.readString((DataInputStream)this.rowExprsDis);
            Object exprValue = IOUtil.readObject((DataInputStream)this.rowExprsDis);
            valueMap.put(exprID, exprValue);
        }
        return valueMap;
    }

    public void close() {
        try {
            if (this.rowExprsDis != null) {
                this.rowExprsDis.close();
                this.rowBuffExprsDis.close();
            }
            if (this.rowBuffLenDis != null) {
                this.rowBuffLenDis.close();
            }
            if (this.rowInfoBuffDis != null) {
                this.rowInfoBuffDis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

