/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupUtil;
import org.eclipse.birt.data.engine.impl.ColumnInfo;
import org.eclipse.birt.data.engine.impl.QueryExecutorUtil;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.mozilla.javascript.Context;

public class ViewingUtil {
    public static GroupBy[] initGroupSpec(IQuery.GroupSpec[] groupSpecs, IResultClass rsMeta) throws DataException {
        GroupBy[] groupDefs;
        if (groupSpecs != null) {
            groupDefs = new GroupBy[groupSpecs.length];
            for (int i = 0; i < groupSpecs.length; ++i) {
                String keyColumn;
                int keyIndex = groupSpecs[i].getKeyIndex();
                if (GroupUtil.isRowIdColumn(keyIndex, keyColumn = groupSpecs[i].getKeyColumn())) {
                    groupDefs[i] = GroupBy.newInstanceForRowID(groupSpecs[i]);
                    continue;
                }
                if (keyColumn != null) {
                    keyIndex = rsMeta.getFieldIndex(keyColumn);
                }
                if (keyIndex < 1 || keyIndex > rsMeta.getFieldCount()) {
                    throw new DataException("data.engine.InvalidGroupKeyName", keyColumn);
                }
                groupDefs[i] = GroupBy.newInstance(groupSpecs[i], keyIndex, null, rsMeta.getFieldValueClass(keyIndex));
            }
        } else {
            groupDefs = new GroupBy[]{};
        }
        return groupDefs;
    }

    public static List getSortList(List sorts) {
        Context cx = Context.enter();
        IQuery.SortSpec[] sortSpecs = null;
        if (sorts != null && sorts.size() > 0) {
            sortSpecs = new IQuery.SortSpec[sorts.size()];
            Iterator it = sorts.iterator();
            int i = 0;
            while (it.hasNext()) {
                IQuery.SortSpec dest;
                ISortDefinition src = (ISortDefinition)it.next();
                int sortIndex = -1;
                String sortKey = src.getColumn();
                if (sortKey == null || sortKey.length() == 0) {
                    ColumnInfo columnInfo = QueryExecutorUtil.getColInfoFromJSExpr(cx, src.getExpression().getText());
                    sortIndex = columnInfo.getColumnIndex();
                    sortKey = columnInfo.getColumnName();
                }
                sortSpecs[i] = dest = new IQuery.SortSpec(sortIndex, sortKey, src.getSortDirection() == 0);
                ++i;
            }
        }
        Context.exit();
        if (sortSpecs == null) {
            return null;
        }
        return Arrays.asList(sortSpecs);
    }

    public static SortSpec getSortSpec(IQuery.GroupSpec[] groupDefns, IQuery.SortSpec[] sortDefns, IResultClass rsMeta) throws DataException {
        int i;
        int groupCount = 0;
        int sortCount = 0;
        if (groupDefns != null) {
            for (int i2 = 0; i2 < groupDefns.length; ++i2) {
                if (groupDefns[i2].getKeyIndex() < 0) continue;
                ++groupCount;
            }
        }
        if (sortDefns != null) {
            sortCount = sortDefns.length;
        }
        int[] sortKeyIndexes = new int[groupCount + sortCount];
        String[] sortKeyNames = new String[groupCount + sortCount];
        boolean[] sortAscending = new boolean[groupCount + sortCount];
        for (i = 0; i < groupCount; ++i) {
            int index = groupDefns[i].getKeyIndex();
            if (index < 0) continue;
            sortKeyIndexes[i] = groupDefns[i].getKeyIndex();
            sortKeyNames[i] = groupDefns[i].getKeyColumn();
            sortAscending[i] = groupDefns[i].getSortDirection() != 1;
        }
        for (i = 0; i < sortCount; ++i) {
            int keyIndex = sortDefns[i].getIndex();
            String keyName = sortDefns[i].getField();
            if (keyName != null) {
                keyIndex = rsMeta.getFieldIndex(keyName);
            }
            if (keyIndex < 1 || keyIndex > rsMeta.getFieldCount()) {
                throw new DataException("data.engine.InvalidSortKeyColumn", keyName);
            }
            sortKeyIndexes[groupCount + i] = keyIndex;
            sortKeyNames[groupCount + i] = sortDefns[i].getField();
            sortAscending[groupCount + i] = sortDefns[i].isAscendingOrder();
        }
        return new SortSpec(sortKeyIndexes, sortKeyNames, sortAscending);
    }
}

