/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ParameterHint {
    private String m_name;
    private int m_position;
    private Class m_dataType;
    private boolean m_isInputOptional;
    private String m_defaultInputValue;
    private boolean m_isInputMode;
    private boolean m_isOutputMode;
    private boolean m_isNullable;
    private static String sm_className = ParameterHint.class.getName();
    private static String sm_loggerName = ConnectionManager.sm_packageName;
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    public ParameterHint(String parameterName, boolean isInputMode, boolean isOutputMode) {
        String methodName = "ParameterHint";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "ParameterHint", new Object[]{parameterName, new Boolean(isInputMode), new Boolean(isOutputMode)});
        }
        if (parameterName == null || parameterName.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ParameterNameCannotBeEmptyOrNull");
            sm_logger.logp(Level.SEVERE, sm_className, "ParameterHint", "The given parameter is null or empty.");
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_name = parameterName;
        this.m_isInputMode = isInputMode;
        this.m_isOutputMode = isOutputMode;
        this.m_isInputOptional = true;
        this.m_isNullable = true;
        sm_logger.exiting(sm_className, "ParameterHint", this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setPosition(int position) {
        String methodName = "setPosition";
        if (position < 1) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ParameterPositionIsOneBased");
            sm_logger.logp(Level.SEVERE, sm_className, "setPosition", "Invalid parameter position {0} ", new Integer(position));
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setDataType(Class dataType) {
        String methodName = "setDataType";
        boolean isValid = false;
        if (dataType == null || dataType == Integer.class || dataType == Double.class || dataType == String.class || dataType == BigDecimal.class || dataType == Date.class || dataType == Time.class || dataType == Timestamp.class || dataType == IBlob.class || dataType == IClob.class) {
            isValid = true;
        }
        if (isValid && this.isInputMode() && dataType != null && (dataType == IBlob.class || dataType == IClob.class)) {
            isValid = false;
        }
        if (!isValid) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.UnsupportedParameterValueType", new Object[]{dataType});
            sm_logger.logp(Level.SEVERE, sm_className, "setDataType", "Invalid parameter data type {0}.", dataType);
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_dataType = dataType;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public void setIsInputOptional(boolean isInputOptional) {
        if (this.m_isInputMode) {
            this.m_isInputOptional = isInputOptional;
        }
    }

    public boolean isInputOptional() {
        return this.m_isInputMode ? this.m_isInputOptional : true;
    }

    public void setIsNullable(boolean isNullable) {
        this.m_isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.m_isNullable;
    }

    public void setDefaultInputValue(String defaultInputValue) {
        if (this.m_isInputMode) {
            this.m_defaultInputValue = defaultInputValue;
        }
    }

    public String getDefaultInputValue() {
        return this.m_isInputMode ? this.m_defaultInputValue : null;
    }

    public boolean isInputMode() {
        return this.m_isInputMode;
    }

    public boolean isOutputMode() {
        return this.m_isOutputMode;
    }

    void updateHint(ParameterHint hint) {
        String methodName = "updateHint";
        sm_logger.entering(sm_className, methodName, hint);
        this.m_name = hint.m_name;
        if (hint.m_position != 0) {
            this.m_position = hint.m_position;
        }
        if (hint.m_dataType != null) {
            this.m_dataType = hint.m_dataType;
        }
        this.m_isInputOptional = hint.m_isInputOptional;
        this.m_defaultInputValue = hint.m_defaultInputValue;
        this.m_isInputMode = hint.m_isInputMode;
        this.m_isOutputMode = hint.m_isOutputMode;
        this.m_isNullable = hint.m_isNullable;
        sm_logger.exiting(sm_className, methodName, this);
    }
}

