/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import org.eclipse.birt.report.data.oda.xml.i18n.Messages;
import org.eclipse.birt.report.data.oda.xml.impl.DataTypes;
import org.eclipse.birt.report.data.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.connectivity.oda.OdaException;

class ColumnInfo {
    private int index;
    private String name;
    private String type;
    private String path;
    private String originalPath;
    private int backRefNumber;
    private int forwardRefNumber;

    public ColumnInfo(int index, String name, String type, String rootPath, String relativePath, String originalPath) throws OdaException {
        this.index = index;
        this.name = name;
        this.type = type;
        if (!DataTypes.isValidType(type)) {
            throw new OdaException(Messages.getString("RelationInformation.InvalidDataTypeName"));
        }
        this.path = this.fixTrailingAttr(SaxParserUtil.processParentAxis(this.combineColumnPath(rootPath, relativePath)));
        this.originalPath = originalPath;
        this.initBackAndForwardRefNumbers();
    }

    private String combineColumnPath(String rootPath, String declaredPath) {
        if (declaredPath == null || declaredPath.length() == 0) {
            return rootPath;
        }
        if (declaredPath.startsWith("[") || declaredPath.startsWith("/")) {
            return rootPath + declaredPath;
        }
        return rootPath + "/" + declaredPath;
    }

    private void initBackAndForwardRefNumbers() {
        this.generateBackRefNumber(this.originalPath);
        this.generateForwardRefNumber(this.originalPath);
    }

    private void generateBackRefNumber(String originalPath) {
        if (this.originalPath.matches(".*\\Q..\\E.*")) {
            int i;
            String[] originalPathFrags = originalPath.split("/");
            int lastTwoDotAbbrevationPosition = 0;
            int numberOfConcretePathFragsBefore2DotAbb = 0;
            for (i = 0; i < originalPathFrags.length; ++i) {
                if (!originalPathFrags[i].equals("..")) continue;
                lastTwoDotAbbrevationPosition = i;
            }
            for (i = 0; i < lastTwoDotAbbrevationPosition; ++i) {
                if (originalPathFrags[i].equals("..")) continue;
                ++numberOfConcretePathFragsBefore2DotAbb;
            }
            int numberOf2DotAbb = lastTwoDotAbbrevationPosition - numberOfConcretePathFragsBefore2DotAbb + 1;
            this.backRefNumber = numberOf2DotAbb - numberOfConcretePathFragsBefore2DotAbb;
            if (this.backRefNumber < 0) {
                this.backRefNumber = 0;
                return;
            }
        } else {
            this.backRefNumber = 0;
        }
    }

    private void generateForwardRefNumber(String originalPath) {
        String path = originalPath;
        String[] split = path.split("/");
        int elementCount = 0;
        int _2dotAbbCount = 0;
        for (int j = 0; j < split.length; ++j) {
            if (split[j].equals("..")) {
                ++_2dotAbbCount;
                continue;
            }
            if (split[j].trim().length() == 0 || split[j].trim().matches("\\Q[@\\E.*") || split[j].trim().matches("\\Q@\\E.*")) continue;
            ++elementCount;
        }
        this.forwardRefNumber = elementCount + this.backRefNumber - _2dotAbbCount;
    }

    private String fixTrailingAttr(String path) {
        if (path.matches(".*//@.*")) {
            path = path.replaceFirst("//@", "//[@") + "]";
        } else if (path.matches(".*/@.*")) {
            path = path.replaceFirst("/@", "[@") + "]";
        }
        return path;
    }

    public String getColumnName() {
        return this.name;
    }

    public String getColumnType() {
        return this.type;
    }

    public String getColumnPath() {
        return this.path;
    }

    public int getColumnIndex() {
        return this.index;
    }

    public String getColumnOriginalPath() {
        return this.originalPath;
    }

    public int getBackRefNumber() {
        return this.backRefNumber;
    }

    public int getForwardRefNumber() {
        return this.forwardRefNumber;
    }
}

