/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.data.oda.xml.i18n.Messages;
import org.eclipse.birt.report.data.oda.xml.util.ColumnInfo;
import org.eclipse.birt.report.data.oda.xml.util.TableInfo;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class RelationInformation {
    public static final String CONST_TABLE_DELIMITER = "#-#";
    public static final String CONST_TABLE_COLUMN_DELIMITER = "#:#";
    public static final String CONST_COLUMN_METAINFO_DELIMITER = ";";
    public static final String CONST_COLUMN_DELIMITER = ",";
    private HashMap tableInfos = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RelationInformation(String relationString) throws OdaException {
        this.initialize(relationString.trim());
    }

    private void initialize(String relationString) throws OdaException {
        if (relationString == null || relationString.length() == 0) {
            throw new OdaException(Messages.getString("RelationInformation.InputStringCannotBeNull"));
        }
        String[] tables = relationString.split(CONST_TABLE_DELIMITER);
        for (int i = 0; i < tables.length; ++i) {
            String[] temp = tables[i].trim().split(CONST_TABLE_COLUMN_DELIMITER);
            if (!$assertionsDisabled && temp.length != 3) {
                throw new AssertionError();
            }
            TableInfo tableInfo = new TableInfo(temp[0].trim(), temp[1].substring(1, temp[1].length() - 1).trim());
            String[] columns = temp[2].trim().split(CONST_COLUMN_DELIMITER);
            for (int j = 0; j < columns.length; ++j) {
                String trimedColumn = columns[j].trim();
                String[] columnInfos = trimedColumn.substring(1, trimedColumn.length() - 1).split(CONST_COLUMN_METAINFO_DELIMITER);
                String columnXpath = null;
                columnXpath = columnInfos.length == 3 ? columnInfos[2] : "";
                for (int m = 0; m < columnInfos.length; ++m) {
                    columnInfos[m] = columnInfos[m].trim();
                }
                String originalColumnXpath = columnXpath;
                if (columnXpath.matches(".*\\Q[@\\E.*\\Q=\\E.*")) {
                    String value = columnXpath.replaceAll(".*\\Q[@\\E.*\\Q=\\E", "").trim();
                    value = value.substring(1, value.length() - 2);
                    tableInfo.addFilter(columnInfos[0], value);
                    columnXpath = columnXpath.replaceAll("\\Q=\\E.*", "]");
                }
                tableInfo.addColumn(new ColumnInfo(j + 1, columnInfos[0], columnInfos[1], tableInfo.getRootPath(), columnXpath, originalColumnXpath));
            }
            this.tableInfos.put(temp[0].trim(), tableInfo);
        }
    }

    public String getTableColumnPath(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getPath(columnName == null ? "" : columnName.trim());
        }
        return null;
    }

    public String getTableOriginalColumnPath(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalPath(columnName == null ? "" : columnName.trim());
        }
        return null;
    }

    public int getTableNestedColumnBackRefNumber(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getBackRefNumber(columnName == null ? "" : columnName.trim());
        }
        return -1;
    }

    public int getTableColumnForwardRefNumber(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getForwardRefNumber(columnName == null ? "" : columnName.trim());
        }
        return -1;
    }

    public String getTableColumnType(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getType(columnName == null ? "" : columnName.trim());
        }
        return null;
    }

    public String[] getTableColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getColumnNames();
        }
        return new String[0];
    }

    public String[] getTableComplexNestedXMLColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getComplexNestXMLColumnNames();
        }
        return new String[0];
    }

    public String[] getTableSimpleNestedXMLColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getSimpleNestXMLColumnNames();
        }
        return new String[0];
    }

    public String getTableRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getRootPath();
        }
        return null;
    }

    public String getTableOriginalRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalRootPath();
        }
        return null;
    }

    public HashMap getTableFilter(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? "" : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getFilter();
        }
        return null;
    }

    public Iterator getTableNames() {
        return this.tableInfos.keySet().iterator();
    }

    static {
        $assertionsDisabled = !RelationInformation.class.desiredAssertionStatus();
    }
}

