/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

public class SaxParserUtil {
    public static boolean isSamePath(String path, String generatedPath) {
        String[] generatedPaths;
        String[] paths;
        if (path.equals(generatedPath)) {
            return true;
        }
        boolean isAbsolute = true;
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "/");
            isAbsolute = false;
        }
        if ((paths = path.replaceFirst("/", "").split("/")).length > (generatedPaths = generatedPath.replaceFirst("/", "").split("/")).length) {
            return false;
        }
        if (isAbsolute && paths.length != generatedPaths.length) {
            return false;
        }
        for (int i = 0; i < paths.length; ++i) {
            String temp1 = paths[paths.length - i - 1];
            String temp2 = generatedPaths[generatedPaths.length - i - 1];
            if (SaxParserUtil.isXPathFragEqual(temp1, temp2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isXPathFragEqual(String definedPath, String generatedPath) {
        if (definedPath.startsWith("*") || definedPath.startsWith("[@")) {
            String pattern = definedPath.replaceFirst("\\Q*\\E", "");
            return pattern.length() != 0 ? generatedPath.endsWith(pattern) : !generatedPath.matches(".*\\Q[@\\E.*\\Q]\\E.*");
        }
        if (!generatedPath.matches(".*\\Q[\\E\\d+\\Q]\\E.*") || definedPath.matches(".*\\Q[\\E\\d+\\Q]\\E.*")) {
            return generatedPath.equals(definedPath);
        }
        return generatedPath.replaceFirst("\\Q[\\E\\d+\\Q]\\E", "").equals(definedPath);
    }

    public static String processParentAxis(String path) {
        int i;
        String prefix = "";
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "");
            prefix = "//";
        } else if (path.startsWith("/")) {
            path = path.replaceFirst("/", "");
            prefix = "/";
        }
        String[] temp = path.split("/");
        block0: for (i = 0; i < temp.length; ++i) {
            if (!temp[i].equals("..")) continue;
            temp[i] = null;
            for (int j = i - 1; j >= 0; --j) {
                if (temp[j] == null) continue;
                temp[j] = null;
                continue block0;
            }
        }
        path = prefix;
        for (i = 0; i < temp.length; ++i) {
            if (temp[i] == null) continue;
            path = i == 0 ? path + temp[i] : path + (temp[i].startsWith("[") ? "" : "/") + temp[i];
        }
        if (path.startsWith("///")) {
            path = path.replaceFirst("\\Q/\\E", "");
        }
        return path;
    }
}

