/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.birt.report.data.oda.xml.util.XMLDataInputStream;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class XMLDataInputStreamCreator {
    private static final String TEMPFILENAME = "tempXMLData";
    private static HashMap inputStreamCache = new HashMap();
    private URL url = null;

    public static XMLDataInputStreamCreator getCreator(String key) throws OdaException {
        return new XMLDataInputStreamCreator(key);
    }

    public static synchronized XMLDataInputStreamCreator getCreator(InputStream key) throws OdaException {
        if (inputStreamCache.get(key) == null) {
            XMLDataInputStreamCreator creator = new XMLDataInputStreamCreator(key);
            inputStreamCache.put(key, creator);
            return creator;
        }
        return (XMLDataInputStreamCreator)inputStreamCache.get(key);
    }

    private XMLDataInputStreamCreator(InputStream is) throws OdaException {
        this.createTemporaryFile(is);
    }

    private void createTemporaryFile(InputStream is) throws OdaException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int abyte;
            File file = this.createFileWithUniqueName();
            FileOutputStream fos = new FileOutputStream(file);
            while ((abyte = bis.read()) != -1) {
                fos.write(abyte);
            }
            fos.close();
            bis.close();
            this.url = file.toURL();
        }
        catch (IOException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    private File createFileWithUniqueName() throws IOException {
        File file = File.createTempFile(TEMPFILENAME, null);
        file.deleteOnExit();
        return file;
    }

    private XMLDataInputStreamCreator(String xmlFile) throws OdaException {
        URL url = null;
        try {
            File f = new File(xmlFile);
            if (f.exists()) {
                url = f.toURL();
            }
            this.url = url;
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (url == null) {
                url = new URL(xmlFile);
                this.createTemporaryFile(url.openStream());
            }
        }
        catch (MalformedURLException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    public XMLDataInputStream createXMLDataInputStream() throws OdaException {
        return new XMLDataInputStream(this.url);
    }
}

