/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util.ui;

import org.eclipse.birt.report.data.oda.xml.util.ISaxParserConsumer;
import org.eclipse.birt.report.data.oda.xml.util.SaxParser;
import org.eclipse.birt.report.data.oda.xml.util.XMLDataInputStreamCreator;
import org.eclipse.birt.report.data.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.connectivity.oda.OdaException;

final class XMLFileSchemaTreePopulator
implements ISaxParserConsumer {
    private int rowCount = 0;
    private ATreeNode root = new ATreeNode();
    private SaxParser sp;
    private boolean includeAttribute = true;
    private int numberOfElementsAccessiable;
    Thread spThread;
    static final /* synthetic */ boolean $assertionsDisabled;

    XMLFileSchemaTreePopulator(int numberOfElementsAccessiable) {
        this.root.setValue("ROOT");
        this.numberOfElementsAccessiable = numberOfElementsAccessiable == 0 ? Integer.MAX_VALUE : numberOfElementsAccessiable;
    }

    public void manipulateData(String path, String value) {
    }

    public void detectNewRow(String path, boolean start) {
        String treamedPath = path.replaceAll("\\Q[\\E\\d+\\Q]\\E", "").trim();
        this.insertNode(treamedPath);
        if (!this.isAttribute(path) && start) {
            ++this.rowCount;
        }
        if (this.rowCount >= this.numberOfElementsAccessiable) {
            if (!$assertionsDisabled && this.sp == null) {
                throw new AssertionError();
            }
            this.sp.setStart(false);
            this.sp.stopParsing();
        }
    }

    private boolean isAttribute(String path) {
        return path.matches(".*\\Q[@\\E.+\\Q]\\E.*");
    }

    public synchronized void wakeup() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ATreeNode getSchemaTree(String fileName, boolean includeAttribute) {
        this.includeAttribute = includeAttribute;
        try {
            this.sp = new SaxParser(XMLDataInputStreamCreator.getCreator(fileName).createXMLDataInputStream(), this);
            this.spThread = new Thread(this.sp);
            this.spThread.start();
            while (this.sp.isAlive() && !this.sp.isSuspended()) {
                try {
                    XMLFileSchemaTreePopulator xMLFileSchemaTreePopulator = this;
                    synchronized (xMLFileSchemaTreePopulator) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (OdaException e1) {
            e1.printStackTrace();
        }
        return this.root;
    }

    private void insertNode(String treatedPath) {
        boolean isAttribute = this.isAttribute(treatedPath);
        String[] path = treatedPath.replaceFirst("/", "").split("/");
        if (isAttribute) {
            String[] temp = path[path.length - 1].split("\\Q[@\\E");
            if (!$assertionsDisabled && temp.length != 2) {
                throw new AssertionError();
            }
            String[] temp1 = new String[path.length + 1];
            for (int i = 0; i < path.length - 1; ++i) {
                temp1[i] = path[i];
            }
            temp1[temp1.length - 2] = temp[0];
            temp1[temp1.length - 1] = temp[1].replaceAll("\\Q]\\E", "");
            path = temp1;
        }
        ATreeNode parentNode = this.root;
        for (int i = 0; i < path.length; ++i) {
            ATreeNode matchedNode = null;
            for (int j = 0; j < parentNode.getChildren().length; ++j) {
                if (!((ATreeNode)parentNode.getChildren()[j]).getValue().equals(path[i])) continue;
                matchedNode = (ATreeNode)parentNode.getChildren()[j];
                break;
            }
            if (matchedNode != null) {
                parentNode = matchedNode;
                continue;
            }
            matchedNode = new ATreeNode();
            if (i == path.length - 1 && isAttribute) {
                if (isAttribute && !this.includeAttribute) continue;
                matchedNode.setType(2);
            } else {
                matchedNode.setType(1);
            }
            matchedNode.setValue(path[i]);
            matchedNode.setParent(parentNode);
            parentNode = matchedNode;
        }
    }

    static {
        $assertionsDisabled = !XMLFileSchemaTreePopulator.class.desiredAssertionStatus();
    }
}

