/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplexInput;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMessage;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import java.util.Vector;

public abstract class IfxComplex
extends IfxObject {
    protected IfxComplexInput inputStream;
    protected IfxComplexOutput outputStream;
    private short identsize = 0;
    private boolean allocateNewByteArray = true;
    protected static final int IFX_CT_NULL = Integer.MIN_VALUE;
    protected static final short CLROW_HDRSZ = 136;
    protected static final short CLROW_ROWSZ = 414;
    protected static final short OLDCLROW_HDRSZ = 26;
    protected static final short OLDCLROW_ROWSZ = 84;

    IfxComplex() throws SQLException {
    }

    public void clear() {
        super.setExtendedTypeName("");
        super.setExtendedOwner("");
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.allocateNewByteArray = false;
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[2];
        int n4 = 0;
        this.clear();
        this.setIdentSize();
        byte[] byArray4 = new byte[this.identsize];
        n += 4;
        n += 4;
        n += 2;
        System.arraycopy(byArray, n += this.identsize, byArray3, 0, 2);
        int n5 = IfxToJavaType.IfxToJavaSmallInt(byArray3);
        n += 2;
        IfxColumnInfo[] ifxColumnInfoArray = new IfxColumnInfo[n5];
        int n6 = 0;
        while (n6 < n5) {
            ifxColumnInfoArray[n6] = new IfxColumnInfo();
            ++n6;
        }
        int n7 = 0;
        while (n7 < n5) {
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            ifxColumnInfoArray[n7].Levelno = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            n += 2;
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            short s = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            System.arraycopy(byArray, n += 2, byArray4, 0, this.identsize);
            String string = IfxToJavaType.IfxToJavaChar(byArray4);
            ifxColumnInfoArray[n7].ColName = stringUtil.fixLength(string, s, '\u0000');
            n += this.identsize;
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            n3 = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfoArray[n7], n3);
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            ifxColumnInfoArray[n7].ColLength = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            System.arraycopy(byArray, n += 2, byArray2, 0, 4);
            ifxColumnInfoArray[n7].ExtendedId = IfxToJavaType.IfxToJavaInt(byArray2);
            n += 4;
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            s = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            n += 2;
            if (s > 0 && (!IfxTypes.isComplexType(ifxColumnInfoArray[n7].SQLtype) || ifxColumnInfoArray[n7].IsNamedRow)) {
                System.arraycopy(byArray, n, byArray4, 0, this.identsize);
                string = IfxToJavaType.IfxToJavaChar(byArray4);
                ifxColumnInfoArray[n7].ExtendedName = stringUtil.fixLength(string, s, '\u0000');
            }
            System.arraycopy(byArray, n += this.identsize, byArray3, 0, 2);
            s = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            System.arraycopy(byArray, n += 2, byArray4, 0, this.identsize);
            string = IfxToJavaType.IfxToJavaChar(byArray4);
            ifxColumnInfoArray[n7].ExtendedOwner = stringUtil.fixLength(string, s, '\u0000');
            if (ifxColumnInfoArray[n7].ExtendedOwner.equals("informix")) {
                ifxColumnInfoArray[n7].ExtendedOwner = "";
            }
            System.arraycopy(byArray, n += this.identsize, byArray3, 0, 2);
            ifxColumnInfoArray[n7].Alignment = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            System.arraycopy(byArray, n += 2, byArray2, 0, 4);
            ifxColumnInfoArray[n7].SourceType = IfxToJavaType.IfxToJavaInt(byArray2);
            n += 4;
            ++n7;
        }
        System.arraycopy(byArray, n += 4, byArray2, 0, 4);
        n4 = IfxToJavaType.IfxToJavaInt(byArray2);
        System.arraycopy(byArray, n += 4, byArray2, 0, 4);
        n3 = IfxToJavaType.IfxToJavaInt(byArray2);
        n += 4;
        if ((n3 & Integer.MIN_VALUE) != 0) {
            this.nullify();
        } else {
            this.unnullify();
        }
        Vector vector = new Vector();
        this.convertTypeArraytoVector(0, ifxColumnInfoArray, vector, ifxColumnInfoArray[0].Levelno);
        if (!this.isNull()) {
            if (this.allocateNewByteArray) {
                byte[] byArray5 = new byte[n4];
                System.arraycopy(byArray, n, byArray5, 0, n4);
                this.inputStream = new IfxComplexInput(byArray5, 0, n4, vector, false, this.conn);
            } else {
                this.inputStream = new IfxComplexInput(byArray, n, n4, vector, false, this.conn);
                this.allocateNewByteArray = false;
            }
            this.inputStream.setTypeMap(this.typeMap);
        }
    }

    private int convertTypeArraytoVector(int n, IfxColumnInfo[] ifxColumnInfoArray, Vector vector, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = null;
        IfxColumnInfo ifxColumnInfo2 = null;
        while (n < ifxColumnInfoArray.length) {
            if (n2 == ifxColumnInfoArray[n].Levelno) {
                ifxColumnInfo = (IfxColumnInfo)ifxColumnInfoArray[n].clone();
                vector.add(ifxColumnInfo);
                ++n;
                continue;
            }
            if (ifxColumnInfoArray[n].Levelno <= n2) break;
            ifxColumnInfo = (IfxColumnInfo)vector.lastElement();
            Vector<IfxColumnInfo> vector2 = new Vector<IfxColumnInfo>();
            ifxColumnInfo2 = (IfxColumnInfo)ifxColumnInfoArray[n].clone();
            vector2.add(ifxColumnInfo2);
            ifxColumnInfo.child = vector2;
            if (n >= ifxColumnInfoArray.length) continue;
            n = this.convertTypeArraytoVector(n + 1, ifxColumnInfoArray, vector2, ifxColumnInfoArray[n].Levelno);
        }
        return n;
    }

    public void fromIfx(byte[] byArray, IfxColumnInfo ifxColumnInfo, boolean bl) throws SQLException {
        byte[] byArray2 = new byte[2];
        int n = 0;
        int n2 = 0;
        this.clear();
        this.setIdentSize();
        if (bl) {
            this.nullify();
        } else {
            this.unnullify();
        }
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>(1);
        vector.add(ifxColumnInfo);
        n2 = byArray.length;
        if (!this.isNull()) {
            this.inputStream = new IfxComplexInput(byArray, n, n2, vector, true, this.conn);
            this.inputStream.setTypeMap(this.typeMap);
        }
    }

    public byte[] toIfx() throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.isNull() || this.outputStream == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.setIdentSize();
        byte[] byArray = this.outputStream.getSerializedTypeInfo();
        int n = this.outputStream.getTypeCount();
        int n2 = this.identsize == 18 ? 26 + 84 * n : 136 + 414 * n;
        int n3 = n2 + this.outputStream.length() + 12;
        byte[] byArray2 = JavaToIfxType.JavaToIfxInt(n3);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxInt(0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxSmallInt((short)0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        String string = stringUtil.fixLength(null, this.identsize, '\u0000');
        byArray2 = string.getBytes();
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxSmallInt((short)n);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byArray2 = JavaToIfxType.JavaToIfxInt(0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        if (this.outputStream.length() > 0) {
            int n4 = 1;
            byArray2 = JavaToIfxType.JavaToIfxInt(n4);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            byArray2 = this.outputStream.toByteArray();
            byteArrayOutputStream.write(byArray2, 0, this.outputStream.length());
        } else {
            byArray2 = JavaToIfxType.JavaToIfxInt(Integer.MIN_VALUE);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        }
        super.setExtendedTypeName(this.outputStream.getExtendedName());
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] toIfxTuple() throws SQLException {
        return this.toIfx();
    }

    private void setIdentSize() {
        if (this.identsize == 0) {
            this.identsize = this.conn.isLongID() ? (short)128 : (short)18;
        }
    }

    private void dumpTypeArray(IfxColumnInfo[] ifxColumnInfoArray, int n) {
        int n2 = 0;
        while (n2 < ifxColumnInfoArray.length) {
            this.trace.writeTrace(2, "index : ", n2);
            ifxColumnInfoArray[n2].dumpInfo(this.trace, n);
            ++n2;
        }
    }

    static void dumpTypeInfoVector(Vector vector, Trace trace, int n) {
    }

    static String getExtendedName(Vector vector, Trace trace, String string) throws SQLException {
        String string2 = "";
        if (vector == null) {
            throw IfxErrMsg.getLocSQLException(-79716, ": getExtendedName(Vector)", string);
        }
        if (vector.size() == 0) {
            return "";
        }
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(0);
        if (ifxColumnInfo.IsNamedRow) {
            string2 = ifxColumnInfo.ExtendedName;
        } else {
            string2 = IfxComplex.constructExtendedName(vector, string2, trace, string);
            string2.trim();
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    static String constructExtendedName(Vector vector, String string, Trace trace, String string2) throws SQLException {
        int n = 0;
        while (n < vector.size()) {
            if (n > 0) {
                string = string + ", ";
            }
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(n);
            if (ifxColumnInfo.ColName != null) {
                string = string + ifxColumnInfo.ColName;
                string = string + " ";
            }
            if (ifxColumnInfo.SQLtype == 49) {
                ifxColumnInfo.SQLtype = 0;
                ifxColumnInfo.ColLength = 1;
            }
            if (ifxColumnInfo.ExtendedName != "" && ifxColumnInfo.ExtendedName != null) {
                if (ifxColumnInfo.ExtendedOwner != "" && ifxColumnInfo.ExtendedOwner != null) {
                    string = string + "'" + ifxColumnInfo.ExtendedOwner + "'" + ".";
                }
                string = string + ifxColumnInfo.ExtendedName;
            } else {
                String string3 = IfxTypes.IfxTypeToName(ifxColumnInfo.SQLtype);
                if (string3.equals("unknown")) {
                    throw IfxErrMsg.getLocSQLException(-79716, string2);
                }
                string = string + string3;
                int n2 = ifxColumnInfo.SQLtype & 0xFF;
                if (n2 == 0 || n2 == 13 || n2 == 15 || n2 == 16) {
                    string = string + "(" + ifxColumnInfo.ColLength + ")";
                } else if (n2 == 10 || n2 == 14) {
                    string = string + " ";
                    string = string + IfxDateTime.getQualifierName((short)ifxColumnInfo.ColLength, n2);
                }
                string = string + " ";
            }
            if (ifxColumnInfo.child != null && !ifxColumnInfo.IsNamedRow) {
                string = string + "( ";
                string = IfxComplex.constructExtendedName(ifxColumnInfo.child, string, trace, string2);
            }
            if (ifxColumnInfo.Nullable == 0) {
                string = string + " not null";
            }
            if (n + 1 == vector.size()) {
                string = string + ") ";
            }
            ++n;
        }
        return string;
    }

    static void badTypeException(int n, short s, Trace trace, String string) throws SQLException {
        String string2 = null;
        String string3 = null;
        string2 = IfxComplex.getTypeName(s);
        string3 = IfxComplex.getTypeName(n);
        String string4 = IfxMessage.getMessage(-79776, string2, string3, string);
        throw new SQLException(string4);
    }

    private static String getTypeName(int n) {
        String string = "unknown";
        switch (n) {
            case 40: {
                string = "udt var";
                break;
            }
            case 41: {
                string = "udt fixed";
                break;
            }
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                string = "string type";
                break;
            }
            case 11: 
            case 12: {
                string = "text or byte";
                break;
            }
            default: {
                string = IfxTypes.IfxTypeToName(n);
            }
        }
        return string;
    }
}

