/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation.rank;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.aggregation.RunningAccumulator;
import org.eclipse.birt.data.engine.aggregation.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.core.DataException;

public abstract class BaseTopBottomAccumulator
extends RunningAccumulator {
    protected List cachedValues;
    private double N;
    private int passNo = 0;
    private int[] targetValue = new int[0];
    private int currentIndex = -1;
    private Object value = null;
    private static Boolean trueValue;
    private static Boolean falseValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void start() throws DataException {
        super.start();
        ++this.passNo;
        if (this.passNo == 1) {
            this.cachedValues = new ArrayList();
            this.N = -1.0;
        } else {
            this.targetValue = this.getTargetValueIndex();
        }
    }

    private int[] getTargetValueIndex() throws DataException {
        int n = this.adjustNValue(this.N);
        int[] result = new int[n < this.cachedValues.size() ? n : this.cachedValues.size()];
        for (int i = 0; i < n && i < this.cachedValues.size(); ++i) {
            int ind = this.getNextIndex();
            if (ind == -1) {
                return result;
            }
            result[i] = ind;
        }
        this.cachedValues = null;
        return result;
    }

    public Object getValue() throws DataException {
        return this.value;
    }

    public void onRow(Object[] args) throws DataException {
        if (!$assertionsDisabled && args.length != 2) {
            throw new AssertionError();
        }
        if (this.passNo == 1) {
            if (args[0] != null) {
                this.cachedValues.add(args[0]);
            } else {
                this.cachedValues.add(RankAggregationUtil.getNullObject());
            }
            if (this.N == -1.0) {
                this.N = this.populateNValue(args[1]);
            }
        } else {
            ++this.currentIndex;
            this.value = this.populateValue();
        }
    }

    private Boolean populateValue() {
        for (int i = 0; i < this.targetValue.length; ++i) {
            if (this.currentIndex != this.targetValue[i]) continue;
            return trueValue;
        }
        return falseValue;
    }

    protected abstract int getNextIndex() throws DataException;

    protected abstract double populateNValue(Object var1) throws DataException;

    protected abstract int adjustNValue(double var1);

    static {
        $assertionsDisabled = !BaseTopBottomAccumulator.class.desiredAssertionStatus();
        trueValue = new Boolean(true);
        falseValue = new Boolean(false);
    }
}

