/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;

class CandidateQuery
extends BaseQuery
implements ICandidateQuery {
    private ICustomDataSet customDataSet;
    private IResultIterator resultObjsIterator;
    private int groupingLevel;
    private IResultClass resultMetadata;
    static final /* synthetic */ boolean $assertionsDisabled;

    CandidateQuery() {
    }

    public void setCandidates(IResultIterator resultObjsIterator, int groupingLevel) throws DataException {
        if (!$assertionsDisabled && resultObjsIterator == null) {
            throw new AssertionError();
        }
        this.resultObjsIterator = resultObjsIterator;
        this.groupingLevel = groupingLevel;
        this.resultMetadata = resultObjsIterator.getResultClass();
    }

    public void setCandidates(ICustomDataSet customDataSet) throws DataException {
        if (!$assertionsDisabled && customDataSet == null) {
            throw new AssertionError();
        }
        this.customDataSet = customDataSet;
        this.resultMetadata = customDataSet.getResultClass();
    }

    public IResultClass getResultClass() {
        return this.resultMetadata;
    }

    public IResultIterator execute(IEventHandler eventHandler) throws DataException {
        if (this.customDataSet == null) {
            return new CachedResultSet(this, this.resultMetadata, this.resultObjsIterator, this.groupingLevel, eventHandler);
        }
        if (!DataSetCacheManager.getInstance().doesSaveToCache()) {
            return new CachedResultSet(this, this.customDataSet, eventHandler);
        }
        return new CachedResultSet((BaseQuery)this, this.resultMetadata, new DataSetResultCache(this.customDataSet, this.resultMetadata), eventHandler);
    }

    public void close() {
    }

    static {
        $assertionsDisabled = !CandidateQuery.class.desiredAssertionStatus();
    }
}

