/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;

public class DataSetCacheManager {
    private Map cacheMap = new HashMap();
    private IBaseDataSourceDesign dataSourceDesign = null;
    private IBaseDataSetDesign dataSetDesign = null;
    private Collection parameterBindings;
    private int cacheRowCount = 0;
    public static final int ALWAYS = 1;
    public static final int DISABLE = 2;
    public static final int DEFAULT = 3;
    private int cacheOption = 3;
    private int alwaysCacheRowCount = 0;
    private FolderUtil folderUtil = new FolderUtil();
    private static DataSetCacheManager cacheManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSetCacheManager getInstance() {
        if (cacheManager == null) {
            Class clazz = DataSetCacheManager.class;
            synchronized (clazz) {
                if (cacheManager == null) {
                    cacheManager = new DataSetCacheManager();
                }
            }
        }
        return cacheManager;
    }

    private DataSetCacheManager() {
    }

    public void setCacheOption(int cacheOption) {
        this.cacheOption = cacheOption;
    }

    public int suspendCache() {
        int lastCacheOption = this.cacheOption;
        this.setCacheOption(2);
        return lastCacheOption;
    }

    public void setAlwaysCacheRowCount(int rowCount) {
        this.alwaysCacheRowCount = rowCount;
    }

    public void setDataSourceAndDataSet(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign datasetDesign, Collection parameterBindings) {
        this.dataSourceDesign = dataSourceDesign;
        this.dataSetDesign = datasetDesign;
        if (datasetDesign != null) {
            this.cacheRowCount = datasetDesign.getCacheRowCount();
        }
        this.parameterBindings = parameterBindings;
    }

    public boolean doesSaveToCache() {
        if (!this.basicCache()) {
            return false;
        }
        DataSourceAndDataSet ds = this.getDataSourceAndDataSet();
        String cacheDirStr = (String)this.cacheMap.get(ds);
        if (cacheDirStr != null && new File(cacheDirStr).exists()) {
            return false;
        }
        this.cacheMap.put(ds, this.getCacheDirStr());
        return true;
    }

    public boolean doesLoadFromCache() {
        if (!this.basicCache()) {
            return false;
        }
        DataSourceAndDataSet ds = this.getDataSourceAndDataSet();
        String cacheDirStr = (String)this.cacheMap.get(ds);
        return cacheDirStr != null && new File(cacheDirStr).exists();
    }

    private boolean basicCache() {
        if (this.dataSetDesign == null) {
            return false;
        }
        if (this.cacheOption == 2) {
            return false;
        }
        return !(this.cacheOption == 1 ? this.alwaysCacheRowCount == 0 : this.dataSetDesign.getCacheRowCount() == 0);
    }

    public int getCacheRowCount() {
        if (this.cacheOption == 1) {
            if (this.alwaysCacheRowCount <= 0) {
                return Integer.MAX_VALUE;
            }
            return this.alwaysCacheRowCount;
        }
        if (this.cacheOption == 2) {
            return Integer.MAX_VALUE;
        }
        if (this.cacheRowCount == -1) {
            return Integer.MAX_VALUE;
        }
        return this.cacheRowCount;
    }

    public void clearCache(IBaseDataSourceDesign dataSourceDesign2, IBaseDataSetDesign dataSetDesign2) {
        if (dataSourceDesign2 == null || dataSetDesign2 == null) {
            return;
        }
        DataSourceAndDataSet ds = DataSetCacheManager.getDataSourceAndDataSet(dataSourceDesign2, dataSetDesign2, null, dataSetDesign2.getCacheRowCount());
        Object cacheDir = this.cacheMap.get(ds);
        if (cacheDir != null) {
            this.cacheMap.remove(ds);
            this.folderUtil.deleteDir((String)cacheDir);
        }
    }

    public String getSaveFolder() {
        return (String)this.cacheMap.get(this.getDataSourceAndDataSet());
    }

    public String getLoadFolder() {
        return (String)this.cacheMap.get(this.getDataSourceAndDataSet());
    }

    private DataSourceAndDataSet getDataSourceAndDataSet() {
        int cacheCount = 0;
        if (this.cacheOption == 1) {
            cacheCount = this.alwaysCacheRowCount;
        } else if (this.cacheOption == 2) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else {
            cacheCount = this.cacheRowCount;
        }
        return DataSetCacheManager.getDataSourceAndDataSet(this.dataSourceDesign, this.dataSetDesign, this.parameterBindings, cacheCount);
    }

    private static DataSourceAndDataSet getDataSourceAndDataSet(IBaseDataSourceDesign dataSourceDesign2, IBaseDataSetDesign dataSetDesign2, Collection paramBinds, int cacheCount) {
        return DataSourceAndDataSet.newInstance(dataSourceDesign2, dataSetDesign2, paramBinds, cacheCount);
    }

    private String getCacheDirStr() {
        return this.folderUtil.createSessionTempDir();
    }

    public void resetForTest() {
        this.cacheMap = new HashMap();
        this.folderUtil = new FolderUtil();
        this.dataSourceDesign = null;
        this.dataSetDesign = null;
        this.cacheRowCount = 0;
        this.cacheOption = 3;
        this.alwaysCacheRowCount = 0;
    }

    static {
        $assertionsDisabled = !DataSetCacheManager.class.desiredAssertionStatus();
    }

    private class FolderUtil {
        private String tempRootDirStr = null;

        private FolderUtil() {
        }

        private void createTempRootDir() {
            if (this.tempRootDirStr != null) {
                return;
            }
            String tempDirStr = System.getProperty("java.io.tmpdir");
            File tempDtEDir = new File(tempDirStr, "BirtDataCache");
            if (!tempDtEDir.exists()) {
                tempDtEDir.mkdir();
            } else {
                File[] sessionsFolder = tempDtEDir.listFiles();
                for (int i = 0; i < sessionsFolder.length; ++i) {
                    File[] oneSessionFolder = sessionsFolder[i].listFiles();
                    for (int j = 0; j < oneSessionFolder.length; ++j) {
                        if (oneSessionFolder[j].isDirectory()) {
                            File[] oneSessionTempFiles = oneSessionFolder[j].listFiles();
                            for (int k = 0; k < oneSessionTempFiles.length; ++k) {
                                oneSessionTempFiles[k].delete();
                            }
                            oneSessionFolder[j].delete();
                            continue;
                        }
                        oneSessionFolder[j].delete();
                    }
                    sessionsFolder[i].delete();
                }
            }
            try {
                this.tempRootDirStr = tempDtEDir.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private String createSessionTempDir() {
            this.createTempRootDir();
            String prefix = "session_";
            String[] filesName = new File(this.tempRootDirStr).list();
            Arrays.sort(filesName, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String f1 = (String)o1;
                    String f2 = (String)o2;
                    int index1 = f1.indexOf("session_");
                    int index2 = f2.indexOf("session_");
                    if (index1 < 0 || index2 < 0) {
                        return 0;
                    }
                    Integer i1 = Integer.valueOf(f1.substring(index1 + "session_".length()));
                    Integer i2 = Integer.valueOf(f2.substring(index2 + "session_".length()));
                    return i1.compareTo(i2);
                }
            });
            int maxIndex = -1;
            for (int i = filesName.length - 1; i >= 0; --i) {
                int index = filesName[i].indexOf("session_");
                if (index != 0) continue;
                maxIndex = Integer.valueOf(filesName[i].substring(index + "session_".length()));
                break;
            }
            String sessionTempDirStr = this.tempRootDirStr + File.separator + "session_" + ++maxIndex;
            File file = new File(sessionTempDirStr);
            file.mkdir();
            return sessionTempDirStr;
        }

        private void deleteDir(String dirStr) {
            File sessionsFolder = new File(dirStr);
            File[] sessionFiles = sessionsFolder.listFiles();
            for (int i = 0; i < sessionFiles.length; ++i) {
                sessionFiles[i].delete();
            }
            sessionsFolder.delete();
        }
    }
}

