/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultClass
implements IResultClass {
    private List m_projectedColumns;
    private HashMap m_nameToIdMapping;
    private String[] m_fieldNames;
    private int[] m_fieldDriverPositions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResultClass(List projectedColumns) {
        if (!$assertionsDisabled && projectedColumns == null) {
            throw new AssertionError();
        }
        this.initColumnsInfo(projectedColumns);
    }

    private void initColumnsInfo(List projectedColumns) {
        this.m_projectedColumns = new ArrayList();
        this.m_projectedColumns.addAll(projectedColumns);
        this.m_nameToIdMapping = new HashMap();
        int n = projectedColumns.size();
        for (int i = 0; i < n; ++i) {
            String upperCaseAlias;
            ResultFieldMetadata column = (ResultFieldMetadata)projectedColumns.get(i);
            String upperCaseName = column.getName();
            Integer index = new Integer(i + 1);
            if (!this.m_nameToIdMapping.containsKey(upperCaseName)) {
                this.m_nameToIdMapping.put(upperCaseName, index);
            }
            if ((upperCaseAlias = column.getAlias()) == null || upperCaseAlias.length() <= 0 || this.m_nameToIdMapping.containsKey(upperCaseAlias)) continue;
            this.m_nameToIdMapping.put(upperCaseAlias, index);
        }
    }

    public ResultClass(InputStream inputStream) throws DataException {
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            ArrayList<ResultFieldMetadata> newProjectedColumns = new ArrayList<ResultFieldMetadata>();
            int size = IOUtil.readInt((InputStream)dis);
            for (int i = 0; i < size; ++i) {
                int driverPos = IOUtil.readInt((InputStream)dis);
                String name = IOUtil.readString((DataInputStream)dis);
                String lable = IOUtil.readString((DataInputStream)dis);
                String alias = IOUtil.readString((DataInputStream)dis);
                String dtName = IOUtil.readString((DataInputStream)dis);
                String ntName = IOUtil.readString((DataInputStream)dis);
                boolean bool = IOUtil.readBool((InputStream)dis);
                String dpdpName = IOUtil.readString((DataInputStream)dis);
                ResultFieldMetadata metaData = new ResultFieldMetadata(driverPos, name, lable, Class.forName(dtName), ntName, bool);
                metaData.setAlias(alias);
                if (dpdpName != null) {
                    metaData.setDriverProvidedDataType(Class.forName(dpdpName));
                }
                newProjectedColumns.add(metaData);
            }
            dis.close();
            this.initColumnsInfo(newProjectedColumns);
        }
        catch (ClassNotFoundException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
    }

    public void doSave(OutputStream outputStream) throws DataException {
        if (!$assertionsDisabled && outputStream == null) {
            throw new AssertionError();
        }
        DataOutputStream dos = new DataOutputStream(outputStream);
        int size = this.m_projectedColumns.size();
        try {
            IOUtil.writeInt((OutputStream)outputStream, (int)size);
            for (int i = 0; i < size; ++i) {
                ResultFieldMetadata column = (ResultFieldMetadata)this.m_projectedColumns.get(i);
                IOUtil.writeInt((OutputStream)dos, (int)column.getDriverPosition());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getName());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getLabel());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getAlias());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getDataType().getName());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getNativeTypeName());
                IOUtil.writeBool((OutputStream)dos, (boolean)column.isCustom());
                if (column.getDriverProvidedDataType() == null) {
                    IOUtil.writeString((DataOutputStream)dos, null);
                    continue;
                }
                IOUtil.writeString((DataOutputStream)dos, (String)column.getDriverProvidedDataType().getName());
            }
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Class");
        }
    }

    public int getFieldCount() {
        return this.m_projectedColumns.size();
    }

    public String[] getFieldNames() {
        return this.doGetFieldNames();
    }

    private String[] doGetFieldNames() {
        if (this.m_fieldNames == null) {
            int size = this.m_projectedColumns.size();
            this.m_fieldNames = new String[size];
            for (int i = 0; i < size; ++i) {
                String name;
                ResultFieldMetadata column = (ResultFieldMetadata)this.m_projectedColumns.get(i);
                this.m_fieldNames[i] = name = column.getName();
            }
        }
        return this.m_fieldNames;
    }

    public int[] getFieldDriverPositions() {
        if (this.m_fieldDriverPositions == null) {
            int size = this.m_projectedColumns.size();
            this.m_fieldDriverPositions = new int[size];
            for (int i = 0; i < size; ++i) {
                ResultFieldMetadata column = (ResultFieldMetadata)this.m_projectedColumns.get(i);
                this.m_fieldDriverPositions[i] = column.getDriverPosition();
            }
        }
        return this.m_fieldDriverPositions;
    }

    public String getFieldName(int index) throws DataException {
        this.validateFieldIndex(index);
        ResultFieldMetadata column = (ResultFieldMetadata)this.m_projectedColumns.get(index - 1);
        return column.getName();
    }

    public String getFieldAlias(int index) throws DataException {
        ResultFieldMetadata column = this.findColumn(index);
        return column.getAlias();
    }

    public int getFieldIndex(String fieldName) {
        Integer i = (Integer)this.m_nameToIdMapping.get(fieldName);
        return i == null ? -1 : i;
    }

    private int doGetFieldIndex(String fieldName) throws DataException {
        int index = this.getFieldIndex(fieldName);
        if (index <= 0) {
            throw new DataException("data.engine.InvalidFieldName", fieldName);
        }
        return index;
    }

    public Class getFieldValueClass(String fieldName) throws DataException {
        int index = this.doGetFieldIndex(fieldName);
        return this.getFieldValueClass(index);
    }

    public Class getFieldValueClass(int index) throws DataException {
        ResultFieldMetadata column = this.findColumn(index);
        return column.getDataType();
    }

    public boolean isCustomField(String fieldName) throws DataException {
        int index = this.doGetFieldIndex(fieldName);
        return this.isCustomField(index);
    }

    public boolean isCustomField(int index) throws DataException {
        ResultFieldMetadata column = this.findColumn(index);
        return column.isCustom();
    }

    public String getFieldLabel(int index) throws DataException {
        ResultFieldMetadata column = this.findColumn(index);
        return column.getLabel();
    }

    private ResultFieldMetadata findColumn(int index) throws DataException {
        this.validateFieldIndex(index);
        return (ResultFieldMetadata)this.m_projectedColumns.get(index - 1);
    }

    private void validateFieldIndex(int index) throws DataException {
        if (index < 1 || index > this.getFieldCount()) {
            throw new DataException("data.engine.InvalidFieldIndex", new Integer(index));
        }
    }

    public String getFieldNativeTypeName(int index) throws DataException {
        ResultFieldMetadata column = this.findColumn(index);
        return column.getNativeTypeName();
    }

    public ResultFieldMetadata getFieldMetaData(int index) throws DataException {
        this.validateFieldIndex(index);
        return (ResultFieldMetadata)this.m_projectedColumns.get(index - 1);
    }

    static {
        $assertionsDisabled = !ResultClass.class.desiredAssertionStatus();
    }
}

