/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.DataBaseExport;
import org.eclipse.birt.data.engine.executor.cache.DataFileReader;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskBasedResultSet {
    private Map infoMap;
    private int dataCount;
    private File goalFile;
    private DataFileReader goalFileReader;
    private DataBaseExport databaseExport;
    private ResultObjectUtil resultObjectUtil;
    static final /* synthetic */ boolean $assertionsDisabled;

    DiskBasedResultSet(Map infoMap) {
        this.infoMap = infoMap;
        this.goalFile = new File((String)infoMap.get("goalFile"));
    }

    public void processStartResultObjects(IResultObject[] resultObjects, Comparator comparator) throws IOException {
        IResultClass rsMetaData = resultObjects[0].getResultClass();
        if (!$assertionsDisabled && rsMetaData == null) {
            throw new AssertionError();
        }
        this.resultObjectUtil = ResultObjectUtil.newInstance(rsMetaData);
        this.databaseExport = DataBaseExport.newInstance(this.infoMap, comparator, rsMetaData, this.resultObjectUtil);
        this.databaseExport.exportStartDataToDisk(resultObjects);
        this.dataCount = resultObjects.length;
    }

    public void processRestResultObjects(IResultObject resultObject, IRowResultSet rs) throws DataException, IOException {
        this.dataCount += this.databaseExport.exportRestDataToDisk(resultObject, rs);
    }

    public int getCount() {
        return this.dataCount;
    }

    public IResultObject nextRow() throws IOException {
        if (this.goalFileReader == null) {
            this.goalFileReader = DataFileReader.newInstance(this.goalFile, this.resultObjectUtil);
        }
        return this.goalFileReader.read(1)[0];
    }

    public void reset() {
        if (this.goalFileReader != null) {
            this.goalFileReader.setReadFile(this.goalFile);
        }
    }

    public void close() {
        if (this.goalFileReader != null) {
            this.goalFileReader.close();
        }
        this.databaseExport = null;
        this.resultObjectUtil = null;
    }

    static {
        $assertionsDisabled = !DiskBasedResultSet.class.desiredAssertionStatus();
    }
}

