/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.RowResultSet;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class ExpandableRowResultSet
implements IRowResultSet {
    private IResultClass resultClass;
    private RowResultSet rowResultSet;

    ExpandableRowResultSet(SmartCacheRequest smartCacheRequest) {
        this.resultClass = smartCacheRequest.getResultClass();
        this.rowResultSet = new RowResultSet(smartCacheRequest);
    }

    public IResultClass getMetaData() {
        return this.resultClass;
    }

    public IResultObject next() throws DataException {
        IResultObject ro = this.rowResultSet.next();
        if (ro == null) {
            return null;
        }
        Object[] objs = new Object[this.resultClass.getFieldCount()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = i + 1 <= ro.getResultClass().getFieldCount() ? ro.getFieldValue(i + 1) : null;
        }
        return new ResultObject(this.resultClass, objs);
    }
}

