/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class MemoryCache
implements ResultSetCache {
    private int countOfResult;
    private int currResultIndex = -1;
    private IResultClass rsMeta;
    private IResultObject currResultObject;
    private IResultObject[] resultObjects;

    MemoryCache(IResultObject[] resultObjects, IResultClass rsMeta, Comparator comparator) {
        this.resultObjects = resultObjects;
        this.rsMeta = rsMeta;
        this.countOfResult = resultObjects.length;
        if (comparator != null) {
            Arrays.sort(this.resultObjects, comparator);
        }
    }

    public int getCurrentIndex() throws DataException {
        return this.currResultIndex;
    }

    public IResultObject getCurrentResult() throws DataException {
        return this.currResultObject;
    }

    public boolean next() throws DataException {
        if (this.currResultIndex > this.countOfResult - 1) {
            this.currResultObject = null;
        } else {
            ++this.currResultIndex;
            this.currResultObject = this.currResultIndex == this.countOfResult ? null : this.resultObjects[this.currResultIndex];
        }
        return this.currResultObject != null;
    }

    public IResultObject fetch() throws DataException {
        this.next();
        IResultObject resultObject = this.getCurrentResult();
        return resultObject;
    }

    public void moveTo(int destIndex) throws DataException {
        this.checkValid(destIndex);
        this.currResultIndex = destIndex;
        this.currResultObject = this.currResultIndex == -1 || this.currResultIndex == this.countOfResult ? null : this.resultObjects[this.currResultIndex];
    }

    private void checkValid(int destIndex) throws DataException {
        if (destIndex < -1 || destIndex > this.countOfResult) {
            throw new DataException("data.engine.BadDestIndex", new Object[]{new Integer(-1), new Integer(this.countOfResult)});
        }
    }

    public int getCount() {
        return this.countOfResult;
    }

    public void reset() {
        this.currResultIndex = -1;
        this.currResultObject = null;
    }

    public void close() {
        this.reset();
        this.resultObjects = null;
    }

    public void doSave(OutputStream outputStream) throws DataException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            int rowCount = this.resultObjects.length;
            int colCount = this.rsMeta.getFieldCount();
            IOUtil.writeInt((OutputStream)dos, (int)rowCount);
            for (int i = 0; i < rowCount; ++i) {
                ResultSetUtil.writeResultObject(dos, this.resultObjects[i], colCount);
            }
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }
}

