/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.transform.IRowProcessor;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;

class SinglePassRowProcessor
implements IRowProcessor {
    private ResultSetPopulator populator;
    private static final boolean ALLOW_GROUP_FILTERING = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    SinglePassRowProcessor(ResultSetPopulator populator) {
        this.populator = populator;
    }

    public boolean pass(OdiResultSetWrapper resultSource) throws DataException {
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().initGroupSpec();
        this.initOdiResultSet(resultSource, this.populator.getGroupProcessorManager().getGroupCalculationUtil().getSortSpec());
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().doGrouping();
        IQuery.GroupSpec[] groups = this.populator.getGroupProcessorManager().getGroupCalculationUtil().getQuery().getGrouping();
        this.populator.getGroupProcessorManager().processGroupWithIntervals(this.populator.getCache(), groups, this.populator.getExpressionProcessor());
        this.populator.getCache().next();
        return true;
    }

    void initOdiResultSet(OdiResultSetWrapper rsWrapper, SortSpec sortSpec) throws DataException {
        Object resultSource = rsWrapper.getWrappedOdiResultSet();
        if (!$assertionsDisabled && resultSource == null) {
            throw new AssertionError();
        }
        SmartCache smartCache = null;
        BaseQuery query = this.populator.getQuery();
        IResultClass rsMeta = this.populator.getResultSetMetadata();
        if (resultSource instanceof ResultSet) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, this.populator.getEventHandler(), query.getDistinctValueFlag()), (ResultSet)resultSource, rsMeta);
        } else if (resultSource instanceof ICustomDataSet) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, this.populator.getEventHandler(), query.getDistinctValueFlag()), new OdiAdapter((ICustomDataSet)resultSource), rsMeta);
        } else if (resultSource instanceof IDataSetPopulator) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, this.populator.getEventHandler(), query.getDistinctValueFlag()), new OdiAdapter((IDataSetPopulator)resultSource), rsMeta);
        } else if (resultSource instanceof DataSetResultCache) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, this.populator.getEventHandler(), false), new OdiAdapter((DataSetResultCache)resultSource), rsMeta);
        } else if (resultSource instanceof IResultIterator) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, this.populator.getEventHandler(), false), new OdiAdapter((IResultIterator)resultSource), rsMeta);
        } else if (resultSource instanceof Object[]) {
            Object[] obs = (Object[])resultSource;
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, this.populator.getEventHandler(), false), (ResultSetCache)obs[0], ((int[])obs[1])[0], ((int[])obs[1])[1], rsMeta);
        }
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().setResultSetCache(smartCache);
        this.populator.setCache(smartCache);
    }

    static {
        $assertionsDisabled = !SinglePassRowProcessor.class.desiredAssertionStatus();
    }
}

