/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfoComparator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInformationUtil;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class GroupCalculationUtil {
    private BaseQuery query;
    private IResultClass rsMeta;
    private GroupBy[] groupDefs;
    private ResultSetCache smartCache;
    private GroupInformationUtil groupInformationUtil;
    private ResultSetPopulator resultPopoulator;
    static final /* synthetic */ boolean $assertionsDisabled;

    GroupCalculationUtil(BaseQuery query, IResultClass rsMeta, ResultSetPopulator resultPopoulator) {
        this.query = query;
        this.rsMeta = rsMeta;
        this.groupInformationUtil = new GroupInformationUtil(this);
        this.resultPopoulator = resultPopoulator;
    }

    GroupCalculationUtil(InputStream inputStream, IResultClass rsMeta, ResultSetCache rsCache) throws DataException {
        try {
            this.groupInformationUtil.readGroupsFromStream(inputStream);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Group Info");
        }
        this.rsMeta = rsMeta;
        this.smartCache = rsCache;
    }

    public GroupInformationUtil getGroupInformationUtil() {
        return this.groupInformationUtil;
    }

    public void doSave(OutputStream outputStream) throws DataException {
        try {
            this.groupInformationUtil.saveGroupsToStream(outputStream);
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Group Information");
        }
    }

    public void setResultSetCache(ResultSetCache rsc) {
        this.smartCache = rsc;
    }

    int getGroupCount() {
        return this.groupDefs.length;
    }

    void sortGroupBoundaryInfos(ArrayList[] groupArray) {
        for (int i = 0; i < groupArray.length; ++i) {
            int j;
            Object[] toBeSorted = new Object[groupArray[i].size()];
            for (j = 0; j < toBeSorted.length; ++j) {
                toBeSorted[j] = groupArray[i].get(j);
            }
            Arrays.sort(toBeSorted, new GroupBoundaryInfoComparator());
            groupArray[i].clear();
            for (j = 0; j < toBeSorted.length; ++j) {
                groupArray[i].add(toBeSorted[j]);
            }
        }
    }

    public BaseQuery getQuery() {
        return this.query;
    }

    ArrayList[] filterGroupBoundaryInfos(ArrayList[] groupArray) {
        int i;
        ArrayList[] result = new ArrayList[groupArray.length];
        for (i = 0; i < result.length; ++i) {
            result[i] = new ArrayList();
        }
        for (i = 0; i < groupArray.length; ++i) {
            for (int j = 0; j < groupArray[i].size(); ++j) {
                if (!((GroupBoundaryInfo)groupArray[i].get(j)).isAccpted()) continue;
                result[i].add(groupArray[i].get(j));
            }
        }
        return result;
    }

    GroupBy[] getGroupDefn() {
        return this.groupDefs;
    }

    ResultSetCache getResultSetCache() {
        return this.smartCache;
    }

    public void initGroupSpec() throws DataException {
        IQuery.GroupSpec[] groupSpecs = this.query.getGrouping();
        if (groupSpecs != null) {
            this.groupDefs = new GroupBy[groupSpecs.length];
            for (int i = 0; i < groupSpecs.length; ++i) {
                int keyIndex = groupSpecs[i].getKeyIndex();
                String keyColumn = groupSpecs[i].getKeyColumn();
                if (this.resultPopoulator.getEventHandler() != null && this.resultPopoulator.getEventHandler().isRowID(keyIndex, keyColumn)) {
                    this.groupDefs[i] = GroupBy.newInstanceForRowID(groupSpecs[i]);
                    continue;
                }
                if (keyColumn != null) {
                    keyIndex = this.rsMeta.getFieldIndex(keyColumn);
                }
                if (keyIndex < 1 || keyIndex > this.rsMeta.getFieldCount()) {
                    throw new DataException("data.engine.InvalidGroupKeyName", keyColumn);
                }
                this.groupDefs[i] = GroupBy.newInstance(groupSpecs[i], keyIndex, keyColumn, this.rsMeta.getFieldValueClass(keyIndex));
            }
        } else {
            this.groupDefs = new GroupBy[0];
        }
    }

    public SortSpec getSortSpec() throws DataException {
        int i;
        if (!$assertionsDisabled && this.groupDefs == null) {
            throw new AssertionError();
        }
        int groupCount = 0;
        int sortCount = 0;
        for (int i2 = 0; i2 < this.groupDefs.length; ++i2) {
            if (this.groupDefs[i2].getColumnIndex() < 0) continue;
            ++groupCount;
        }
        if (this.query.getOrdering() != null) {
            sortCount = this.query.getOrdering().length;
        }
        int[] sortKeyIndexes = new int[groupCount + sortCount];
        String[] sortKeyColumns = new String[groupCount + sortCount];
        boolean[] sortAscending = new boolean[groupCount + sortCount];
        for (i = 0; i < groupCount; ++i) {
            int index = this.groupDefs[i].getColumnIndex();
            if (index < 0) continue;
            sortKeyIndexes[i] = this.groupDefs[i].getColumnIndex();
            sortKeyColumns[i] = this.groupDefs[i].getColumnName();
            sortAscending[i] = true;
        }
        for (i = 0; i < sortCount; ++i) {
            int keyIndex = this.query.getOrdering()[i].getIndex();
            String keyName = this.query.getOrdering()[i].getField();
            if (keyName != null) {
                keyIndex = this.rsMeta.getFieldIndex(keyName);
            }
            sortKeyIndexes[groupCount + i] = keyIndex;
            sortKeyColumns[groupCount + i] = keyName;
            sortAscending[groupCount + i] = this.query.getOrdering()[i].isAscendingOrder();
        }
        return new SortSpec(sortKeyIndexes, sortKeyColumns, sortAscending);
    }

    static {
        $assertionsDisabled = !GroupCalculationUtil.class.desiredAssertionStatus();
    }
}

