/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;

public class GroupInstanceSorter {
    private ResultSetPopulator populator;
    private GroupProcessorManager groupProcessor;

    GroupInstanceSorter(GroupProcessorManager gp) {
        this.populator = gp.getResultSetPopulator();
        this.groupProcessor = gp;
    }

    void doGroupSorting(Context cx) throws DataException {
        ArrayList groupLevels = new ArrayList();
        ArrayList expressionList = new ArrayList();
        this.populateGroupSortExpressions(expressionList, groupLevels);
        if (expressionList.size() > 0) {
            this.groupProcessor.calculateExpressionList(expressionList, groupLevels, 4);
            List[] groupArray = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getGroupBoundaryInfos();
            this.populateGroupBoundaryInfosSortings(cx, (ArrayList[])groupArray);
            this.groupProcessor.getGroupCalculationUtil().sortGroupBoundaryInfos((ArrayList[])groupArray);
            OrderingInfo odInfo = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getOrderingInfo(groupArray);
            this.populator.reSetSmartCacheUsingOrderingInfo(odInfo);
        }
    }

    void populateGroupSortExpressions(List expressionList, List groupLevels) {
        for (int i = 0; i < this.populator.getQuery().getGrouping().length; ++i) {
            List groupSorts = this.populator.getQuery().getGrouping()[i].getSorts();
            String name = this.populator.getQuery().getGrouping()[i].getName();
            if (groupSorts == null) continue;
            for (int j = 0; j < groupSorts.size(); ++j) {
                IScriptExpression expr = ((ISortDefinition)groupSorts.get(j)).getExpression();
                expr.setGroupName(name);
                expressionList.add(expr);
                groupLevels.add(new Integer(i + 1));
            }
        }
    }

    void populateGroupBoundaryInfosSortings(Context cx, ArrayList[] groupArray) throws DataException {
        for (int i = 0; i < this.populator.getQuery().getGrouping().length; ++i) {
            List groupSorts = this.populator.getQuery().getGrouping()[i].getSorts();
            if (groupSorts == null || groupSorts.size() == 0) continue;
            this.populator.getResultIterator().first(0);
            for (int j = 0; j < groupArray[i].size(); ++j) {
                this.populateGroupBoundaryInfoSortings(cx, groupArray, i, j);
            }
        }
    }

    private void populateGroupBoundaryInfoSortings(Context cx, ArrayList[] groupArray, int groupPosition, int groupIndex) throws DataException {
        Object[] sortKeys = new Object[this.populator.getQuery().getGrouping()[groupPosition].getSorts().size()];
        boolean[] sortDirections = new boolean[sortKeys.length];
        this.populator.getResultIterator().last(groupPosition + 1);
        for (int l = 0; l < sortKeys.length; ++l) {
            sortKeys[l] = ScriptEvalUtil.evalExpr(((ISortDefinition)this.populator.getQuery().getGrouping()[groupPosition].getSorts().get(l)).getExpression(), cx, this.groupProcessor.getExpressionProcessor().getScope(), "GroupFilter", 0);
            sortDirections[l] = ((ISortDefinition)this.populator.getQuery().getGrouping()[groupPosition].getSorts().get(l)).getSortDirection() == 0;
        }
        ((GroupBoundaryInfo)groupArray[groupPosition].get(groupIndex)).setSortCondition(sortKeys, sortDirections);
        this.populator.getResultIterator().next();
    }
}

