/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInstanceSorter;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.mozilla.javascript.Context;

public class GroupWithIntervalsProcessor {
    private ResultSetPopulator populator;
    private GroupProcessorManager groupProcessor;
    private GroupInstanceSorter giSorter;

    GroupWithIntervalsProcessor(GroupProcessorManager gp) {
        this.populator = gp.getResultSetPopulator();
        this.groupProcessor = gp;
        this.giSorter = new GroupInstanceSorter(this.groupProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGroupWithIntervals(ResultSetCache rsCache, IQuery.GroupSpec[] groups) throws DataException {
        this.populator.setCache(rsCache);
        List leveledGroup = this.populateLeveledGroups(groups);
        if (leveledGroup.size() > 0) {
            Context cx = Context.enter();
            try {
                this.groupProcessor.getGroupCalculationUtil().getQuery().setGrouping(null);
                for (int i = 0; i < leveledGroup.size() - 1; ++i) {
                    IQuery.GroupSpec immediatelyNextGroupSpec = ((IQuery.GroupSpec[])leveledGroup.get(i + 1))[0];
                    SortDefinition sd = new SortDefinition();
                    if (immediatelyNextGroupSpec.getKeyColumn() != null) {
                        sd.setExpression("dataSetRow[\"" + JavascriptEvalUtil.transformToJsConstants((String)immediatelyNextGroupSpec.getKeyColumn()) + "\"]");
                    } else {
                        sd.setExpression("dataSetRow[\"" + immediatelyNextGroupSpec.getKeyIndex() + "\"]");
                    }
                    ArrayList<SortDefinition> sorts = new ArrayList<SortDefinition>();
                    sorts.add(sd);
                    immediatelyNextGroupSpec.setSorts(sorts);
                    ArrayList<IQuery.GroupSpec> tempGroups = new ArrayList<IQuery.GroupSpec>();
                    for (int k = 0; k < leveledGroup.size(); ++k) {
                        IQuery.GroupSpec[] tempGroupsArray = (IQuery.GroupSpec[])leveledGroup.get(k);
                        for (int j = 0; j < tempGroupsArray.length; ++j) {
                            tempGroups.add(tempGroupsArray[j]);
                        }
                    }
                    this.groupProcessor.getGroupCalculationUtil().getQuery().setGrouping(tempGroups);
                    this.populator.getCache().next();
                    ArrayList groupLevels = new ArrayList();
                    ArrayList expressionList = new ArrayList();
                    this.giSorter.populateGroupSortExpressions(expressionList, groupLevels);
                    this.groupProcessor.calculateExpressionList(expressionList, groupLevels, 4);
                    List[] groupArray = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getGroupBoundaryInfos();
                    this.giSorter.populateGroupBoundaryInfosSortings(cx, (ArrayList[])groupArray);
                    this.groupProcessor.getGroupCalculationUtil().sortGroupBoundaryInfos((ArrayList[])groupArray);
                    OrderingInfo odInfo = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getOrderingInfo(groupArray);
                    this.populator.reSetCache(odInfo);
                    immediatelyNextGroupSpec.setSorts(new ArrayList());
                    this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().doGrouping();
                }
                this.groupProcessor.getGroupCalculationUtil().getQuery().setGrouping(this.getListFromArray(groups));
            }
            finally {
                Context.exit();
            }
        }
    }

    private List populateLeveledGroups(IQuery.GroupSpec[] groups) {
        ArrayList<IQuery.GroupSpec[]> leveledGroup = new ArrayList<IQuery.GroupSpec[]>();
        if (groups != null) {
            int last = -1;
            for (int i = 0; i < groups.length - 1; ++i) {
                if (groups[i].getInterval() == 0) continue;
                IQuery.GroupSpec[] gs = this.getOneLevelOfGroupSpecs(groups, last, i);
                last = i;
                leveledGroup.add(gs);
            }
            if (last > -1) {
                leveledGroup.add(this.getOneLevelOfGroupSpecs(groups, last, groups.length - 1));
            }
        }
        return leveledGroup;
    }

    private List getListFromArray(Object[] o) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (o == null) {
            return l;
        }
        for (int i = 0; i < o.length; ++i) {
            l.add(o[i]);
        }
        return l;
    }

    private IQuery.GroupSpec[] getOneLevelOfGroupSpecs(IQuery.GroupSpec[] groups, int last, int i) {
        IQuery.GroupSpec[] gs = new IQuery.GroupSpec[i - last];
        for (int j = last + 1; j <= i; ++j) {
            IQuery.GroupSpec gps = new IQuery.GroupSpec(groups[j].getKeyIndex(), groups[j].getKeyColumn());
            gps.setDataType(groups[j].getDataType());
            gps.setInterval(groups[j].getInterval());
            gps.setIntervalRange(groups[j].getIntervalRange());
            gps.setIntervalStart(groups[j].getIntervalStart());
            gps.setIsComplexExpression(groups[j].isCompleteExpression());
            gps.setName(groups[j].getName());
            gps.setSortDirection(groups[j].getSortDirection());
            gs[j - last - 1] = gps;
        }
        return gs;
    }
}

