/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.aggregation.AggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.eclipse.birt.data.engine.expression.InvalidExpression;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;

public final class ExpressionCompiler {
    private CompilerEnvirons m_compilerEnv;
    private static final String STRING_ROW = "row";
    private static final String STRING_DATASETROW = "dataSetRow";
    private static final String TOTAL = "Total";
    public static final String AGGR_VALUE = "_aggr_value";
    protected static Logger logger;
    private String rowIndicator = "row";
    private boolean isDataSetMode = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledExpression compile(String expression, AggregateRegistry registry, Context context) {
        CompiledExpression compiledExpression;
        logger.entering(ExpressionCompiler.class.getName(), "compile", expression);
        try {
            if (expression == null || expression.trim().length() == 0) {
                throw new DataException("data.engine.EmptyExpression");
            }
            logger.logp(Level.FINER, ExpressionCompiler.class.getName(), "compile", "Start to compile expression to produce a CompileExpression", expression);
            ScriptOrFnNode tree = this.parse(expression, context);
            compiledExpression = this.getCompiledExprFromTree(expression, context, registry, tree);
            Object var8_8 = null;
            logger.logp(Level.FINER, ExpressionCompiler.class.getName(), "compile", "Finish compiling an expression");
        }
        catch (Exception e) {
            InvalidExpression invalidExpression;
            try {
                DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, expression);
                logger.logp(Level.FINE, ExpressionCompiler.class.getName(), "compile", "Expression is not valid.", e);
                invalidExpression = new InvalidExpression(dataException);
                Object var8_9 = null;
                logger.logp(Level.FINER, ExpressionCompiler.class.getName(), "compile", "Finish compiling an expression");
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                logger.logp(Level.FINER, ExpressionCompiler.class.getName(), "compile", "Finish compiling an expression");
                logger.exiting(ExpressionCompiler.class.getName(), "compile");
                throw throwable;
            }
            logger.exiting(ExpressionCompiler.class.getName(), "compile");
            return invalidExpression;
        }
        logger.exiting(ExpressionCompiler.class.getName(), "compile");
        return compiledExpression;
    }

    private ScriptOrFnNode parse(String expression, Context cx) {
        logger.entering(ExpressionCompiler.class.getName(), "parse", expression);
        CompilerEnvirons compilerEnv = this.getCompilerEnv(cx);
        Parser p = new Parser(compilerEnv, cx.getErrorReporter());
        return p.parse(expression, null, 0);
    }

    private CompiledExpression getCompiledExprFromTree(String expression, Context context, AggregateRegistry registry, ScriptOrFnNode tree) throws DataException {
        CompiledExpression expr;
        logger.entering(ExpressionCompiler.class.getName(), "getCompiledExprFromTree");
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() != 130 && tree.getFirstChild().getType() != 129 && tree.getFirstChild().getType() != 125) {
                throw new DataException("data.engine.InvalidJSExpr", expression);
            }
            Node exprNode = tree.getFirstChild();
            Node child = exprNode.getFirstChild();
            if (!$assertionsDisabled && child == null) {
                throw new AssertionError();
            }
            expr = this.processChild(context, registry, exprNode, child);
        } else {
            expr = this.getComplexExpr(context, registry, (Node)tree);
        }
        if (expr instanceof BytecodeExpression) {
            this.compileForBytecodeExpr(context, tree, expr);
        }
        logger.exiting(ExpressionCompiler.class.getName(), "getCompiledExprFromTree", expr);
        return expr;
    }

    private void compileForBytecodeExpr(Context context, ScriptOrFnNode tree, CompiledExpression expr) {
        logger.entering(ExpressionCompiler.class.getName(), "compileForBytecodeExpr", new Object[]{context, tree, expr});
        if (!$assertionsDisabled && !(expr instanceof BytecodeExpression)) {
            throw new AssertionError();
        }
        CompilerEnvirons compilerEnv = this.getCompilerEnv(context);
        Interpreter compiler = new Interpreter();
        Object compiledOb = compiler.compile(compilerEnv, tree, null, false);
        Script script = compiler.createScriptObject(compiledOb, null);
        ((BytecodeExpression)expr).setScript(script);
        logger.exiting(ExpressionCompiler.class.getName(), "compileForBytecodeExpr");
    }

    private CompiledExpression processChild(Context context, AggregateRegistry registry, Node parent, Node child) throws DataException {
        CompiledExpression compiledExpr = null;
        switch (child.getType()) {
            case 39: {
                compiledExpr = new ConstantExpression(child.getDouble());
                break;
            }
            case 40: {
                compiledExpr = new ConstantExpression(child.getString());
                break;
            }
            case 41: {
                compiledExpr = new ConstantExpression();
                break;
            }
            case 44: {
                compiledExpr = new ConstantExpression(true);
                break;
            }
            case 43: {
                compiledExpr = new ConstantExpression(false);
                break;
            }
            case 33: {
                ConstantExpression ce = AggregationConstantsUtil.getConstantExpression(child);
                if (ce != null) {
                    compiledExpr = ce;
                    break;
                }
            }
            case 35: {
                compiledExpr = this.getDirectColRefExpr(child);
                break;
            }
            case 37: {
                compiledExpr = this.getAggregateExpr(context, registry, parent, child);
            }
        }
        if (compiledExpr == null) {
            compiledExpr = this.getComplexExpr(context, registry, child);
        }
        return compiledExpr;
    }

    private ColumnReferenceExpression getDirectColRefExpr(Node refNode) {
        if (!$assertionsDisabled && refNode.getType() != 33 && refNode.getType() != 35) {
            throw new AssertionError();
        }
        Node rowName = refNode.getFirstChild();
        if (!$assertionsDisabled && rowName == null) {
            throw new AssertionError();
        }
        if (rowName.getType() != 38) {
            return null;
        }
        String str = rowName.getString();
        if (!$assertionsDisabled && str == null) {
            throw new AssertionError();
        }
        if (!str.equals(this.rowIndicator)) {
            return null;
        }
        Node rowColumn = rowName.getNext();
        if (!$assertionsDisabled && rowColumn == null) {
            throw new AssertionError();
        }
        if (refNode.getType() == 33 && rowColumn.getType() == 40) {
            if ("_outer".equals(rowColumn.getString()) || "__rownum".equals(rowColumn.getString()) || "0".equals(rowColumn.getString())) {
                return null;
            }
            return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, rowColumn.getString());
        }
        if (refNode.getType() == 35) {
            if (rowColumn.getType() == 39) {
                if (0.0 == rowColumn.getDouble()) {
                    return null;
                }
                return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, (int)rowColumn.getDouble());
            }
            if (rowColumn.getType() == 40) {
                if ("_rownum".equals(rowColumn.getString())) {
                    return null;
                }
                return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, rowColumn.getString());
            }
        }
        return null;
    }

    private AggregateExpression getAggregateExpr(Context context, AggregateRegistry registry, Node parent, Node callNode) throws DataException {
        logger.entering(ExpressionCompiler.class.getName(), "getAggregateExpr");
        if (!$assertionsDisabled && callNode.getType() != 37) {
            throw new AssertionError();
        }
        IAggregation aggregation = this.getAggregationFunction(callNode);
        if (aggregation == null) {
            logger.exiting(ExpressionCompiler.class.getName(), "getAggregateExpr");
            return null;
        }
        AggregateExpression aggregateExpression = new AggregateExpression(aggregation);
        this.extractArguments(context, registry, aggregateExpression, callNode);
        this.replaceAggregateNode(registry, aggregateExpression, parent, callNode);
        logger.exiting(ExpressionCompiler.class.getName(), "getAggregateExpr", aggregateExpression);
        return aggregateExpression;
    }

    private IAggregation getAggregationFunction(Node callNode) throws DataException {
        Node firstChild = callNode.getFirstChild();
        if (firstChild.getType() != 33) {
            return null;
        }
        Node getPropLeftChild = firstChild.getFirstChild();
        if (getPropLeftChild.getType() != 38 || !getPropLeftChild.getString().equals(TOTAL)) {
            return null;
        }
        Node getPropRightChild = firstChild.getLastChild();
        if (getPropRightChild.getType() != 40) {
            return null;
        }
        String aggrFuncName = getPropRightChild.getString();
        IAggregation agg = AggregationFactory.getInstance().getAggregation(aggrFuncName);
        if (agg == null) {
            throw new DataException("data.engine.InvalidTotalFuncName", aggrFuncName);
        }
        return agg;
    }

    private void extractArguments(Context context, AggregateRegistry registry, AggregateExpression aggregateExpression, Node callNode) throws DataException {
        Node arg = callNode.getFirstChild().getNext();
        while (arg != null) {
            Node nextArg = arg.getNext();
            CompiledExpression expr = this.processChild(context, registry, callNode, arg);
            if (!(expr instanceof BytecodeExpression)) {
                aggregateExpression.addArgument(expr);
                arg = nextArg;
                continue;
            }
            ScriptOrFnNode tree = new ScriptOrFnNode(132);
            Node exprNode = new Node(130);
            exprNode.addChildToFront(arg);
            tree.addChildrenToFront(exprNode);
            this.compileForBytecodeExpr(context, tree, expr);
            aggregateExpression.addArgument(expr);
            arg = nextArg;
        }
    }

    private void replaceAggregateNode(AggregateRegistry registry, AggregateExpression aggregateExpression, Node parent, Node aggregateCallNode) throws DataException {
        if (registry == null) {
            throw new DataException("data.engine.NoAggrFunc");
        }
        int aggregateId = registry.register(aggregateExpression);
        Node newFirstChild = Node.newString((int)38, (String)AGGR_VALUE);
        Node newSecondChild = Node.newNumber((double)aggregateId);
        Node aggregateNode = new Node(35, newFirstChild, newSecondChild);
        parent.replaceChild(aggregateCallNode, aggregateNode);
    }

    private ComplexExpression getComplexExpr(Context context, AggregateRegistry registry, Node complexNode) throws DataException {
        logger.entering(ExpressionCompiler.class.getName(), "getComplexExpr");
        ComplexExpression complexExpr = new ComplexExpression();
        Node child = complexNode.getFirstChild();
        complexExpr.addTokenList(new Integer(complexNode.getType()));
        while (child != null) {
            CompiledExpression subExpr;
            Node nextChild = child.getNext();
            if (child.getType() == 39 || child.getType() == 40 || child.getType() == 44 || child.getType() == 43 || child.getType() == 41) {
                subExpr = this.processChild(context, registry, complexNode, child);
                if (subExpr instanceof ConstantExpression) {
                    complexExpr.addContantsExpressions(subExpr);
                }
                child = nextChild;
                continue;
            }
            subExpr = this.processChild(context, registry, complexNode, child);
            complexExpr.addSubExpression(subExpr);
            complexExpr.addTokenList(new Integer(child.getType()));
            child = nextChild;
        }
        this.flattenNestedComplexExprs(complexExpr);
        logger.exiting(ExpressionCompiler.class.getName(), "getComplexExpr", complexExpr);
        return complexExpr;
    }

    private void flattenNestedComplexExprs(ComplexExpression complexExpr) {
        ArrayList<CompiledExpression> interestingSubExpr = new ArrayList<CompiledExpression>();
        ArrayList<CompiledExpression> interestingConstantExpr = new ArrayList<CompiledExpression>();
        Collection subExprs = complexExpr.getSubExpressions();
        Iterator iter = subExprs.iterator();
        while (iter.hasNext()) {
            CompiledExpression childExpr = (CompiledExpression)iter.next();
            if (childExpr instanceof ColumnReferenceExpression || childExpr instanceof AggregateExpression) {
                interestingSubExpr.add(childExpr);
            } else if (childExpr instanceof ComplexExpression) {
                Collection childSubExprs = ((ComplexExpression)childExpr).getSubExpressions();
                childSubExprs.addAll(((ComplexExpression)childExpr).getConstantExpressions());
                Iterator childIter = childSubExprs.iterator();
                while (childIter.hasNext()) {
                    CompiledExpression childChildExpr = (CompiledExpression)childIter.next();
                    if (childChildExpr instanceof ColumnReferenceExpression || childChildExpr instanceof AggregateExpression) {
                        interestingSubExpr.add(childChildExpr);
                        continue;
                    }
                    if (childChildExpr instanceof ConstantExpression) {
                        interestingConstantExpr.add(childChildExpr);
                        continue;
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            iter.remove();
        }
        complexExpr.addSubExpressions(interestingSubExpr);
        complexExpr.addContantsExpressions(interestingConstantExpr);
    }

    private CompilerEnvirons getCompilerEnv(Context context) {
        if (this.m_compilerEnv == null) {
            this.m_compilerEnv = new CompilerEnvirons();
            this.m_compilerEnv.initFromContext(context);
        }
        return this.m_compilerEnv;
    }

    public void setDataSetMode(boolean isDataSetMode) {
        this.isDataSetMode = isDataSetMode;
        this.rowIndicator = isDataSetMode ? STRING_ROW : STRING_DATASETROW;
    }

    static {
        $assertionsDisabled = !ExpressionCompiler.class.desiredAssertionStatus();
        logger = Logger.getLogger(ExpressionCompiler.class.getName());
    }
}

