/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.AggregateObject;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionParseHelper;
import org.eclipse.birt.data.engine.expression.FilterExpressionParser;
import org.eclipse.birt.data.engine.expression.InvalidExpression;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ExpressionProcessor
implements IExpressionProcessor {
    private List tempRefactorCmpList;
    private IComputedColumnsState computedColumnState;
    private int exprType = 0;
    private ExpressionParseHelper helper;
    private IResultIterator resultIterator;
    private IResultClass metaData;
    private BaseQuery query;
    private int currentGroupLevel;
    private DataSetRuntime dataSet;
    private boolean isDataSetMode = true;
    private ResultSetPopulator rsPopulator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExpressionProcessor(IResultClass metaData, IResultIterator resultIterator, DataSetRuntime dataSet, BaseQuery query) {
        this.helper = new ExpressionParseHelper(metaData, dataSet.getScriptScope());
        this.helper.setDataSetMode(this.isDataSetMode);
        this.helper.setQuery(query);
        this.metaData = metaData;
        this.query = query;
        this.resultIterator = resultIterator;
        this.dataSet = dataSet;
    }

    public void setResultSetPopulator(ResultSetPopulator rsPopulator) {
        this.rsPopulator = rsPopulator;
        this.helper.setResultSetPopulator(rsPopulator);
    }

    public void setResultIterator(IResultIterator it) {
        this.resultIterator = it;
        this.dataSet.setResultSet(it, false);
    }

    public void setResultSetMetaData(IResultClass rsMetaData) {
        this.helper.setMetaData(rsMetaData);
        this.metaData = rsMetaData;
    }

    public void setQuery(BaseQuery query) {
        this.query = query;
        this.helper.setQuery(query);
    }

    public Scriptable getScope() {
        return this.dataSet.getScriptScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileComputedColumn(IComputedColumnsState computedColumns) {
        if (!$assertionsDisabled && computedColumns == null) {
            throw new AssertionError();
        }
        this.computedColumnState = computedColumns;
        IScriptExpression cmptdColumn = null;
        this.helper.useResultSetMetaData(true);
        Context context = Context.enter();
        try {
            for (int i = 0; i < this.computedColumnState.getCount(); ++i) {
                if (!this.computedColumnState.isValueAvailable(i)) {
                    String name = this.computedColumnState.getName(i);
                    if (name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E")) {
                        this.exprType = 2;
                        this.currentGroupLevel = this.getCurrentGroupLevel(name, this.currentGroupLevel);
                        this.helper.setExpressionType(this.exprType, this.currentGroupLevel);
                        if (this.tempRefactorCmpList == null) {
                            this.tempRefactorCmpList = new ArrayList();
                        }
                        this.tempRefactorCmpList.add(new Integer(i));
                    }
                    cmptdColumn = (IScriptExpression)this.computedColumnState.getExpression(i);
                    this.compileScriptExpression(cmptdColumn, context);
                    if (this.exprType == 2) {
                        this.exprType = 0;
                        this.helper.setExpressionType(0, 0);
                        this.helper.resetPassLevel();
                        return;
                    }
                }
                if (this.helper.getExpressionPassLevel() <= 1) {
                    if (this.tempRefactorCmpList == null) {
                        this.tempRefactorCmpList = new ArrayList();
                    }
                } else {
                    this.helper.resetPassLevel();
                    this.helper.setExpressionType(this.exprType, 0);
                    return;
                }
                this.tempRefactorCmpList.add(new Integer(i));
                this.helper.setExpressionType(this.exprType, 0);
                this.helper.resetPassLevel();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void compileFilter(List filters, IComputedColumnsState computedColumns) throws DataException {
        IBaseExpression baseExpression = null;
        String expression = "";
        IScriptExpression operator = null;
        FilterExpressionParser parser = new FilterExpressionParser(this.metaData, computedColumns);
        parser.setDataSetMode(this.isDataSetMode);
        parser.setResultSetPopulator(this.rsPopulator);
        for (int i = 0; i < filters.size(); ++i) {
            try {
                baseExpression = ((FilterDefinition)filters.get(i)).getExpression();
                if (baseExpression instanceof IConditionalExpression) {
                    IConditionalExpression condition = (IConditionalExpression)baseExpression;
                    operator = condition.getExpression();
                    if (operator != null) {
                        expression = operator.getText();
                        operator.setHandle(parser.compileFilterExpression(expression));
                    }
                    if ((operator = condition.getOperand1()) != null) {
                        expression = operator.getText();
                        operator.setHandle(parser.compileFilterExpression(expression));
                    }
                    if ((operator = condition.getOperand2()) != null) {
                        expression = operator.getText();
                        operator.setHandle(parser.compileFilterExpression(expression));
                    }
                    continue;
                }
                if (baseExpression instanceof IScriptExpression) {
                    operator = (IScriptExpression)baseExpression;
                    if (baseExpression != null && operator != null) {
                        expression = operator.getText();
                        baseExpression.setHandle(parser.compileFilterExpression(expression));
                    }
                    continue;
                }
                throw new DataException("data.engine.BadFilterExpr");
            }
            catch (DataException e) {
                DataException dataException = new DataException("data.engine.BadFilterExpr", (Throwable)((Object)e), new Object[]{expression});
                throw dataException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileExpression(IComputedColumnsState iccStates) {
        IBaseExpression baseExpression = null;
        this.computedColumnState = iccStates;
        Context context = Context.enter();
        this.helper.useResultSetMetaData(false);
        try {
            for (int i = 0; i < iccStates.getCount(); ++i) {
                if (!iccStates.isValueAvailable(i)) {
                    baseExpression = this.computedColumnState.getExpression(i);
                    if (baseExpression instanceof IScriptExpression) {
                        this.compileScriptExpression((IScriptExpression)baseExpression, context);
                    } else if (baseExpression instanceof IConditionalExpression) {
                        this.compileConditionalExpression((IConditionalExpression)baseExpression, context);
                    }
                }
                if (this.helper.getExpressionPassLevel() <= 1) {
                    if (this.tempRefactorCmpList == null) {
                        this.tempRefactorCmpList = new ArrayList();
                    }
                } else {
                    this.helper.resetPassLevel();
                    this.helper.setExpressionType(this.exprType, 0);
                    return;
                }
                this.tempRefactorCmpList.add(new Integer(i));
                this.helper.setExpressionType(this.exprType, 0);
                this.helper.resetPassLevel();
            }
        }
        finally {
            Context.exit();
        }
    }

    public boolean hasAggregateExpr(List list) throws DataException {
        boolean hasAggregate = false;
        this.helper.setAggregateStatus(hasAggregate);
        IBaseExpression baseExpression = null;
        for (int i = 0; i < list.size(); ++i) {
            baseExpression = (IBaseExpression)list.get(i);
            this.compileBaseExpression(baseExpression);
        }
        hasAggregate = this.helper.getAggregateStatus();
        this.clear();
        return hasAggregate;
    }

    public boolean hasAggregation(IBaseExpression expression) throws DataException {
        boolean hasAggregate = false;
        IBaseExpression baseExpression = expression;
        this.compileBaseExpression(baseExpression);
        hasAggregate = this.helper.getAggregateStatus();
        this.clear();
        return hasAggregate;
    }

    public void calculate() throws DataException {
        List aggrList = this.helper.getAggregateList(1);
        AggregateTable table = this.helper.getAggregateTable();
        if (aggrList == null || table == null) {
            this.setExpressionState();
            return;
        }
        AggregateCalculator calculator = new AggregateCalculator(table, this.resultIterator);
        if (this.helper.hasNestedAggregate()) {
            calculator.populateValue((AggregateCalculator.JSAggrValueObject)this.dataSet.getJSTempAggrValueObject());
        }
        Scriptable aggrObj = calculator.getJSAggrValueObject();
        this.dataSet.setJSTempAggrValueObject(aggrObj);
        calculator.calculate(this.dataSet.getScriptScope());
        for (int i = 0; i < aggrList.size(); ++i) {
            AggregateObject obj = (AggregateObject)aggrList.get(i);
            obj.setAvailable(true);
            this.helper.addAvailableAggregateObj(obj);
        }
        this.setExpressionState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate(Object[] exprArray, int[] groupArray, int arrayType) throws DataException {
        if (!$assertionsDisabled && exprArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && groupArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && exprArray.length != groupArray.length) {
            throw new AssertionError();
        }
        IBaseExpression baseExpression = null;
        int level = this.helper.getCurrentGroupLevel();
        int exprType = this.helper.getCurrentExpressionType();
        Context context = Context.enter();
        try {
            for (int i = 0; i < exprArray.length; ++i) {
                baseExpression = (IBaseExpression)exprArray[i];
                int groupLevel = groupArray[i];
                this.helper.setExpressionType(arrayType, groupLevel);
                if (baseExpression instanceof IConditionalExpression) {
                    IConditionalExpression condition = (IConditionalExpression)baseExpression;
                    IScriptExpression op = condition.getExpression();
                    IScriptExpression op1 = condition.getOperand1();
                    IScriptExpression op2 = condition.getOperand2();
                    if (op != null) {
                        op.setHandle(this.helper.compileExpression(op, context));
                    }
                    if (op1 != null) {
                        op1.setHandle(this.helper.compileExpression(op1, context));
                    }
                    if (op2 == null) continue;
                    op2.setHandle(this.helper.compileExpression(op2, context));
                    continue;
                }
                if (!(baseExpression instanceof IScriptExpression)) continue;
                IScriptExpression scriptExpr = (IScriptExpression)baseExpression;
                scriptExpr.setHandle(this.helper.compileExpression(scriptExpr, context));
            }
        }
        finally {
            Context.exit();
        }
        this.calculate();
        this.helper.setExpressionType(exprType, level);
    }

    private void compileScriptExpression(IScriptExpression scriptExpr, Context cx) {
        IScriptExpression cmptdColumn = scriptExpr;
        if (cmptdColumn.getText() == null || cmptdColumn.getText().trim().length() == 0) {
            DataException dataException = new DataException("data.engine.EmptyExpression");
            cmptdColumn.setHandle(new InvalidExpression(dataException));
            return;
        }
        try {
            CompiledExpression expr = this.helper.compileExpression(scriptExpr, cx);
            cmptdColumn.setHandle(expr);
        }
        catch (Exception e) {
            DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, scriptExpr.getText());
            cmptdColumn.setHandle(new InvalidExpression(dataException));
        }
    }

    private void compileConditionalExpression(IConditionalExpression baseExpression, Context context) {
        IConditionalExpression condition = baseExpression;
        IScriptExpression operator = null;
        try {
            operator = condition.getExpression();
            if (operator != null) {
                operator.setHandle(this.helper.compileExpression(operator, context));
            }
            if ((operator = condition.getOperand1()) != null) {
                operator.setHandle(this.helper.compileExpression(operator, context));
            }
            if ((operator = condition.getOperand2()) != null) {
                operator.setHandle(this.helper.compileExpression(operator, context));
            }
        }
        catch (Exception e) {
            DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, operator.getText());
            operator.setHandle(new InvalidExpression(dataException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileBaseExpression(IBaseExpression baseExpression) throws DataException {
        Context context = Context.enter();
        try {
            if (baseExpression instanceof IConditionalExpression) {
                IConditionalExpression condition = (IConditionalExpression)baseExpression;
                IScriptExpression op = condition.getExpression();
                IScriptExpression op1 = condition.getOperand1();
                IScriptExpression op2 = condition.getOperand2();
                if (op != null) {
                    this.helper.compileExpression(op, context);
                }
                if (op1 != null) {
                    this.helper.compileExpression(op1, context);
                }
                if (op2 != null) {
                    this.helper.compileExpression(op2, context);
                }
            } else if (baseExpression instanceof IScriptExpression) {
                IScriptExpression scriptExpr = (IScriptExpression)baseExpression;
                this.helper.compileExpression(scriptExpr, context);
            }
        }
        finally {
            Context.exit();
        }
    }

    private void setExpressionState() {
        if (this.tempRefactorCmpList != null) {
            for (int i = 0; i < this.tempRefactorCmpList.size(); ++i) {
                int index = (Integer)this.tempRefactorCmpList.get(i);
                this.helper.addAvailableCmpColumn(this.computedColumnState.getName(index));
                this.computedColumnState.setValueAvailable(index);
            }
        }
    }

    private int getCurrentGroupLevel(String groupText, int start) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.query == null) {
            throw new AssertionError();
        }
        IQuery.GroupSpec[] groups = this.query.getGrouping();
        for (int i = start; i < groups.length; ++i) {
            IQuery.GroupSpec group = groups[i];
            if (!groupText.equals(group.getName()) && !groupText.equals(group.getKeyColumn())) continue;
            return i + 1;
        }
        return -1;
    }

    public void clear() {
        this.tempRefactorCmpList = null;
        this.exprType = 0;
        if (this.helper != null) {
            this.helper.clear();
        }
    }

    public void prepareComputedColumns(IComputedColumnsState iccState) {
        this.computedColumnState = iccState;
        for (int i = 0; i < iccState.getCount(); ++i) {
            if (!iccState.isValueAvailable(i)) continue;
            this.helper.addAvailableCmpColumn(iccState.getName(i));
        }
    }

    public void setDataSetMode(boolean isDataSetMode) {
        this.isDataSetMode = isDataSetMode;
        this.helper.setDataSetMode(isDataSetMode);
    }

    static {
        $assertionsDisabled = !ExpressionProcessor.class.desiredAssertionStatus();
    }
}

